/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionWindow;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionWindowFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.SortedCompactionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.util.DNS;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.PeekingIterator;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.math.LongMath;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class DateTieredCompactionPolicy
extends SortedCompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DateTieredCompactionPolicy.class);
    private final RatioBasedCompactionPolicy compactionPolicyPerWindow;
    private final CompactionWindowFactory windowFactory;

    public DateTieredCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) throws IOException {
        super(conf, storeConfigInfo);
        try {
            this.compactionPolicyPerWindow = (RatioBasedCompactionPolicy)ReflectionUtils.instantiateWithCustomCtor(this.comConf.getCompactionPolicyForDateTieredWindow(), new Class[]{Configuration.class, StoreConfigInformation.class}, new Object[]{conf, storeConfigInfo});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured compaction policy '" + this.comConf.getCompactionPolicyForDateTieredWindow() + "'", e);
        }
        try {
            this.windowFactory = (CompactionWindowFactory)ReflectionUtils.instantiateWithCustomCtor(this.comConf.getDateTieredCompactionWindowFactory(), new Class[]{CompactionConfiguration.class}, new Object[]{this.comConf});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured window factory '" + this.comConf.getDateTieredCompactionWindowFactory() + "'", e);
        }
    }

    @Override
    @InterfaceAudience.Private
    public boolean needsCompaction(Collection<HStoreFile> storeFiles, List<HStoreFile> filesCompacting) {
        ArrayList<HStoreFile> candidates = new ArrayList<HStoreFile>(storeFiles);
        try {
            return !this.selectMinorCompaction(candidates, false, true).getFiles().isEmpty();
        }
        catch (Exception e) {
            LOG.error("Can not check for compaction: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<HStoreFile> filesToCompact) throws IOException {
        long mcTime = this.getNextMajorCompactTime(filesToCompact);
        if (filesToCompact == null || mcTime == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("filesToCompact: " + filesToCompact + " mcTime: " + mcTime);
            }
            return false;
        }
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = EnvironmentEdgeManager.currentTime();
        if (lowTimestamp <= 0L || lowTimestamp >= now - mcTime) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("lowTimestamp: " + lowTimestamp + " lowTimestamp: " + lowTimestamp + " now: " + now + " mcTime: " + mcTime);
            }
            return false;
        }
        long cfTTL = this.storeConfigInfo.getStoreFileTtl();
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        List<Long> boundaries = this.getCompactBoundariesForMajor(filesToCompact, now);
        boolean[] filesInWindow = new boolean[boundaries.size()];
        for (HStoreFile file : filesToCompact) {
            long oldest;
            OptionalLong minTimestamp = file.getMinimumTimestamp();
            long l = oldest = minTimestamp.isPresent() ? now - minTimestamp.getAsLong() : Long.MIN_VALUE;
            if (cfTTL != Long.MAX_VALUE && oldest >= cfTTL) {
                LOG.debug("Major compaction triggered on store " + this + "; for TTL maintenance");
                return true;
            }
            if (!file.isMajorCompactionResult() || file.isBulkLoadResult()) {
                LOG.debug("Major compaction triggered on store " + this + ", because there are new files and time since last major compaction " + (now - lowTimestamp) + "ms");
                return true;
            }
            int lowerWindowIndex = Collections.binarySearch(boundaries, minTimestamp.orElse(Long.MAX_VALUE));
            int upperWindowIndex = Collections.binarySearch(boundaries, file.getMaximumTimestamp().orElse(Long.MAX_VALUE));
            lowerWindowIndex = lowerWindowIndex < 0 ? Math.abs(lowerWindowIndex + 2) : lowerWindowIndex;
            int n = upperWindowIndex = upperWindowIndex < 0 ? Math.abs(upperWindowIndex + 2) : upperWindowIndex;
            if (lowerWindowIndex != upperWindowIndex) {
                LOG.debug("Major compaction triggered on store " + this + "; because file " + file.getPath() + " has data with timestamps cross window boundaries");
                return true;
            }
            if (filesInWindow[upperWindowIndex]) {
                LOG.debug("Major compaction triggered on store " + this + "; because there are more than one file in some windows");
                return true;
            }
            filesInWindow[upperWindowIndex] = true;
            hdfsBlocksDistribution.add(file.getHDFSBlockDistribution());
        }
        float blockLocalityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(DNS.getHostname(this.comConf.conf, DNS.ServerType.REGIONSERVER));
        if (blockLocalityIndex < this.comConf.getMinLocalityToForceCompact()) {
            LOG.debug("Major compaction triggered on store " + this + "; to make hdfs blocks local, current blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")");
            return true;
        }
        LOG.debug("Skipping major compaction of " + this + ", because the files are already major compacted");
        return false;
    }

    @Override
    protected CompactionRequestImpl createCompactionRequest(ArrayList<HStoreFile> candidateSelection, boolean tryingMajor, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        CompactionRequestImpl result;
        CompactionRequestImpl compactionRequestImpl = result = tryingMajor ? this.selectMajorCompaction(candidateSelection) : this.selectMinorCompaction(candidateSelection, mayUseOffPeak, mayBeStuck);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated compaction request: " + result);
        }
        return result;
    }

    public CompactionRequestImpl selectMajorCompaction(ArrayList<HStoreFile> candidateSelection) {
        long now = EnvironmentEdgeManager.currentTime();
        List<Long> boundaries = this.getCompactBoundariesForMajor(candidateSelection, now);
        Map<Long, String> boundariesPolicies = this.getBoundariesStoragePolicyForMajor(boundaries, now);
        return new DateTieredCompactionRequest(candidateSelection, boundaries, boundariesPolicies);
    }

    public CompactionRequestImpl selectMinorCompaction(ArrayList<HStoreFile> candidateSelection, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        long oldestToCompact = DateTieredCompactionPolicy.getOldestToCompact(this.comConf.getDateTieredMaxStoreFileAgeMillis(), now);
        ArrayList<Pair<HStoreFile, Long>> storefileMaxTimestampPairs = Lists.newArrayListWithCapacity(candidateSelection.size());
        long maxTimestampSeen = Long.MIN_VALUE;
        for (HStoreFile storeFile : candidateSelection) {
            maxTimestampSeen = Math.max(maxTimestampSeen, storeFile.getMaximumTimestamp().orElse(Long.MIN_VALUE));
            storefileMaxTimestampPairs.add(new Pair<HStoreFile, Long>(storeFile, maxTimestampSeen));
        }
        Collections.reverse(storefileMaxTimestampPairs);
        CompactionWindow window = this.getIncomingWindow(now);
        int minThreshold = this.comConf.getDateTieredIncomingWindowMin();
        PeekingIterator it = Iterators.peekingIterator(storefileMaxTimestampPairs.iterator());
        while (it.hasNext() && window.compareToTimestamp(oldestToCompact) >= 0) {
            DateTieredCompactionRequest request;
            int compResult = window.compareToTimestamp((Long)((Pair)it.peek()).getSecond());
            if (compResult > 0) {
                window = window.nextEarlierWindow();
                minThreshold = this.comConf.getMinFilesToCompact();
                continue;
            }
            ArrayList<HStoreFile> fileList = Lists.newArrayList();
            while (it.hasNext() && window.compareToTimestamp((Long)((Pair)it.peek()).getSecond()) <= 0) {
                fileList.add((HStoreFile)((Pair)it.next()).getFirst());
            }
            if (fileList.size() < minThreshold) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing files: " + fileList + " for window: " + window);
            }
            if ((request = this.generateCompactionRequest(fileList, window, mayUseOffPeak, mayBeStuck, minThreshold, now)) == null) continue;
            return request;
        }
        return new CompactionRequestImpl(Collections.emptyList());
    }

    private DateTieredCompactionRequest generateCompactionRequest(ArrayList<HStoreFile> storeFiles, CompactionWindow window, boolean mayUseOffPeak, boolean mayBeStuck, int minThreshold, long now) throws IOException {
        ArrayList<HStoreFile> storeFileSelection;
        Collections.reverse(storeFiles);
        this.compactionPolicyPerWindow.setMinThreshold(minThreshold);
        ArrayList<HStoreFile> arrayList = storeFileSelection = mayBeStuck ? storeFiles : this.compactionPolicyPerWindow.applyCompactionPolicy(storeFiles, mayUseOffPeak, false);
        if (storeFileSelection != null && !storeFileSelection.isEmpty()) {
            boolean singleOutput = storeFiles.size() != storeFileSelection.size() || this.comConf.useDateTieredSingleOutputForMinorCompaction();
            List<Long> boundaries = DateTieredCompactionPolicy.getCompactionBoundariesForMinor(window, singleOutput);
            Map<Long, String> boundaryPolicyMap = this.getBoundariesStoragePolicyForMinor(singleOutput, window, now);
            DateTieredCompactionRequest result = new DateTieredCompactionRequest(storeFileSelection, boundaries, boundaryPolicyMap);
            return result;
        }
        return null;
    }

    private List<Long> getCompactBoundariesForMajor(Collection<HStoreFile> filesToCompact, long now) {
        long minTimestamp = filesToCompact.stream().mapToLong(f -> f.getMinimumTimestamp().orElse(Long.MAX_VALUE)).min().orElse(Long.MAX_VALUE);
        ArrayList<Long> boundaries = new ArrayList<Long>();
        CompactionWindow window = this.getIncomingWindow(now);
        while (window.compareToTimestamp(minTimestamp) > 0) {
            boundaries.add(window.startMillis());
            window = window.nextEarlierWindow();
        }
        boundaries.add(Long.MIN_VALUE);
        Collections.reverse(boundaries);
        return boundaries;
    }

    private static List<Long> getCompactionBoundariesForMinor(CompactionWindow window, boolean singleOutput) {
        ArrayList<Long> boundaries = new ArrayList<Long>();
        boundaries.add(Long.MIN_VALUE);
        if (!singleOutput) {
            boundaries.add(window.startMillis());
        }
        return boundaries;
    }

    private CompactionWindow getIncomingWindow(long now) {
        return this.windowFactory.newIncomingWindow(now);
    }

    private static long getOldestToCompact(long maxAgeMillis, long now) {
        try {
            return LongMath.checkedSubtract(now, maxAgeMillis);
        }
        catch (ArithmeticException ae) {
            LOG.warn("Value for hbase.hstore.compaction.date.tiered.max.storefile.age.millis: " + maxAgeMillis + ". All the files will be eligible for minor compaction.");
            return Long.MIN_VALUE;
        }
    }

    private Map<Long, String> getBoundariesStoragePolicyForMinor(boolean singleOutput, CompactionWindow window, long now) {
        HashMap<Long, String> boundariesPolicy = new HashMap<Long, String>();
        if (!this.comConf.isDateTieredStoragePolicyEnable()) {
            return boundariesPolicy;
        }
        String windowStoragePolicy = this.getWindowStoragePolicy(now, window.startMillis());
        if (singleOutput) {
            boundariesPolicy.put(Long.MIN_VALUE, windowStoragePolicy);
        } else {
            boundariesPolicy.put(window.startMillis(), windowStoragePolicy);
        }
        return boundariesPolicy;
    }

    private Map<Long, String> getBoundariesStoragePolicyForMajor(List<Long> boundaries, long now) {
        HashMap<Long, String> boundariesPolicy = new HashMap<Long, String>();
        if (!this.comConf.isDateTieredStoragePolicyEnable()) {
            return boundariesPolicy;
        }
        for (Long startTs : boundaries) {
            boundariesPolicy.put(startTs, this.getWindowStoragePolicy(now, startTs));
        }
        return boundariesPolicy;
    }

    private String getWindowStoragePolicy(long now, long windowStartMillis) {
        if (windowStartMillis >= now - this.comConf.getHotWindowAgeMillis()) {
            return this.comConf.getHotWindowStoragePolicy();
        }
        if (windowStartMillis >= now - this.comConf.getWarmWindowAgeMillis()) {
            return this.comConf.getWarmWindowStoragePolicy();
        }
        return this.comConf.getColdWindowStoragePolicy();
    }
}

