/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.SharedConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorServiceBackwardCompatiblity;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionServerCoprocessorHost
extends CoprocessorHost<RegionServerCoprocessor, RegionServerCoprocessorEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerCoprocessorHost.class);
    private RegionServerServices rsServices;
    private CoprocessorHost.ObserverGetter<RegionServerCoprocessor, RegionServerObserver> rsObserverGetter = RegionServerCoprocessor::getRegionServerObserver;

    public RegionServerCoprocessorHost(RegionServerServices rsServices, Configuration conf) {
        super(rsServices);
        this.rsServices = rsServices;
        this.conf = conf;
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        boolean tableCoprocessorsEnabled = conf.getBoolean("hbase.coprocessor.user.enabled", true);
        LOG.info("System coprocessor loading is " + (coprocessorsEnabled ? "enabled" : "disabled"));
        LOG.info("Table coprocessor loading is " + (coprocessorsEnabled && tableCoprocessorsEnabled ? "enabled" : "disabled"));
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.regionserver.classes");
    }

    @Override
    public RegionServerEnvironment createEnvironment(RegionServerCoprocessor instance, int priority, int sequence, Configuration conf) {
        return instance.getClass().isAnnotationPresent(CoreCoprocessor.class) ? new RegionServerEnvironmentForCoreCoprocessors(instance, priority, sequence, conf, this.rsServices) : new RegionServerEnvironment(instance, priority, sequence, conf, this.rsServices);
    }

    @Override
    public RegionServerCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
        try {
            if (RegionServerCoprocessor.class.isAssignableFrom(implClass)) {
                return implClass.asSubclass(RegionServerCoprocessor.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (SingletonCoprocessorService.class.isAssignableFrom(implClass)) {
                SingletonCoprocessorService tmp = implClass.asSubclass(SingletonCoprocessorService.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new CoprocessorServiceBackwardCompatiblity.RegionServerCoprocessorService(tmp);
            }
            LOG.error("{} is not of type RegionServerCoprocessor. Check the configuration of {}", (Object)implClass.getName(), (Object)"hbase.coprocessor.regionserver.classes");
            return null;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw (InstantiationException)new InstantiationException(implClass.getName()).initCause(e);
        }
    }

    public void preStop(String message, User user) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execShutdown(new RegionServerObserverOperation(user){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preStopRegionServer(this);
            }

            @Override
            public void postEnvCall() {
                RegionServerCoprocessorHost.this.shutdown(this.getEnvironment());
            }
        });
    }

    public void preRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preRollWALWriterRequest(this);
            }
        });
    }

    public void postRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postRollWALWriterRequest(this);
            }
        });
    }

    public void preReplicateLogEntries() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preReplicateLogEntries(this);
            }
        });
    }

    public void postReplicateLogEntries() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postReplicateLogEntries(this);
            }
        });
    }

    public ReplicationEndpoint postCreateReplicationEndPoint(ReplicationEndpoint endpoint) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return endpoint;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionServerObserver, ReplicationEndpoint>(this.rsObserverGetter, endpoint){

            @Override
            public ReplicationEndpoint call(RegionServerObserver observer) throws IOException {
                return observer.postCreateReplicationEndPoint(this, (ReplicationEndpoint)this.getResult());
            }
        });
    }

    public void preClearCompactionQueues() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preClearCompactionQueues(this);
            }
        });
    }

    public void postClearCompactionQueues() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postClearCompactionQueues(this);
            }
        });
    }

    public void preExecuteProcedures() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preExecuteProcedures(this);
            }
        });
    }

    public void postExecuteProcedures() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postExecuteProcedures(this);
            }
        });
    }

    private static class RegionServerEnvironmentForCoreCoprocessors
    extends RegionServerEnvironment
    implements HasRegionServerServices {
        final RegionServerServices regionServerServices;

        public RegionServerEnvironmentForCoreCoprocessors(RegionServerCoprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf, services);
            this.regionServerServices = services;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.regionServerServices;
        }
    }

    private static class RegionServerEnvironment
    extends BaseEnvironment<RegionServerCoprocessor>
    implements RegionServerCoprocessorEnvironment {
        private final MetricRegistry metricRegistry;
        private final RegionServerServices services;

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Intentional; FB has trouble detecting isAssignableFrom")
        public RegionServerEnvironment(RegionServerCoprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf);
            for (Service service : impl.getServices()) {
                services.registerService(service);
            }
            this.services = services;
            this.metricRegistry = MetricsCoprocessor.createRegistryForRSCoprocessor(impl.getClass().getName());
        }

        @Override
        public OnlineRegions getOnlineRegions() {
            return this.services;
        }

        @Override
        public ServerName getServerName() {
            return this.services.getServerName();
        }

        @Override
        public Connection getConnection() {
            return new SharedConnection(this.services.getConnection());
        }

        @Override
        public Connection createConnection(Configuration conf) throws IOException {
            return this.services.createConnection(conf);
        }

        @Override
        public MetricRegistry getMetricRegistryForRegionServer() {
            return this.metricRegistry;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }
    }

    abstract class RegionServerObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<RegionServerObserver> {
        public RegionServerObserverOperation() {
            super(RegionServerCoprocessorHost.this.rsObserverGetter);
        }

        public RegionServerObserverOperation(User user) {
            super(RegionServerCoprocessorHost.this.rsObserverGetter, user);
        }
    }
}

