/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileReaderImpl;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFilePreadReader
extends HFileReaderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HFileReaderImpl.class);

    public HFilePreadReader(ReaderContext context, HFileInfo fileInfo, CacheConfig cacheConf, Configuration conf) throws IOException {
        super(context, fileInfo, cacheConf, conf);
        if (cacheConf.shouldPrefetchOnOpen()) {
            PrefetchExecutor.request(this.path, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long offset = 0L;
                    long end = 0L;
                    try {
                        end = HFilePreadReader.this.getTrailer().getLoadOnOpenDataOffset();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Prefetch start " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end));
                        }
                        long onDiskSizeOfNextBlock = -1L;
                        while (offset < end) {
                            if (Thread.interrupted()) {
                                break;
                            }
                            HFileBlock block = HFilePreadReader.this.readBlock(offset, onDiskSizeOfNextBlock, true, true, false, false, null, null);
                            try {
                                onDiskSizeOfNextBlock = block.getNextBlockOnDiskSize();
                                offset += (long)block.getOnDiskSizeWithHeader();
                            }
                            finally {
                                block.release();
                            }
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Prefetch " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end), (Throwable)e);
                        }
                    }
                    catch (NullPointerException e) {
                        LOG.warn("Stream moved/closed or prefetch cancelled?" + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.warn("Prefetch " + HFilePreadReader.getPathOffsetEndStr(HFilePreadReader.this.path, offset, end), (Throwable)e);
                    }
                    finally {
                        PrefetchExecutor.complete(HFilePreadReader.this.path);
                    }
                }
            });
        }
    }

    private static String getPathOffsetEndStr(Path path, long offset, long end) {
        return "path=" + path.toString() + ", offset=" + offset + ", end=" + end;
    }

    @Override
    public void close(boolean evictOnClose) throws IOException {
        PrefetchExecutor.cancel(this.path);
        this.fileInfo.close();
        this.cacheConf.getBlockCache().ifPresent(cache -> {
            if (evictOnClose) {
                int numEvicted = cache.evictBlocksByHfileName(this.name);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("On close, file=" + this.name + " evicted=" + numEvicted + " block(s)");
                }
            }
        });
        this.fsBlockReader.closeStreams();
    }
}

