/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hudi.org.apache.commons.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hudi.org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.BlockIOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileBlockDefaultDecodingContext
implements HFileBlockDecodingContext {
    private final HFileContext fileContext;
    private TagCompressionContext tagCompressionContext;

    public HFileBlockDefaultDecodingContext(HFileContext fileContext) {
        this.fileContext = fileContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareDecoding(int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, ByteBuff blockBufferWithoutHeader, ByteBuff onDiskBlock) throws IOException {
        ByteBuffInputStream byteBuffInputStream = new ByteBuffInputStream(onDiskBlock);
        InputStream dataInputStream = new DataInputStream(byteBuffInputStream);
        try {
            Compression.Algorithm compression;
            Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
            if (cryptoContext != Encryption.Context.NONE) {
                Cipher cipher = cryptoContext.getCipher();
                Decryptor decryptor = cipher.getDecryptor();
                decryptor.setKey(cryptoContext.getKey());
                int ivLength = ((InputStream)dataInputStream).read();
                if (ivLength > 0) {
                    byte[] iv = new byte[ivLength];
                    IOUtils.readFully(dataInputStream, iv);
                    decryptor.setIv(iv);
                    decryptor.reset();
                    dataInputStream = decryptor.createDecryptionStream(dataInputStream);
                }
                onDiskSizeWithoutHeader -= 1 + ivLength;
            }
            if ((compression = this.fileContext.getCompression()) != Compression.Algorithm.NONE) {
                Compression.decompress(blockBufferWithoutHeader, dataInputStream, uncompressedSizeWithoutHeader, compression);
            } else {
                BlockIOUtils.readFullyWithHeapBuffer(dataInputStream, blockBufferWithoutHeader, onDiskSizeWithoutHeader);
            }
        }
        finally {
            byteBuffInputStream.close();
            ((InputStream)dataInputStream).close();
        }
    }

    @Override
    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    public TagCompressionContext getTagCompressionContext() {
        return this.tagCompressionContext;
    }

    public void setTagCompressionContext(TagCompressionContext tagCompressionContext) {
        this.tagCompressionContext = tagCompressionContext;
    }
}

