/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Coprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ReadOnlyConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BaseEnvironment<C extends Coprocessor>
implements CoprocessorEnvironment<C> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEnvironment.class);
    public C impl;
    protected int priority = 0x3FFFFFFF;
    Coprocessor.State state = Coprocessor.State.UNINSTALLED;
    private int seq;
    private Configuration conf;
    private ClassLoader classLoader;

    public BaseEnvironment(C impl, int priority, int seq, Configuration conf) {
        this.impl = impl;
        this.classLoader = impl.getClass().getClassLoader();
        this.priority = priority;
        this.state = Coprocessor.State.INSTALLED;
        this.seq = seq;
        this.conf = new ReadOnlyConfiguration(conf);
    }

    public void startup() throws IOException {
        if (this.state == Coprocessor.State.INSTALLED || this.state == Coprocessor.State.STOPPED) {
            this.state = Coprocessor.State.STARTING;
            Thread currentThread = Thread.currentThread();
            ClassLoader hostClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.getClassLoader());
                this.impl.start(this);
                this.state = Coprocessor.State.ACTIVE;
            }
            finally {
                currentThread.setContextClassLoader(hostClassLoader);
            }
        } else {
            LOG.warn("Not starting coprocessor " + this.impl.getClass().getName() + " because not inactive (state=" + this.state.toString() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.state == Coprocessor.State.ACTIVE) {
            this.state = Coprocessor.State.STOPPING;
            Thread currentThread = Thread.currentThread();
            ClassLoader hostClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.getClassLoader());
                this.impl.stop(this);
                this.state = Coprocessor.State.STOPPED;
            }
            catch (IOException ioe) {
                LOG.error("Error stopping coprocessor " + this.impl.getClass().getName(), (Throwable)ioe);
            }
            finally {
                currentThread.setContextClassLoader(hostClassLoader);
            }
        } else {
            LOG.warn("Not stopping coprocessor " + this.impl.getClass().getName() + " because not active (state=" + this.state.toString() + ")");
        }
    }

    @Override
    public C getInstance() {
        return this.impl;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getLoadSequence() {
        return this.seq;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String getHBaseVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }
}

