/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Random;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientIdGenerator;
import org.apache.hudi.org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class PerClientRandomNonceGenerator
implements NonceGenerator {
    private static final PerClientRandomNonceGenerator INST = new PerClientRandomNonceGenerator();
    private final Random rdm = new Random();
    private final long clientId;

    private PerClientRandomNonceGenerator() {
        byte[] clientIdBase = ClientIdGenerator.generateClientId();
        this.clientId = ((long)Arrays.hashCode(clientIdBase) << 32) + (long)this.rdm.nextInt();
    }

    @Override
    public long getNonceGroup() {
        return this.clientId;
    }

    @Override
    public long newNonce() {
        long result = 0L;
        while ((result = this.rdm.nextLong()) == 0L) {
        }
        return result;
    }

    public static PerClientRandomNonceGenerator get() {
        return INST;
    }
}

