/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.backup.example;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileArchiveTableMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(HFileArchiveTableMonitor.class);
    private final Set<String> archivedTables = new TreeSet<String>();

    public synchronized void setArchiveTables(List<String> tables) {
        this.archivedTables.clear();
        this.archivedTables.addAll(tables);
    }

    public synchronized void addTable(String table) {
        if (this.shouldArchiveTable(table)) {
            LOG.debug("Already archiving table: " + table + ", ignoring it");
            return;
        }
        this.archivedTables.add(table);
    }

    public synchronized void removeTable(String table) {
        this.archivedTables.remove(table);
    }

    public synchronized void clearArchive() {
        this.archivedTables.clear();
    }

    public synchronized boolean shouldArchiveTable(String tableName) {
        return this.archivedTables.contains(tableName);
    }
}

