/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public interface HoodieFileReader<R extends IndexedRecord>
extends AutoCloseable {
    public String[] readMinMaxRecordKeys();

    public BloomFilter readBloomFilter();

    public Set<String> filterRowKeys(Set<String> var1);

    public ClosableIterator<R> getRecordIterator(Schema var1) throws IOException;

    default public ClosableIterator<R> getRecordIterator() throws IOException {
        return this.getRecordIterator(this.getSchema());
    }

    default public Option<R> getRecordByKey(String key, Schema readerSchema) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Option<R> getRecordByKey(String key) throws IOException {
        return this.getRecordByKey(key, this.getSchema());
    }

    default public ClosableIterator<R> getRecordsByKeysIterator(List<String> keys2, Schema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public ClosableIterator<R> getRecordsByKeysIterator(List<String> keys2) throws IOException {
        return this.getRecordsByKeysIterator(keys2, this.getSchema());
    }

    default public ClosableIterator<R> getRecordsByKeyPrefixIterator(List<String> keyPrefixes, Schema schema) throws IOException {
        throw new UnsupportedEncodingException();
    }

    default public ClosableIterator<R> getRecordsByKeyPrefixIterator(List<String> keyPrefixes) throws IOException {
        return this.getRecordsByKeyPrefixIterator(keyPrefixes, this.getSchema());
    }

    public Schema getSchema();

    @Override
    public void close();

    public long getTotalRecords();
}

