/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@NotThreadSafe
public class HoodieCreateHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieCreateHandle.class);
    protected final HoodieFileWriter<IndexedRecord> fileWriter;
    protected final Path path;
    protected long recordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    protected long recordsDeleted = 0L;
    private Map<String, HoodieRecord<T>> recordMap;
    private boolean useWriterSchema = false;
    private final boolean preserveMetadata;

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, Option.empty(), taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, Option.empty(), taskContextSupplier, preserveMetadata);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, overriddenSchema, taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, overriddenSchema, taskContextSupplier);
        this.preserveMetadata = preserveMetadata;
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setStat(new HoodieWriteStat());
        this.path = this.makeNewPath(partitionPath);
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, instantTime, new Path(config.getBasePath()), FSUtils.getPartitionPath(config.getBasePath(), partitionPath), hoodieTable.getPartitionMetafileFormat());
            partitionMetadata.trySave(this.getPartitionId());
            this.createMarkerFile(partitionPath, FSUtils.makeBaseFileName(this.instantTime, this.writeToken, this.fileId, hoodieTable.getBaseFileExtension()));
            this.fileWriter = HoodieFileWriterFactory.getFileWriter(instantTime, this.path, hoodieTable, config, this.writeSchemaWithMetaFields, this.taskContextSupplier);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize HoodieStorageWriter for path " + this.path, e);
        }
        LOG.info((Object)("New CreateHandle for partition :" + partitionPath + " with fileId " + fileId));
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Map<String, HoodieRecord<T>> recordMap, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, taskContextSupplier, config.isPreserveHoodieCommitMetadataForCompaction());
        this.recordMap = recordMap;
        this.useWriterSchema = true;
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return this.fileWriter.canWrite() && record.getPartitionPath().equals(this.writeStatus.getPartitionPath()) || this.layoutControlsNumFiles();
    }

    @Override
    public void write(HoodieRecord record, Option<IndexedRecord> avroRecord) {
        Option<Map<String, String>> recordMetadata = ((HoodieRecordPayload)record.getData()).getMetadata();
        if (HoodieOperation.isDelete(record.getOperation())) {
            avroRecord = Option.empty();
        }
        try {
            if (avroRecord.isPresent()) {
                if (avroRecord.get().equals(IGNORE_RECORD)) {
                    return;
                }
                if (this.preserveMetadata) {
                    this.fileWriter.writeAvro(record.getRecordKey(), this.rewriteRecordWithMetadata((GenericRecord)avroRecord.get(), this.path.getName()));
                } else {
                    this.fileWriter.writeAvroWithMetadata(record.getKey(), this.rewriteRecord((GenericRecord)avroRecord.get()));
                }
                record.unseal();
                record.setNewLocation(new HoodieRecordLocation(this.instantTime, this.writeStatus.getFileId()));
                record.seal();
                ++this.recordsWritten;
                ++this.insertRecordsWritten;
            } else {
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(record, recordMetadata);
            record.deflate();
        }
        catch (Throwable t) {
            this.writeStatus.markFailure(record, t, recordMetadata);
            LOG.error((Object)("Error writing record " + record), t);
        }
    }

    public void write() {
        Iterator keyIterator = this.hoodieTable.requireSortedRecords() ? this.recordMap.keySet().stream().sorted().iterator() : this.recordMap.keySet().stream().iterator();
        try {
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                HoodieRecord<T> record = this.recordMap.get(key);
                if (this.useWriterSchema) {
                    this.write(record, ((HoodieRecordPayload)record.getData()).getInsertValue(this.tableSchemaWithMetaFields, this.config.getProps()));
                    continue;
                }
                this.write(record, ((HoodieRecordPayload)record.getData()).getInsertValue(this.tableSchema, this.config.getProps()));
            }
        }
        catch (IOException io) {
            throw new HoodieInsertException("Failed to insert records for path " + this.path, io);
        }
    }

    @Override
    public IOType getIOType() {
        return IOType.CREATE;
    }

    @Override
    public List<WriteStatus> close() {
        LOG.info((Object)("Closing the file " + this.writeStatus.getFileId() + " as we are done with all the records " + this.recordsWritten));
        try {
            this.fileWriter.close();
            this.setupWriteStatus();
            LOG.info((Object)String.format("CreateHandle for partitionPath %s fileID %s, took %d ms.", this.writeStatus.getStat().getPartitionPath(), this.writeStatus.getStat().getFileId(), this.writeStatus.getStat().getRuntimeStats().getTotalCreateTime()));
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to close the Insert Handle for path " + this.path, e);
        }
    }

    protected void setupWriteStatus() throws IOException {
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.writeStatus.getPartitionPath());
        stat.setNumWrites(this.recordsWritten);
        stat.setNumDeletes(this.recordsDeleted);
        stat.setNumInserts(this.insertRecordsWritten);
        stat.setPrevCommit("null");
        stat.setFileId(this.writeStatus.getFileId());
        stat.setPath(new Path(this.config.getBasePath()), this.path);
        stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
        long fileSize = FSUtils.getFileSize(this.fs, this.path);
        stat.setTotalWriteBytes(fileSize);
        stat.setFileSizeInBytes(fileSize);
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.timer.endTimer());
        stat.setRuntimeStats(runtimeStats);
    }
}

