/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class InternalSchema
implements Serializable {
    private static final long DEFAULT_VERSION_ID = 0L;
    private final Types.RecordType record;
    private int maxColumnId;
    private long versionId;
    private transient Map<Integer, Types.Field> idToField = null;
    private transient Map<String, Integer> nameToId = null;
    private transient Map<Integer, String> idToName = null;

    public static InternalSchema getEmptyInternalSchema() {
        return new InternalSchema(-1L, new ArrayList<Types.Field>());
    }

    public boolean isEmptySchema() {
        return this.versionId < 0L;
    }

    public InternalSchema(List<Types.Field> columns) {
        this(0L, columns);
    }

    public InternalSchema(Types.Field ... columns) {
        this(0L, Arrays.asList(columns));
    }

    public InternalSchema(long versionId, List<Types.Field> cols) {
        this.versionId = versionId;
        this.record = Types.RecordType.get(cols);
        this.idToName = cols.isEmpty() ? new HashMap() : InternalSchemaBuilder.getBuilder().buildIdToName(this.record);
        this.nameToId = cols.isEmpty() ? new HashMap<String, Integer>() : this.idToName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.maxColumnId = this.idToName.isEmpty() ? -1 : this.idToName.keySet().stream().max(Comparator.comparing(Integer::valueOf)).get();
    }

    public InternalSchema(long versionId, int maxColumnId, List<Types.Field> cols) {
        this.maxColumnId = maxColumnId;
        this.versionId = versionId;
        this.record = Types.RecordType.get(cols);
        this.buildIdToName();
    }

    public InternalSchema(long versionId, int maxColumnId, Types.Field ... cols) {
        this(versionId, maxColumnId, Arrays.asList(cols));
    }

    public Types.RecordType getRecord() {
        return this.record;
    }

    private Map<Integer, String> buildIdToName() {
        if (this.idToName == null) {
            this.idToName = InternalSchemaBuilder.getBuilder().buildIdToName(this.record);
        }
        return this.idToName;
    }

    private Map<String, Integer> buildNameToId() {
        if (this.nameToId == null) {
            if (this.idToName != null && !this.idToName.isEmpty()) {
                this.nameToId = this.idToName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                return this.nameToId;
            }
            this.nameToId = InternalSchemaBuilder.getBuilder().buildNameToId(this.record);
        }
        return this.nameToId;
    }

    private Map<Integer, Types.Field> buildIdToField() {
        if (this.idToField == null) {
            this.idToField = InternalSchemaBuilder.getBuilder().buildIdToField(this.record);
        }
        return this.idToField;
    }

    public List<String> getAllColsFullName() {
        if (this.nameToId == null) {
            this.nameToId = InternalSchemaBuilder.getBuilder().buildNameToId(this.record);
        }
        return Arrays.asList(this.nameToId.keySet().toArray(new String[0]));
    }

    public InternalSchema setSchemaId(long versionId) {
        this.versionId = versionId;
        return this;
    }

    public long schemaId() {
        return this.versionId;
    }

    public void setMaxColumnId(int maxColumnId) {
        this.maxColumnId = maxColumnId;
    }

    public int getMaxColumnId() {
        return this.maxColumnId;
    }

    public List<Types.Field> columns() {
        return this.record.fields();
    }

    public String findfullName(int id) {
        String result;
        if (this.idToName == null) {
            this.buildIdToName();
        }
        return (result = this.idToName.get(id)) == null ? "" : result;
    }

    public Type findType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Integer id = this.buildNameToId().get(name);
        if (id != null) {
            return this.findType(id);
        }
        return null;
    }

    public Type findType(int id) {
        Types.Field field = this.buildIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Set<Integer> getAllIds() {
        if (this.idToName == null) {
            this.buildIdToName();
        }
        return this.idToName.keySet();
    }

    public Types.Field findField(int id) {
        return this.buildIdToField().get(id);
    }

    public Types.Field findField(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Integer id = this.buildNameToId().get(name);
        if (id != null) {
            return this.buildIdToField().get(id);
        }
        return null;
    }

    public boolean findDuplicateCol(String colName) {
        return this.idToName.entrySet().stream().map(e -> ((String)e.getValue()).toLowerCase(Locale.ROOT)).collect(Collectors.toSet()).contains(colName);
    }

    public int findIdByName(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        return this.buildNameToId().getOrDefault(name, -1);
    }

    public String toString() {
        return String.format("table {\n%s\n}", StringUtils.join(this.record.fields().stream().map(f -> " " + f).collect(Collectors.toList()).toArray(new String[0]), "\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalSchema)) {
            return false;
        }
        InternalSchema that = (InternalSchema)o;
        if (this.versionId != that.schemaId()) {
            return false;
        }
        return this.record.equals(that.record);
    }

    public int hashCode() {
        return this.record.hashCode();
    }
}

