/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;

class ListBasedIndexFileFilter
implements IndexFileFilter {
    final Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo;

    ListBasedIndexFileFilter(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo) {
        this.partitionToFileIndexInfo = partitionToFileIndexInfo;
    }

    @Override
    public Set<Pair<String, String>> getMatchingFilesAndPartition(String partitionPath, String recordKey) {
        List<BloomIndexFileInfo> indexInfos = this.partitionToFileIndexInfo.get(partitionPath);
        HashSet<Pair<String, String>> toReturn = new HashSet<Pair<String, String>>();
        if (indexInfos != null) {
            for (BloomIndexFileInfo indexInfo : indexInfos) {
                if (!this.shouldCompareWithFile(indexInfo, recordKey)) continue;
                toReturn.add(Pair.of(partitionPath, indexInfo.getFileId()));
            }
        }
        return toReturn;
    }

    protected boolean shouldCompareWithFile(BloomIndexFileInfo indexInfo, String recordKey) {
        return !indexInfo.hasKeyRanges() || indexInfo.isKeyInRange(recordKey);
    }
}

