/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;
import org.apache.hudi.hadoop.realtime.HoodieRealtimePath;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;

public class RealtimeFileStatus
extends FileStatus {
    private final String basePath;
    private final List<HoodieLogFile> deltaLogFiles;
    private final boolean belongsToIncrementalQuery;
    private String maxCommitTime = "";
    private FileStatus bootStrapFileStatus;
    private final Option<HoodieVirtualKeyInfo> virtualKeyInfo;

    public RealtimeFileStatus(FileStatus fileStatus, String basePath, List<HoodieLogFile> deltaLogFiles, boolean belongsToIncrementalQuery, Option<HoodieVirtualKeyInfo> virtualKeyInfo) throws IOException {
        super(fileStatus);
        this.basePath = basePath;
        this.deltaLogFiles = deltaLogFiles;
        this.belongsToIncrementalQuery = belongsToIncrementalQuery;
        this.virtualKeyInfo = virtualKeyInfo;
    }

    public Path getPath() {
        Path path = super.getPath();
        HoodieRealtimePath realtimePath = new HoodieRealtimePath(path.getParent(), path.getName(), this.basePath, this.deltaLogFiles, this.maxCommitTime, this.belongsToIncrementalQuery, this.virtualKeyInfo);
        if (this.bootStrapFileStatus != null) {
            realtimePath.setPathWithBootstrapFileStatus((PathWithBootstrapFileStatus)this.bootStrapFileStatus.getPath());
        }
        return realtimePath;
    }

    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    public void setBootStrapFileStatus(FileStatus bootStrapFileStatus) {
        this.bootStrapFileStatus = bootStrapFileStatus;
    }
}

