/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.HoodieWriteHandle;

public class ExplicitWriteHandler<T extends HoodieRecordPayload>
extends BoundedInMemoryQueueConsumer<HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord>, List<WriteStatus>> {
    private final List<WriteStatus> statuses = new ArrayList<WriteStatus>();
    private HoodieWriteHandle handle;

    public ExplicitWriteHandler(HoodieWriteHandle handle2) {
        this.handle = handle2;
    }

    @Override
    public void consumeOneRecord(HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> payload) {
        Object insertPayload = payload.record;
        this.handle.write((HoodieRecord)insertPayload, payload.insertValue, payload.exception);
    }

    @Override
    public void finish() {
        this.closeOpenHandle();
        assert (this.statuses.size() > 0);
    }

    @Override
    public List<WriteStatus> getResult() {
        return this.statuses;
    }

    private void closeOpenHandle() {
        this.statuses.addAll(this.handle.close());
    }
}

