/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import java.io.Serializable;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FSPermissionDTO
implements Serializable {
    @JsonProperty(value="useraction")
    FsAction useraction;
    @JsonProperty(value="groupaction")
    FsAction groupaction;
    @JsonProperty(value="otheraction")
    FsAction otheraction;
    @JsonProperty(value="stickyBit")
    boolean stickyBit;

    public static FSPermissionDTO fromFsPermission(FsPermission permission) {
        if (null == permission) {
            return null;
        }
        FSPermissionDTO dto = new FSPermissionDTO();
        dto.useraction = permission.getUserAction();
        dto.groupaction = permission.getGroupAction();
        dto.otheraction = permission.getOtherAction();
        dto.stickyBit = permission.getStickyBit();
        return dto;
    }

    public static FsPermission fromFsPermissionDTO(FSPermissionDTO dto) {
        if (null == dto) {
            return null;
        }
        return new FsPermission(dto.useraction, dto.groupaction, dto.otheraction, dto.stickyBit);
    }
}

