/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.util.Option;

public class HoodieBaseFile
extends BaseFile {
    private Option<BaseFile> bootstrapBaseFile;

    public HoodieBaseFile(HoodieBaseFile dataFile) {
        super(dataFile);
        this.bootstrapBaseFile = dataFile.bootstrapBaseFile;
    }

    public HoodieBaseFile(FileStatus fileStatus) {
        this(fileStatus, null);
    }

    public HoodieBaseFile(FileStatus fileStatus, BaseFile bootstrapBaseFile) {
        super(fileStatus);
        this.bootstrapBaseFile = Option.ofNullable(bootstrapBaseFile);
    }

    public HoodieBaseFile(String filePath) {
        this(filePath, null);
    }

    public HoodieBaseFile(String filePath, BaseFile bootstrapBaseFile) {
        super(filePath);
        this.bootstrapBaseFile = Option.ofNullable(bootstrapBaseFile);
    }

    public String getFileId() {
        return FSUtils.getFileId(this.getFileName());
    }

    public String getCommitTime() {
        return FSUtils.getCommitTime(this.getFileName());
    }

    public Option<BaseFile> getBootstrapBaseFile() {
        return this.bootstrapBaseFile;
    }

    public void setBootstrapBaseFile(BaseFile bootstrapBaseFile) {
        this.bootstrapBaseFile = Option.ofNullable(bootstrapBaseFile);
    }

    @Override
    public String toString() {
        return "HoodieBaseFile{fullPath=" + this.getPath() + ", fileLen=" + this.getFileLen() + ", BootstrapBaseFile=" + this.bootstrapBaseFile.orElse(null) + '}';
    }
}

