/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class DefaultHoodieRecordPayload
extends OverwriteWithLatestAvroPayload {
    public static final String METADATA_EVENT_TIME_KEY = "metadata.event_time.key";
    private Option<Object> eventTime = Option.empty();

    public DefaultHoodieRecordPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public DefaultHoodieRecordPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        if (!this.needUpdatingPersistedRecord(currentValue, incomingRecord, properties)) {
            return Option.of(currentValue);
        }
        this.eventTime = DefaultHoodieRecordPayload.updateEventTime(incomingRecord, properties);
        return this.isDeleteRecord(incomingRecord) ? Option.empty() : Option.of(incomingRecord);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        this.eventTime = DefaultHoodieRecordPayload.updateEventTime(incomingRecord, properties);
        return this.isDeleteRecord(incomingRecord) ? Option.empty() : Option.of(incomingRecord);
    }

    private static Option<Object> updateEventTime(GenericRecord record, Properties properties) {
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        String eventTimeField = properties.getProperty("hoodie.payload.event.time.field");
        if (eventTimeField == null) {
            return Option.empty();
        }
        return Option.ofNullable(HoodieAvroUtils.getNestedFieldVal(record, eventTimeField, true, consistentLogicalTimestampEnabled));
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.eventTime.isPresent()) {
            metadata.put(METADATA_EVENT_TIME_KEY, String.valueOf(this.eventTime.get()));
        }
        return metadata.isEmpty() ? Option.empty() : Option.of(metadata);
    }

    protected boolean needUpdatingPersistedRecord(IndexedRecord currentValue, IndexedRecord incomingRecord, Properties properties) {
        String orderField = properties.getProperty("hoodie.payload.ordering.field");
        if (orderField == null) {
            return true;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        Object persistedOrderingVal = HoodieAvroUtils.getNestedFieldVal((GenericRecord)currentValue, orderField, true, consistentLogicalTimestampEnabled);
        Comparable incomingOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)incomingRecord, orderField, true, consistentLogicalTimestampEnabled);
        return persistedOrderingVal == null || ((Comparable)persistedOrderingVal).compareTo(incomingOrderingVal) <= 0;
    }
}

