/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.util.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsistentHashingNode
implements Serializable {
    private final int value;
    private final String fileIdPrefix;

    @JsonCreator
    public ConsistentHashingNode(@JsonProperty(value="value") int value, @JsonProperty(value="fileIdPrefix") String fileIdPrefix) {
        this.value = value;
        this.fileIdPrefix = fileIdPrefix;
    }

    public static String toJsonString(List<ConsistentHashingNode> nodes) throws IOException {
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(nodes);
    }

    public static List<ConsistentHashingNode> fromJsonString(String json) throws Exception {
        if (json == null || json.isEmpty()) {
            return Collections.emptyList();
        }
        ConsistentHashingNode[] nodes = JsonUtils.getObjectMapper().readValue(json, ConsistentHashingNode[].class);
        return Arrays.asList(nodes);
    }

    public int getValue() {
        return this.value;
    }

    public String getFileIdPrefix() {
        return this.fileIdPrefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConsistentHashingNode{");
        sb.append("value=").append(this.value);
        sb.append(", fileIdPfx='").append(this.fileIdPrefix).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

