/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.index;

import java.util.Arrays;
import org.apache.hudi.exception.HoodieIndexException;

public enum HoodieIndexType {
    LUCENE(1);

    private final byte type;

    private HoodieIndexType(byte type) {
        this.type = type;
    }

    public byte getValue() {
        return this.type;
    }

    public static HoodieIndexType of(byte indexType) {
        return Arrays.stream(HoodieIndexType.values()).filter(t -> t.type == indexType).findAny().orElseThrow(() -> new HoodieIndexException("Unknown hoodie index type:" + indexType));
    }

    public static HoodieIndexType of(String indexType) {
        return Arrays.stream(HoodieIndexType.values()).filter(t -> t.name().equals(indexType.toUpperCase())).findAny().orElseThrow(() -> new HoodieIndexException("Unknown hoodie index type:" + indexType));
    }
}

