/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.esotericsoftware.kryo;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hudi.com.esotericsoftware.kryo.ClassResolver;
import org.apache.hudi.com.esotericsoftware.kryo.DefaultSerializer;
import org.apache.hudi.com.esotericsoftware.kryo.KryoCopyable;
import org.apache.hudi.com.esotericsoftware.kryo.KryoException;
import org.apache.hudi.com.esotericsoftware.kryo.KryoSerializable;
import org.apache.hudi.com.esotericsoftware.kryo.ReferenceResolver;
import org.apache.hudi.com.esotericsoftware.kryo.Registration;
import org.apache.hudi.com.esotericsoftware.kryo.Serializer;
import org.apache.hudi.com.esotericsoftware.kryo.StreamFactory;
import org.apache.hudi.com.esotericsoftware.kryo.factories.PseudoSerializerFactory;
import org.apache.hudi.com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import org.apache.hudi.com.esotericsoftware.kryo.factories.SerializerFactory;
import org.apache.hudi.com.esotericsoftware.kryo.io.Input;
import org.apache.hudi.com.esotericsoftware.kryo.io.Output;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.ClosureSerializer;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.CollectionSerializer;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.DefaultArraySerializers;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.DefaultSerializers;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.FieldSerializerConfig;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.GenericsResolver;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.MapSerializer;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.OptionalSerializers;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.TaggedFieldSerializerConfig;
import org.apache.hudi.com.esotericsoftware.kryo.serializers.TimeSerializers;
import org.apache.hudi.com.esotericsoftware.kryo.util.DefaultClassResolver;
import org.apache.hudi.com.esotericsoftware.kryo.util.DefaultStreamFactory;
import org.apache.hudi.com.esotericsoftware.kryo.util.IdentityMap;
import org.apache.hudi.com.esotericsoftware.kryo.util.IntArray;
import org.apache.hudi.com.esotericsoftware.kryo.util.MapReferenceResolver;
import org.apache.hudi.com.esotericsoftware.kryo.util.ObjectMap;
import org.apache.hudi.com.esotericsoftware.kryo.util.Util;
import org.apache.hudi.com.esotericsoftware.minlog.Log;
import org.apache.hudi.com.esotericsoftware.reflectasm.ConstructorAccess;
import org.apache.hudi.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.hudi.org.objenesis.strategy.InstantiatorStrategy;

public class Kryo {
    public static final byte NULL = 0;
    public static final byte NOT_NULL = 1;
    private static final int REF = -1;
    private static final int NO_REF = -2;
    private SerializerFactory defaultSerializer = new ReflectionSerializerFactory(FieldSerializer.class);
    private final ArrayList<DefaultSerializerEntry> defaultSerializers = new ArrayList(33);
    private final int lowPriorityDefaultSerializerCount;
    private final ClassResolver classResolver;
    private int nextRegisterID;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private InstantiatorStrategy strategy = new DefaultInstantiatorStrategy();
    private boolean registrationRequired;
    private boolean warnUnregisteredClasses;
    private int depth;
    private int maxDepth = Integer.MAX_VALUE;
    private boolean autoReset = true;
    private volatile Thread thread;
    private ObjectMap context;
    private ObjectMap graphContext;
    private ReferenceResolver referenceResolver;
    private final IntArray readReferenceIds = new IntArray(0);
    private boolean references;
    private boolean copyReferences = true;
    private Object readObject;
    private int copyDepth;
    private boolean copyShallow;
    private IdentityMap originalToCopy;
    private Object needsCopyReference;
    private GenericsResolver genericsResolver = new GenericsResolver();
    private FieldSerializerConfig fieldSerializerConfig = new FieldSerializerConfig();
    private TaggedFieldSerializerConfig taggedFieldSerializerConfig = new TaggedFieldSerializerConfig();
    private StreamFactory streamFactory;

    public Kryo() {
        this(new DefaultClassResolver(), new MapReferenceResolver(), new DefaultStreamFactory());
    }

    public Kryo(ReferenceResolver referenceResolver) {
        this(new DefaultClassResolver(), referenceResolver, new DefaultStreamFactory());
    }

    public Kryo(ClassResolver classResolver, ReferenceResolver referenceResolver) {
        this(classResolver, referenceResolver, new DefaultStreamFactory());
    }

    public Kryo(ClassResolver classResolver, ReferenceResolver referenceResolver, StreamFactory streamFactory) {
        if (classResolver == null) {
            throw new IllegalArgumentException("classResolver cannot be null.");
        }
        this.classResolver = classResolver;
        classResolver.setKryo(this);
        this.streamFactory = streamFactory;
        streamFactory.setKryo(this);
        this.referenceResolver = referenceResolver;
        if (referenceResolver != null) {
            referenceResolver.setKryo(this);
            this.references = true;
        }
        this.addDefaultSerializer(byte[].class, DefaultArraySerializers.ByteArraySerializer.class);
        this.addDefaultSerializer(char[].class, DefaultArraySerializers.CharArraySerializer.class);
        this.addDefaultSerializer(short[].class, DefaultArraySerializers.ShortArraySerializer.class);
        this.addDefaultSerializer(int[].class, DefaultArraySerializers.IntArraySerializer.class);
        this.addDefaultSerializer(long[].class, DefaultArraySerializers.LongArraySerializer.class);
        this.addDefaultSerializer(float[].class, DefaultArraySerializers.FloatArraySerializer.class);
        this.addDefaultSerializer(double[].class, DefaultArraySerializers.DoubleArraySerializer.class);
        this.addDefaultSerializer(boolean[].class, DefaultArraySerializers.BooleanArraySerializer.class);
        this.addDefaultSerializer(String[].class, DefaultArraySerializers.StringArraySerializer.class);
        this.addDefaultSerializer(Object[].class, DefaultArraySerializers.ObjectArraySerializer.class);
        this.addDefaultSerializer(KryoSerializable.class, DefaultSerializers.KryoSerializableSerializer.class);
        this.addDefaultSerializer(BigInteger.class, DefaultSerializers.BigIntegerSerializer.class);
        this.addDefaultSerializer(BigDecimal.class, DefaultSerializers.BigDecimalSerializer.class);
        this.addDefaultSerializer(Class.class, DefaultSerializers.ClassSerializer.class);
        this.addDefaultSerializer(Date.class, DefaultSerializers.DateSerializer.class);
        this.addDefaultSerializer(Enum.class, DefaultSerializers.EnumSerializer.class);
        this.addDefaultSerializer(EnumSet.class, DefaultSerializers.EnumSetSerializer.class);
        this.addDefaultSerializer(Currency.class, DefaultSerializers.CurrencySerializer.class);
        this.addDefaultSerializer(StringBuffer.class, DefaultSerializers.StringBufferSerializer.class);
        this.addDefaultSerializer(StringBuilder.class, DefaultSerializers.StringBuilderSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_LIST.getClass(), DefaultSerializers.CollectionsEmptyListSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_MAP.getClass(), DefaultSerializers.CollectionsEmptyMapSerializer.class);
        this.addDefaultSerializer(Collections.EMPTY_SET.getClass(), DefaultSerializers.CollectionsEmptySetSerializer.class);
        this.addDefaultSerializer(Collections.singletonList(null).getClass(), DefaultSerializers.CollectionsSingletonListSerializer.class);
        this.addDefaultSerializer(Collections.singletonMap(null, null).getClass(), DefaultSerializers.CollectionsSingletonMapSerializer.class);
        this.addDefaultSerializer(Collections.singleton(null).getClass(), DefaultSerializers.CollectionsSingletonSetSerializer.class);
        this.addDefaultSerializer(TreeSet.class, DefaultSerializers.TreeSetSerializer.class);
        this.addDefaultSerializer(Collection.class, CollectionSerializer.class);
        this.addDefaultSerializer(TreeMap.class, DefaultSerializers.TreeMapSerializer.class);
        this.addDefaultSerializer(Map.class, MapSerializer.class);
        this.addDefaultSerializer(TimeZone.class, DefaultSerializers.TimeZoneSerializer.class);
        this.addDefaultSerializer(Calendar.class, DefaultSerializers.CalendarSerializer.class);
        this.addDefaultSerializer(Locale.class, DefaultSerializers.LocaleSerializer.class);
        this.addDefaultSerializer(Charset.class, DefaultSerializers.CharsetSerializer.class);
        this.addDefaultSerializer(URL.class, DefaultSerializers.URLSerializer.class);
        OptionalSerializers.addDefaultSerializers(this);
        TimeSerializers.addDefaultSerializers(this);
        this.lowPriorityDefaultSerializerCount = this.defaultSerializers.size();
        this.register(Integer.TYPE, new DefaultSerializers.IntSerializer());
        this.register(String.class, new DefaultSerializers.StringSerializer());
        this.register(Float.TYPE, new DefaultSerializers.FloatSerializer());
        this.register(Boolean.TYPE, new DefaultSerializers.BooleanSerializer());
        this.register(Byte.TYPE, new DefaultSerializers.ByteSerializer());
        this.register(Character.TYPE, new DefaultSerializers.CharSerializer());
        this.register(Short.TYPE, new DefaultSerializers.ShortSerializer());
        this.register(Long.TYPE, new DefaultSerializers.LongSerializer());
        this.register(Double.TYPE, new DefaultSerializers.DoubleSerializer());
        this.register(Void.TYPE, new DefaultSerializers.VoidSerializer());
    }

    public void setDefaultSerializer(SerializerFactory serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = serializer;
    }

    public void setDefaultSerializer(Class<? extends Serializer> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = new ReflectionSerializerFactory(serializer);
    }

    public void addDefaultSerializer(Class type, Serializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        DefaultSerializerEntry entry = new DefaultSerializerEntry(type, new PseudoSerializerFactory(serializer));
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, entry);
    }

    public void addDefaultSerializer(Class type, SerializerFactory serializerFactory) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializerFactory cannot be null.");
        }
        DefaultSerializerEntry entry = new DefaultSerializerEntry(type, serializerFactory);
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, entry);
    }

    public void addDefaultSerializer(Class type, Class<? extends Serializer> serializerClass) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerClass == null) {
            throw new IllegalArgumentException("serializerClass cannot be null.");
        }
        DefaultSerializerEntry entry = new DefaultSerializerEntry(type, new ReflectionSerializerFactory(serializerClass));
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, entry);
    }

    public Serializer getDefaultSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Serializer serializerForAnnotation = this.getDefaultSerializerForAnnotatedType(type);
        if (serializerForAnnotation != null) {
            return serializerForAnnotation;
        }
        int n = this.defaultSerializers.size();
        for (int i = 0; i < n; ++i) {
            DefaultSerializerEntry entry = this.defaultSerializers.get(i);
            if (!entry.type.isAssignableFrom(type)) continue;
            Serializer defaultSerializer = entry.serializerFactory.makeSerializer(this, type);
            return defaultSerializer;
        }
        return this.newDefaultSerializer(type);
    }

    protected Serializer getDefaultSerializerForAnnotatedType(Class type) {
        if (type.isAnnotationPresent(DefaultSerializer.class)) {
            DefaultSerializer defaultSerializerAnnotation = type.getAnnotation(DefaultSerializer.class);
            return ReflectionSerializerFactory.makeSerializer(this, defaultSerializerAnnotation.value(), type);
        }
        return null;
    }

    protected Serializer newDefaultSerializer(Class type) {
        return this.defaultSerializer.makeSerializer(this, type);
    }

    public Registration register(Class type) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type));
    }

    public Registration register(Class type, int id) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type), id);
    }

    public Registration register(Class type, Serializer serializer) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            registration.setSerializer(serializer);
            return registration;
        }
        return this.classResolver.register(new Registration(type, serializer, this.getNextRegistrationId()));
    }

    public Registration register(Class type, Serializer serializer, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be >= 0: " + id);
        }
        return this.register(new Registration(type, serializer, id));
    }

    public Registration register(Registration registration) {
        int id = registration.getId();
        if (id < 0) {
            throw new IllegalArgumentException("id must be > 0: " + id);
        }
        Registration existing = this.getRegistration(registration.getId());
        if (Log.DEBUG && existing != null && existing.getType() != registration.getType()) {
            Log.debug("An existing registration with a different type already uses ID: " + registration.getId() + "\nExisting registration: " + existing + "\nis now overwritten with: " + registration);
        }
        return this.classResolver.register(registration);
    }

    public int getNextRegistrationId() {
        while (this.nextRegisterID != -2) {
            if (this.classResolver.getRegistration(this.nextRegisterID) == null) {
                return this.nextRegisterID;
            }
            ++this.nextRegisterID;
        }
        throw new KryoException("No registration IDs are available.");
    }

    public Registration getRegistration(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Registration registration = this.classResolver.getRegistration(type);
        if (registration == null) {
            if (Proxy.isProxyClass(type)) {
                registration = this.getRegistration(InvocationHandler.class);
            } else if (!type.isEnum() && Enum.class.isAssignableFrom(type) && !Enum.class.equals((Object)type)) {
                registration = this.getRegistration(type.getEnclosingClass());
            } else if (EnumSet.class.isAssignableFrom(type)) {
                registration = this.classResolver.getRegistration(EnumSet.class);
            } else if (this.isClosure(type)) {
                registration = this.classResolver.getRegistration(ClosureSerializer.Closure.class);
            }
            if (registration == null) {
                if (this.registrationRequired) {
                    throw new IllegalArgumentException(this.unregisteredClassMessage(type));
                }
                if (this.warnUnregisteredClasses) {
                    Log.warn(this.unregisteredClassMessage(type));
                }
                registration = this.classResolver.registerImplicit(type);
            }
        }
        return registration;
    }

    protected String unregisteredClassMessage(Class type) {
        return "Class is not registered: " + Util.className(type) + "\nNote: To register this class use: kryo.register(" + Util.className(type) + ".class);";
    }

    public Registration getRegistration(int classID) {
        return this.classResolver.getRegistration(classID);
    }

    public Serializer getSerializer(Class type) {
        return this.getRegistration(type).getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration writeClass(Output output, Class type) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        try {
            Registration registration = this.classResolver.writeClass(output, type);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    public void writeObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                this.getRegistration(object.getClass()).getSerializer().setGenerics(this, null);
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            this.getRegistration(object.getClass()).getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                serializer.setGenerics(this, null);
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Class type) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            Serializer serializer = this.getRegistration(type).getSerializer();
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    serializer.setGenerics(this, null);
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Write", object);
                    }
                    output.writeByte((byte)0);
                    return;
                }
                output.writeByte((byte)1);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectOrNull(Output output, Object object, Serializer serializer) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            if (this.references) {
                if (this.writeReferenceOrNull(output, object, true)) {
                    serializer.setGenerics(this, null);
                    return;
                }
            } else if (!serializer.getAcceptsNull()) {
                if (object == null) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Write", null);
                    }
                    output.writeByte((byte)0);
                    return;
                }
                output.writeByte((byte)1);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            serializer.write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassAndObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            if (object == null) {
                this.writeClass(output, null);
                return;
            }
            Registration registration = this.writeClass(output, object.getClass());
            if (this.references && this.writeReferenceOrNull(output, object, false)) {
                registration.getSerializer().setGenerics(this, null);
                return;
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            registration.getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    boolean writeReferenceOrNull(Output output, Object object, boolean mayBeNull) {
        if (object == null) {
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", null);
            }
            output.writeVarInt(0, true);
            return true;
        }
        if (!this.referenceResolver.useReferences(object.getClass())) {
            if (mayBeNull) {
                output.writeVarInt(1, true);
            }
            return false;
        }
        int id = this.referenceResolver.getWrittenId(object);
        if (id != -1) {
            if (Log.DEBUG) {
                Log.debug("kryo", "Write object reference " + id + ": " + Util.string(object));
            }
            output.writeVarInt(id + 2, true);
            return true;
        }
        id = this.referenceResolver.addWrittenObject(object);
        output.writeVarInt(1, true);
        if (Log.TRACE) {
            Log.trace("kryo", "Write initial object reference " + id + ": " + Util.string(object));
        }
        return false;
    }

    public Registration readClass(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        try {
            Registration registration = this.classResolver.readClass(input);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = this.getRegistration(type).getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = this.getRegistration(type).getSerializer().read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = serializer.read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> type) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, true);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = this.getRegistration(type).getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                Serializer serializer = this.getRegistration(type).getSerializer();
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Read", null);
                    }
                    T t = null;
                    return t;
                }
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObjectOrNull(Input input, Class<T> type, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T object;
            if (this.references) {
                int stackSize = this.readReferenceOrNull(input, type, true);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return (T)object2;
                }
                object = serializer.read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                if (!serializer.getAcceptsNull() && input.readByte() == 0) {
                    if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                        Util.log("Read", null);
                    }
                    T t = null;
                    return t;
                }
                object = serializer.read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readClassAndObject(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.beginObject();
        try {
            Object object;
            Registration registration = this.readClass(input);
            if (registration == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Class type = registration.getType();
            if (this.references) {
                registration.getSerializer().setGenerics(this, null);
                int stackSize = this.readReferenceOrNull(input, type, false);
                if (stackSize == -1) {
                    Object object2 = this.readObject;
                    return object2;
                }
                object = registration.getSerializer().read(this, input, type);
                if (stackSize == this.readReferenceIds.size) {
                    this.reference(object);
                }
            } else {
                object = registration.getSerializer().read(this, input, type);
            }
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            Object t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    int readReferenceOrNull(Input input, Class type, boolean mayBeNull) {
        int id;
        if (type.isPrimitive()) {
            type = Util.getWrapperClass(type);
        }
        boolean referencesSupported = this.referenceResolver.useReferences(type);
        if (mayBeNull) {
            id = input.readVarInt(true);
            if (id == 0) {
                if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                    Util.log("Read", null);
                }
                this.readObject = null;
                return -1;
            }
            if (!referencesSupported) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
        } else {
            if (!referencesSupported) {
                this.readReferenceIds.add(-2);
                return this.readReferenceIds.size;
            }
            id = input.readVarInt(true);
        }
        if (id == 1) {
            id = this.referenceResolver.nextReadId(type);
            if (Log.TRACE) {
                Log.trace("kryo", "Read initial object reference " + id + ": " + Util.className(type));
            }
            this.readReferenceIds.add(id);
            return this.readReferenceIds.size;
        }
        this.readObject = this.referenceResolver.getReadObject(type, id -= 2);
        if (Log.DEBUG) {
            Log.debug("kryo", "Read object reference " + id + ": " + Util.string(this.readObject));
        }
        return -1;
    }

    public void reference(Object object) {
        int id;
        if (this.copyDepth > 0) {
            if (this.needsCopyReference != null) {
                if (object == null) {
                    throw new IllegalArgumentException("object cannot be null.");
                }
                this.originalToCopy.put(this.needsCopyReference, object);
                this.needsCopyReference = null;
            }
        } else if (this.references && object != null && (id = this.readReferenceIds.pop()) != -2) {
            this.referenceResolver.setReadObject(id, object);
        }
    }

    public void reset() {
        this.depth = 0;
        if (this.graphContext != null) {
            this.graphContext.clear();
        }
        this.classResolver.reset();
        if (this.references) {
            this.referenceResolver.reset();
            this.readObject = null;
        }
        this.copyDepth = 0;
        if (this.originalToCopy != null) {
            this.originalToCopy.clear(2048);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Object graph complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T object) {
        if (object == null) {
            return null;
        }
        if (this.copyShallow) {
            return object;
        }
        ++this.copyDepth;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : this.getSerializer(object.getClass()).copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Copy", copy);
            }
            Object t = copy;
            return t;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T object, Serializer serializer) {
        if (object == null) {
            return null;
        }
        if (this.copyShallow) {
            return object;
        }
        ++this.copyDepth;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : serializer.copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Copy", copy);
            }
            Object t = copy;
            return t;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T object) {
        if (object == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : this.getSerializer(object.getClass()).copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Shallow copy", copy);
            }
            Object t = copy;
            return t;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copyShallow(T object, Serializer serializer) {
        if (object == null) {
            return null;
        }
        ++this.copyDepth;
        this.copyShallow = true;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            Object copy = object instanceof KryoCopyable ? ((KryoCopyable)object).copy(this) : serializer.copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Shallow copy", copy);
            }
            Object t = copy;
            return t;
        }
        finally {
            this.copyShallow = false;
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    private void beginObject() {
        if (Log.DEBUG) {
            if (this.depth == 0) {
                this.thread = Thread.currentThread();
            } else if (this.thread != Thread.currentThread()) {
                throw new ConcurrentModificationException("Kryo must not be accessed concurrently by multiple threads.");
            }
        }
        if (this.depth == this.maxDepth) {
            throw new KryoException("Max depth exceeded: " + this.depth);
        }
        ++this.depth;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null.");
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setRegistrationRequired(boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
        if (Log.TRACE) {
            Log.trace("kryo", "Registration required: " + registrationRequired);
        }
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public void setWarnUnregisteredClasses(boolean warnUnregisteredClasses) {
        this.warnUnregisteredClasses = warnUnregisteredClasses;
        if (Log.TRACE) {
            Log.trace("kryo", "Warn unregistered classes: " + warnUnregisteredClasses);
        }
    }

    public boolean isWarnUnregisteredClasses() {
        return this.warnUnregisteredClasses;
    }

    public boolean setReferences(boolean references) {
        if (references == this.references) {
            return references;
        }
        this.references = references;
        if (references && this.referenceResolver == null) {
            this.referenceResolver = new MapReferenceResolver();
        }
        if (Log.TRACE) {
            Log.trace("kryo", "References: " + references);
        }
        return !references;
    }

    public void setCopyReferences(boolean copyReferences) {
        this.copyReferences = copyReferences;
    }

    public FieldSerializerConfig getFieldSerializerConfig() {
        return this.fieldSerializerConfig;
    }

    public TaggedFieldSerializerConfig getTaggedFieldSerializerConfig() {
        return this.taggedFieldSerializerConfig;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            throw new IllegalArgumentException("referenceResolver cannot be null.");
        }
        this.references = true;
        this.referenceResolver = referenceResolver;
        if (Log.TRACE) {
            Log.trace("kryo", "Reference resolver: " + referenceResolver.getClass().getName());
        }
    }

    public boolean getReferences() {
        return this.references;
    }

    public void setInstantiatorStrategy(InstantiatorStrategy strategy) {
        this.strategy = strategy;
    }

    public InstantiatorStrategy getInstantiatorStrategy() {
        return this.strategy;
    }

    protected ObjectInstantiator newInstantiator(Class type) {
        return this.strategy.newInstantiatorOf(type);
    }

    public <T> T newInstance(Class<T> type) {
        Registration registration = this.getRegistration(type);
        ObjectInstantiator instantiator = registration.getInstantiator();
        if (instantiator == null) {
            instantiator = this.newInstantiator(type);
            registration.setInstantiator(instantiator);
        }
        return instantiator.newInstance();
    }

    public ObjectMap getContext() {
        if (this.context == null) {
            this.context = new ObjectMap();
        }
        return this.context;
    }

    public ObjectMap getGraphContext() {
        if (this.graphContext == null) {
            this.graphContext = new ObjectMap();
        }
        return this.graphContext;
    }

    public int getDepth() {
        return this.depth;
    }

    public IdentityMap getOriginalToCopyMap() {
        return this.originalToCopy;
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }

    public void setMaxDepth(int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalArgumentException("maxDepth must be > 0.");
        }
        this.maxDepth = maxDepth;
    }

    public boolean isFinal(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type.isArray()) {
            return Modifier.isFinal(Util.getElementClass(type).getModifiers());
        }
        return Modifier.isFinal(type.getModifiers());
    }

    protected boolean isClosure(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        return type.getName().indexOf(47) >= 0;
    }

    public GenericsResolver getGenericsResolver() {
        return this.genericsResolver;
    }

    public StreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(StreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Deprecated
    public void setAsmEnabled(boolean flag) {
        this.fieldSerializerConfig.setUseAsm(flag);
    }

    @Deprecated
    public boolean getAsmEnabled() {
        return this.fieldSerializerConfig.isUseAsm();
    }

    public static class DefaultInstantiatorStrategy
    implements InstantiatorStrategy {
        private InstantiatorStrategy fallbackStrategy;

        public DefaultInstantiatorStrategy() {
        }

        public DefaultInstantiatorStrategy(InstantiatorStrategy fallbackStrategy) {
            this.fallbackStrategy = fallbackStrategy;
        }

        public void setFallbackInstantiatorStrategy(InstantiatorStrategy fallbackStrategy) {
            this.fallbackStrategy = fallbackStrategy;
        }

        public InstantiatorStrategy getFallbackInstantiatorStrategy() {
            return this.fallbackStrategy;
        }

        public ObjectInstantiator newInstantiatorOf(final Class type) {
            if (!Util.IS_ANDROID) {
                boolean isNonStaticMemberClass;
                Class<?> enclosingType = type.getEnclosingClass();
                boolean bl = isNonStaticMemberClass = enclosingType != null && type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
                if (!isNonStaticMemberClass) {
                    try {
                        final ConstructorAccess access = ConstructorAccess.get(type);
                        return new ObjectInstantiator(){

                            public Object newInstance() {
                                try {
                                    return access.newInstance();
                                }
                                catch (Exception ex) {
                                    throw new KryoException("Error constructing instance of class: " + Util.className(type), ex);
                                }
                            }
                        };
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                Constructor ctor;
                try {
                    ctor = type.getConstructor(null);
                }
                catch (Exception ex) {
                    ctor = type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                }
                final Constructor constructor = ctor;
                return new ObjectInstantiator(){

                    public Object newInstance() {
                        try {
                            return constructor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new KryoException("Error constructing instance of class: " + Util.className(type), ex);
                        }
                    }
                };
            }
            catch (Exception ctor) {
                if (this.fallbackStrategy == null) {
                    if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                        throw new KryoException("Class cannot be created (non-static member class): " + Util.className(type));
                    }
                    StringBuilder errorMessageSb = new StringBuilder("Class cannot be created (missing no-arg constructor): " + Util.className(type));
                    if (type.getSimpleName().equals("")) {
                        errorMessageSb.append("\n\tThis is an anonymous class, which is not serializable by default in Kryo. Possible solutions: ").append("1. Remove uses of anonymous classes, including double brace initialization, from the containing ").append("class. This is the safest solution, as anonymous classes don't have predictable names for serialization.").append("\n\t2. Register a FieldSerializer for the containing class and call ").append("FieldSerializer#setIgnoreSyntheticFields(false) on it. This is not safe but may be sufficient temporarily. ").append("Use at your own risk.");
                    }
                    throw new KryoException(errorMessageSb.toString());
                }
                return this.fallbackStrategy.newInstantiatorOf(type);
            }
        }
    }

    static final class DefaultSerializerEntry {
        final Class type;
        final SerializerFactory serializerFactory;

        DefaultSerializerEntry(Class type, SerializerFactory serializerFactory) {
            this.type = type;
            this.serializerFactory = serializerFactory;
        }
    }
}

