/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.beust.jcommander.converters;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.com.beust.jcommander.converters.BaseConverter;

public class PathConverter
extends BaseConverter<Path> {
    public PathConverter(String optionName) {
        super(optionName);
    }

    @Override
    public Path convert(String value) {
        try {
            return Paths.get(value, new String[0]);
        }
        catch (InvalidPathException e) {
            String encoded = PathConverter.escapeUnprintable(value);
            throw new ParameterException(this.getErrorString(encoded, "a path"));
        }
    }

    private static String escapeUnprintable(String value) {
        StringBuilder bldr = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c < ' ') {
                bldr.append("\\u").append(String.format("%04X", c));
                continue;
            }
            bldr.append(c);
        }
        return bldr.toString();
    }
}

