/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.List;
import java.util.Map;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;

public class FileSliceMetricUtils {
    public static final String TOTAL_IO_READ_MB = "TOTAL_IO_READ_MB";
    public static final String TOTAL_IO_WRITE_MB = "TOTAL_IO_WRITE_MB";
    public static final String TOTAL_IO_MB = "TOTAL_IO_MB";
    public static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILES_SIZE";
    public static final String TOTAL_LOG_FILES = "TOTAL_LOG_FILES";

    public static void addFileSliceCommonMetrics(List<FileSlice> fileSlices, Map<String, Double> metrics, long defaultBaseFileSize) {
        int numLogFiles = 0;
        long totalLogFileSize = 0L;
        long totalIORead = 0L;
        long totalIOWrite = 0L;
        long totalIO = 0L;
        for (FileSlice slice : fileSlices) {
            numLogFiles = (int)((long)numLogFiles + slice.getLogFiles().count());
            totalLogFileSize += slice.getLogFiles().map(HoodieLogFile::getFileSize).filter(size -> size >= 0L).reduce(Long::sum).orElse(0L).longValue();
            long baseFileSize = slice.getBaseFile().isPresent() ? slice.getBaseFile().get().getFileSize() : 0L;
            totalIORead += baseFileSize;
            totalIOWrite += baseFileSize > 0L ? baseFileSize : defaultBaseFileSize;
        }
        totalIORead = FSUtils.getSizeInMB(totalIORead + totalLogFileSize);
        totalIOWrite = FSUtils.getSizeInMB(totalIOWrite);
        totalIO = totalIORead + totalIOWrite;
        metrics.put(TOTAL_IO_READ_MB, Double.valueOf(totalIORead));
        metrics.put(TOTAL_IO_WRITE_MB, Double.valueOf(totalIOWrite));
        metrics.put(TOTAL_IO_MB, Double.valueOf(totalIO));
        metrics.put(TOTAL_LOG_FILE_SIZE, Double.valueOf(totalLogFileSize));
        metrics.put(TOTAL_LOG_FILES, Double.valueOf(numLogFiles));
    }
}

