/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.cloudwatch;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClientBuilder;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.com.codahale.metrics.Clock;
import org.apache.hudi.com.codahale.metrics.Counter;
import org.apache.hudi.com.codahale.metrics.Counting;
import org.apache.hudi.com.codahale.metrics.Gauge;
import org.apache.hudi.com.codahale.metrics.Histogram;
import org.apache.hudi.com.codahale.metrics.Meter;
import org.apache.hudi.com.codahale.metrics.Metric;
import org.apache.hudi.com.codahale.metrics.MetricFilter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.com.codahale.metrics.ScheduledReporter;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.util.Option;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CloudWatchReporter
extends ScheduledReporter {
    static final String DIMENSION_TABLE_NAME_KEY = "Table";
    static final String DIMENSION_METRIC_TYPE_KEY = "Metric Type";
    static final String DIMENSION_GAUGE_TYPE_VALUE = "gauge";
    static final String DIMENSION_COUNT_TYPE_VALUE = "count";
    private static final Logger LOG = LogManager.getLogger(CloudWatchReporter.class);
    private final AmazonCloudWatchAsync cloudWatchClientAsync;
    private final Clock clock;
    private final String prefix;
    private final String namespace;
    private final int maxDatumsPerRequest;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected CloudWatchReporter(MetricRegistry registry, AmazonCloudWatchAsync cloudWatchClientAsync, Clock clock, String prefix, String namespace, int maxDatumsPerRequest, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, "hudi-cloudWatch-reporter", filter, rateUnit, durationUnit);
        this.cloudWatchClientAsync = cloudWatchClientAsync;
        this.clock = clock;
        this.prefix = prefix;
        this.namespace = namespace;
        this.maxDatumsPerRequest = maxDatumsPerRequest;
    }

    private static AmazonCloudWatchAsync getAmazonCloudWatchClient(Properties props) {
        return (AmazonCloudWatchAsync)((AmazonCloudWatchAsyncClientBuilder)AmazonCloudWatchAsyncClientBuilder.standard().withCredentials(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider(props))).build();
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        LOG.info((Object)"Reporting Metrics to CloudWatch.");
        long timestampMilliSec = this.clock.getTime();
        ArrayList<MetricDatum> metricsData = new ArrayList<MetricDatum>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.processGauge(entry.getKey(), entry.getValue(), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Metric> entry : counters.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)((Object)entry.getValue()), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)((Object)entry.getValue()), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Metric> entry : meters.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)((Object)entry.getValue()), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Metric> entry : timers.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)((Object)entry.getValue()), timestampMilliSec, metricsData);
        }
        this.report(metricsData);
    }

    private void report(List<MetricDatum> metricsData) {
        ArrayList<Future> cloudWatchFutures = new ArrayList<Future>(metricsData.size());
        ArrayList<List<MetricDatum>> partitions = new ArrayList<List<MetricDatum>>();
        for (int i = 0; i < metricsData.size(); i += this.maxDatumsPerRequest) {
            int n = Math.min(metricsData.size(), i + this.maxDatumsPerRequest);
            partitions.add(metricsData.subList(i, n));
        }
        for (List list : partitions) {
            PutMetricDataRequest request = new PutMetricDataRequest().withNamespace(this.namespace).withMetricData((Collection)list);
            cloudWatchFutures.add(this.cloudWatchClientAsync.putMetricDataAsync(request));
        }
        for (Future future : cloudWatchFutures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error reporting metrics to CloudWatch. The data in this CloudWatch request may have been discarded, and not made it to CloudWatch.", (Throwable)ex);
            }
        }
    }

    private void processGauge(String metricName, Gauge<?> gauge, long timestampMilliSec, List<MetricDatum> metricData) {
        Option.ofNullable(gauge.getValue()).toJavaOptional().filter(value -> value instanceof Number).map(value -> (Number)value).ifPresent(value -> this.stageMetricDatum(metricName, value.doubleValue(), DIMENSION_GAUGE_TYPE_VALUE, StandardUnit.None, timestampMilliSec, metricData));
    }

    private void processCounter(String metricName, Counting counter, long timestampMilliSec, List<MetricDatum> metricData) {
        this.stageMetricDatum(metricName, counter.getCount(), DIMENSION_COUNT_TYPE_VALUE, StandardUnit.Count, timestampMilliSec, metricData);
    }

    private void stageMetricDatum(String metricName, double metricValue, String metricType, StandardUnit standardUnit, long timestampMilliSec, List<MetricDatum> metricData) {
        String[] metricNameParts = metricName.split("\\.", 2);
        String tableName = metricNameParts[0];
        metricData.add(new MetricDatum().withTimestamp(new Date(timestampMilliSec)).withMetricName(this.prefix(metricNameParts[1])).withValue(Double.valueOf(metricValue)).withDimensions(this.getDimensions(tableName, metricType)).withUnit(standardUnit));
    }

    private List<Dimension> getDimensions(String tableName, String metricType) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new Dimension().withName(DIMENSION_TABLE_NAME_KEY).withValue(tableName));
        dimensions.add(new Dimension().withName(DIMENSION_METRIC_TYPE_KEY).withValue(metricType));
        return dimensions;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name(this.prefix, components);
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.cloudWatchClientAsync.shutdown();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while shutting down CloudWatch client.", (Throwable)ex);
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String namespace;
        private int maxDatumsPerRequest;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.maxDatumsPerRequest = 20;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder maxDatumsPerRequest(int maxDatumsPerRequest) {
            this.maxDatumsPerRequest = maxDatumsPerRequest;
            return this;
        }

        public CloudWatchReporter build(Properties props) {
            return new CloudWatchReporter(this.registry, CloudWatchReporter.getAmazonCloudWatchClient(props), this.clock, this.prefix, this.namespace, this.maxDatumsPerRequest, this.filter, this.rateUnit, this.durationUnit);
        }

        CloudWatchReporter build(AmazonCloudWatchAsync amazonCloudWatchAsync) {
            return new CloudWatchReporter(this.registry, amazonCloudWatchAsync, this.clock, this.prefix, this.namespace, this.maxDatumsPerRequest, this.filter, this.rateUnit, this.durationUnit);
        }
    }
}

