/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParquetSchemaConverter.class);
    public static final String MAP_VALUE = "value";
    public static final String LIST_ARRAY_TYPE = "array";
    public static final String LIST_ELEMENT = "element";
    public static final String LIST_GROUP_NAME = "list";
    public static final String MESSAGE_ROOT = "root";

    public static TypeInformation<?> fromParquetType(MessageType type) {
        return ParquetSchemaConverter.convertFields(type.getFields());
    }

    public static MessageType toParquetType(TypeInformation<?> typeInformation, boolean legacyMode) {
        return (MessageType)ParquetSchemaConverter.convertField(null, typeInformation, Type.Repetition.OPTIONAL, legacyMode);
    }

    public static TypeInformation<?> convertFields(List<Type> parquetFields) {
        ArrayList types = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        for (Type field : parquetFields) {
            TypeInformation<?> subType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(field);
            if (subType != null) {
                types.add(subType);
                names.add(field.getName());
                continue;
            }
            LOGGER.error("Parquet field {} in schema type {} can not be converted to Flink Internal Type", (Object)field.getName(), (Object)field.getOriginalType().name());
        }
        return new RowTypeInfo(types.toArray(new TypeInformation[0]), names.toArray(new String[0]));
    }

    public static TypeInformation<?> convertParquetTypeToTypeInfo(Type fieldType) {
        ObjectArrayTypeInfo typeInfo;
        block46: {
            GroupType parquetGroupType;
            block47: {
                block45: {
                    if (!fieldType.isPrimitive()) break block45;
                    OriginalType originalType = fieldType.getOriginalType();
                    PrimitiveType primitiveType = fieldType.asPrimitiveType();
                    block0 : switch (primitiveType.getPrimitiveTypeName()) {
                        case BINARY: {
                            if (originalType != null) {
                                switch (originalType) {
                                    case DECIMAL: {
                                        typeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                                        break block0;
                                    }
                                    case UTF8: 
                                    case ENUM: 
                                    case JSON: 
                                    case BSON: {
                                        typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type BINARY");
                            }
                            typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
                            break;
                        }
                        case BOOLEAN: {
                            typeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                            break;
                        }
                        case INT32: {
                            if (originalType != null) {
                                switch (originalType) {
                                    case DECIMAL: {
                                        typeInfo = BasicTypeInfo.INT_TYPE_INFO;
                                        break block0;
                                    }
                                    case TIME_MICROS: 
                                    case TIME_MILLIS: {
                                        typeInfo = SqlTimeTypeInfo.TIME;
                                        break block0;
                                    }
                                    case TIMESTAMP_MICROS: 
                                    case TIMESTAMP_MILLIS: {
                                        typeInfo = SqlTimeTypeInfo.TIMESTAMP;
                                        break block0;
                                    }
                                    case DATE: {
                                        typeInfo = SqlTimeTypeInfo.DATE;
                                        break block0;
                                    }
                                    case UINT_8: 
                                    case UINT_16: 
                                    case UINT_32: {
                                        typeInfo = BasicTypeInfo.INT_TYPE_INFO;
                                        break block0;
                                    }
                                    case INT_8: {
                                        typeInfo = Types.BYTE;
                                        break block0;
                                    }
                                    case INT_16: {
                                        typeInfo = Types.SHORT;
                                        break block0;
                                    }
                                    case INT_32: {
                                        typeInfo = BasicTypeInfo.INT_TYPE_INFO;
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT32");
                            }
                            typeInfo = BasicTypeInfo.INT_TYPE_INFO;
                            break;
                        }
                        case INT64: {
                            if (originalType != null) {
                                switch (originalType) {
                                    case TIME_MICROS: {
                                        typeInfo = SqlTimeTypeInfo.TIME;
                                        break block0;
                                    }
                                    case TIMESTAMP_MICROS: 
                                    case TIMESTAMP_MILLIS: {
                                        typeInfo = SqlTimeTypeInfo.TIMESTAMP;
                                        break block0;
                                    }
                                    case DECIMAL: 
                                    case INT_64: {
                                        typeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT64");
                            }
                            typeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                            break;
                        }
                        case INT96: {
                            typeInfo = SqlTimeTypeInfo.TIMESTAMP;
                            break;
                        }
                        case FLOAT: {
                            typeInfo = BasicTypeInfo.FLOAT_TYPE_INFO;
                            break;
                        }
                        case DOUBLE: {
                            typeInfo = BasicTypeInfo.DOUBLE_TYPE_INFO;
                            break;
                        }
                        case FIXED_LEN_BYTE_ARRAY: {
                            if (originalType != null) {
                                switch (originalType) {
                                    case DECIMAL: {
                                        typeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type FIXED_LEN_BYTE_ARRAY");
                            }
                            typeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                        }
                    }
                    break block46;
                }
                parquetGroupType = fieldType.asGroupType();
                OriginalType originalType = parquetGroupType.getOriginalType();
                if (originalType == null) break block47;
                switch (originalType) {
                    case LIST: {
                        GroupType tupleGroup;
                        Type internalType;
                        GroupType elementType;
                        if (parquetGroupType.getFieldCount() != 1) {
                            throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                        }
                        Type repeatedType = parquetGroupType.getType(0);
                        if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                            throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                        }
                        typeInfo = repeatedType.isPrimitive() ? ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(repeatedType) : ((elementType = repeatedType.asGroupType()).getFieldCount() > 1 ? ParquetSchemaConverter.convertGroupElementToArrayTypeInfo(parquetGroupType, elementType) : ((internalType = elementType.getType(0)).isPrimitive() ? ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(internalType) : ((tupleGroup = internalType.asGroupType()).getFieldCount() == 1 && tupleGroup.getFields().get(0).isRepetition(Type.Repetition.REQUIRED) ? ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(internalType)) : ParquetSchemaConverter.convertGroupElementToArrayTypeInfo(parquetGroupType, tupleGroup))));
                        break block46;
                    }
                    case MAP_KEY_VALUE: 
                    case MAP: {
                        if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                            throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                        }
                        GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                        if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || mapKeyValType.getFieldCount() != 2) {
                            throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                        }
                        Type keyType = mapKeyValType.getType(0);
                        if (!(keyType.isPrimitive() && keyType.isRepetition(Type.Repetition.REQUIRED) && keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && keyType.getOriginalType().equals((Object)OriginalType.UTF8))) {
                            throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                        }
                        Type valueType = mapKeyValType.getType(1);
                        return new MapTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, ParquetSchemaConverter.convertParquetTypeToTypeInfo(valueType));
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                    }
                }
            }
            return ParquetSchemaConverter.convertFields(parquetGroupType.getFields());
        }
        return typeInfo;
    }

    private static ObjectArrayTypeInfo convertGroupElementToArrayTypeInfo(GroupType arrayFieldType, GroupType elementType) {
        for (Type type : elementType.getFields()) {
            if (type.isRepetition(Type.Repetition.REQUIRED)) continue;
            throw new UnsupportedOperationException(String.format("List field [%s] in List [%s] has to be required. ", type.toString(), arrayFieldType.getName()));
        }
        return ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(elementType));
    }

    private static TypeInformation<?> convertParquetPrimitiveListToFlinkArray(Type type) {
        TypeInformation<?> flinkType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(type);
        if (flinkType.isBasicType()) {
            return BasicArrayTypeInfo.getInfoFor(Array.newInstance(flinkType.getTypeClass(), 0).getClass());
        }
        return ObjectArrayTypeInfo.getInfoFor(flinkType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type convertField(String fieldName, TypeInformation<?> typeInfo, Type.Repetition inheritRepetition, boolean legacyMode) {
        Type.Repetition repetition;
        Type fieldType = null;
        Type.Repetition repetition2 = repetition = inheritRepetition == null ? Type.Repetition.OPTIONAL : inheritRepetition;
        if (typeInfo instanceof BasicTypeInfo) {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)typeInfo;
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO)) return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.DECIMAL)).named(fieldName);
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BIG_INT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.DECIMAL)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.INT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_32)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.FLOAT_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.LONG_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(OriginalType.INT_64)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.SHORT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_16)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BYTE_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_8)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.CHAR_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.DATE_TYPE_INFO)) return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
            if (!basicTypeInfo.equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) return fieldType;
            return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            if (!mapTypeInfo.getKeyTypeInfo().equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) throw new UnsupportedOperationException(String.format("Can not convert Flink MapTypeInfo %s to Parquet Map type as key has to be String", typeInfo.toString()));
            return (Type)((Types.MapBuilder)org.apache.parquet.schema.Types.map(repetition).value(ParquetSchemaConverter.convertField(MAP_VALUE, mapTypeInfo.getValueTypeInfo(), Type.Repetition.OPTIONAL, legacyMode))).named(fieldName);
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            GroupType componentGroup = (GroupType)ParquetSchemaConverter.convertField(LIST_ELEMENT, objectArrayTypeInfo.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode);
            if (legacyMode) {
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(componentGroup)).as(OriginalType.LIST)).named(fieldName);
            }
            Type listGroup = (Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(componentGroup)).named(LIST_GROUP_NAME);
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(listGroup)).as(OriginalType.LIST)).named(fieldName);
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo basicArrayType = (BasicArrayTypeInfo)typeInfo;
            if (legacyMode) {
                PrimitiveType primitiveTyp = ParquetSchemaConverter.convertField(fieldName, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode).asPrimitiveType();
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(primitiveTyp)).as(OriginalType.LIST)).named(fieldName);
            }
            Type listGroup = (Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertField(LIST_ELEMENT, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode))).named(LIST_GROUP_NAME);
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(listGroup)).as(OriginalType.LIST)).named(fieldName);
        }
        if (typeInfo instanceof SqlTimeTypeInfo) {
            if (typeInfo.equals((Object)SqlTimeTypeInfo.DATE)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.DATE)).named(fieldName);
            }
            if (typeInfo.equals((Object)SqlTimeTypeInfo.TIME)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.TIME_MILLIS)).named(fieldName);
            }
            if (!typeInfo.equals((Object)SqlTimeTypeInfo.TIMESTAMP)) throw new UnsupportedOperationException("Unsupported SqlTimeTypeInfo " + typeInfo.toString());
            return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(OriginalType.TIMESTAMP_MILLIS)).named(fieldName);
        }
        RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
        ArrayList<Type> types = new ArrayList<Type>();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
        for (int i = 0; i < rowTypeInfo.getArity(); ++i) {
            types.add(ParquetSchemaConverter.convertField(fieldNames[i], fieldTypes[i], repetition, legacyMode));
        }
        if (fieldName != null) return new GroupType(repetition, fieldName, types);
        return new MessageType(MESSAGE_ROOT, types);
    }

    public static MessageType convertToParquetMessageType(String name, RowType rowType) {
        Type[] types = new Type[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types[i] = ParquetSchemaConverter.convertToParquetType((String)rowType.getFieldNames().get(i), rowType.getTypeAt(i));
        }
        return new MessageType(name, types);
    }

    private static Type convertToParquetType(String name, LogicalType type) {
        return ParquetSchemaConverter.convertToParquetType(name, type, Type.Repetition.OPTIONAL);
    }

    private static Type convertToParquetType(String name, LogicalType type, Type.Repetition repetition) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(name);
            }
            case BOOLEAN: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(name);
            }
            case BINARY: 
            case VARBINARY: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).named(name);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                int numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).precision(precision)).scale(scale)).length(numBytes)).as(OriginalType.DECIMAL)).named(name);
            }
            case TINYINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_8)).named(name);
            }
            case SMALLINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_16)).named(name);
            }
            case INTEGER: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).named(name);
            }
            case BIGINT: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name);
            }
            case FLOAT: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(name);
            }
            case DOUBLE: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.DATE)).named(name);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.TIME_MILLIS)).named(name);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

