/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.ServerName;
import org.apache.yetus.audience.InterfaceAudience;

/**
 * Statistics update about a server/region
 */
@InterfaceAudience.Private
public final class ResultStatsUtil {
  private ResultStatsUtil() {
    //private ctor for util class
  }

  /**
   * Update the statistics for the specified region.
   *
   * @param tracker tracker to update
   * @param server server from which the result was obtained
   * @param regionName full region name for the statistics
   * @param stats statistics to update for the specified region
   */
  public static void updateStats(StatisticTrackable tracker, ServerName server, byte[] regionName,
    RegionLoadStats stats) {
    if (regionName != null && stats != null && tracker != null) {
      tracker.updateRegionStats(server, regionName, stats);
    }
  }
}
