/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.source.ExpressionPredicates;
import org.apache.hudi.table.format.CastMap;
import org.apache.hudi.table.format.InternalSchemaManager;
import org.apache.hudi.table.format.ParquetSplitRecordIterator;
import org.apache.hudi.table.format.SchemaEvolvedRecordIterator;
import org.apache.hudi.table.format.cow.ParquetSplitReaderUtil;
import org.apache.hudi.util.RowDataProjection;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.SerializationUtil;

public abstract class RecordIterators {
    public static ClosableIterator<RowData> getParquetRecordIterator(InternalSchemaManager internalSchemaManager, boolean utcTimestamp, boolean caseSensitive, Configuration conf, String[] fieldNames, DataType[] fieldTypes, Map<String, Object> partitionSpec, int[] selectedFields, int batchSize, Path path, long splitStart, long splitLength, List<ExpressionPredicates.Predicate> predicates) throws IOException {
        FilterPredicate filterPredicate = RecordIterators.getFilterPredicate(conf);
        for (ExpressionPredicates.Predicate predicate : predicates) {
            FilterPredicate filter = predicate.filter();
            if (filter == null) continue;
            filterPredicate = filterPredicate == null ? filter : FilterApi.and((FilterPredicate)filterPredicate, (FilterPredicate)filter);
        }
        UnboundRecordFilter recordFilter = RecordIterators.getUnboundRecordFilterInstance(conf);
        InternalSchema mergeSchema = internalSchemaManager.getMergeSchema(path.getName());
        if (mergeSchema.isEmptySchema()) {
            return new ParquetSplitRecordIterator(ParquetSplitReaderUtil.genPartColumnarRowReader((boolean)utcTimestamp, (boolean)caseSensitive, (Configuration)conf, (String[])fieldNames, (DataType[])fieldTypes, partitionSpec, (int[])selectedFields, (int)batchSize, (Path)path, (long)splitStart, (long)splitLength, (FilterPredicate)filterPredicate, (UnboundRecordFilter)recordFilter));
        }
        CastMap castMap = internalSchemaManager.getCastMap(mergeSchema, fieldNames, fieldTypes, selectedFields);
        Option<RowDataProjection> castProjection = castMap.toRowDataProjection(selectedFields);
        ParquetSplitRecordIterator itr = new ParquetSplitRecordIterator(ParquetSplitReaderUtil.genPartColumnarRowReader((boolean)utcTimestamp, (boolean)caseSensitive, (Configuration)conf, (String[])internalSchemaManager.getMergeFieldNames(mergeSchema, fieldNames), (DataType[])castMap.getFileFieldTypes(), partitionSpec, (int[])selectedFields, (int)batchSize, (Path)path, (long)splitStart, (long)splitLength, (FilterPredicate)filterPredicate, (UnboundRecordFilter)recordFilter));
        if (castProjection.isPresent()) {
            return new SchemaEvolvedRecordIterator(itr, (RowDataProjection)castProjection.get());
        }
        return itr;
    }

    private static FilterPredicate getFilterPredicate(Configuration configuration) {
        try {
            return (FilterPredicate)SerializationUtil.readObjectFromConfAsBase64((String)"parquet.private.read.filter.predicate", (Configuration)configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static UnboundRecordFilter getUnboundRecordFilterInstance(Configuration configuration) {
        Class clazz = ConfigurationUtil.getClassFromConfig((Configuration)configuration, (String)"parquet.read.filter", UnboundRecordFilter.class);
        if (clazz == null) {
            return null;
        }
        try {
            UnboundRecordFilter unboundRecordFilter = (UnboundRecordFilter)clazz.newInstance();
            if (unboundRecordFilter instanceof Configurable) {
                ((Configurable)unboundRecordFilter).setConf(configuration);
            }
            return unboundRecordFilter;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", (Throwable)e);
        }
    }
}

