/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.adapter.Utils;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCatalogUtil.class);

    public static HiveConf createHiveConf(@Nullable String hiveConfDir, Configuration flinkConf) {
        HiveConf hiveConf;
        block17: {
            org.apache.hadoop.conf.Configuration hadoopConf = HadoopConfigurations.getHadoopConf(flinkConf);
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
            if (hiveConfDir != null) {
                Path hiveSite = new Path(hiveConfDir, "hive-site.xml");
                if (!hiveSite.toUri().isAbsolute()) {
                    hiveSite = new Path(new File(hiveSite.toString()).toURI());
                }
                try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                    hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                    HoodieCatalogUtil.isEmbeddedMetastore(hiveConf);
                    break block17;
                }
                catch (IOException e) {
                    throw new CatalogException("Failed to load hive-site.xml from specified path:" + hiveSite, (Throwable)e);
                }
            }
            URL hiveSite = Thread.currentThread().getContextClassLoader().getResource("hive-site.xml");
            if (hiveSite != null) {
                LOG.info("Found {} in classpath: {}", (Object)"hive-site.xml", (Object)hiveSite);
                hiveConf.addResource(hiveSite);
            }
        }
        return hiveConf;
    }

    public static boolean isEmbeddedMetastore(HiveConf hiveConf) {
        return StringUtils.isNullOrWhitespaceOnly((String)hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
    }

    public static List<String> getPartitionKeys(CatalogTable table) {
        if (table.isPartitioned()) {
            return table.getPartitionKeys();
        }
        if (table.getOptions().containsKey(FlinkOptions.PARTITION_PATH_FIELD.key())) {
            return Arrays.stream(((String)table.getOptions().get(FlinkOptions.PARTITION_PATH_FIELD.key())).split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String inferPartitionPath(boolean hiveStylePartitioning, CatalogPartitionSpec catalogPartitionSpec) {
        return catalogPartitionSpec.getPartitionSpec().entrySet().stream().map(entry -> hiveStylePartitioning ? String.format("%s=%s", entry.getKey(), entry.getValue()) : (String)entry.getValue()).collect(Collectors.joining("/"));
    }

    @VisibleForTesting
    public static List<String> getOrderedPartitionValues(String catalogName, HiveConf hiveConf, CatalogPartitionSpec partitionSpec, List<String> partitionKeys, ObjectPath tablePath) throws PartitionSpecInvalidException {
        Map spec = partitionSpec.getPartitionSpec();
        if (spec.size() != partitionKeys.size()) {
            throw new PartitionSpecInvalidException(catalogName, partitionKeys, tablePath, partitionSpec);
        }
        ArrayList<String> values = new ArrayList<String>(spec.size());
        for (String key : partitionKeys) {
            if (!spec.containsKey(key)) {
                throw new PartitionSpecInvalidException(catalogName, partitionKeys, tablePath, partitionSpec);
            }
            String value = (String)spec.get(key);
            if (value == null) {
                value = hiveConf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME);
            }
            values.add(value);
        }
        return values;
    }

    protected static void alterTable(AbstractCatalog catalog, ObjectPath tablePath, CatalogBaseTable newTable, List tableChanges, boolean ignoreIfNotExists, org.apache.hadoop.conf.Configuration hadoopConf, BiFunction<ObjectPath, CatalogBaseTable, String> inferTablePathFunc, BiConsumer<ObjectPath, CatalogBaseTable> postAlterTableFunc) throws TableNotExistException, CatalogException {
        Function<LogicalType, Type> convertFunc;
        InternalSchema newSchema;
        CatalogBaseTable oldTable;
        HoodieFlinkWriteClient<?> writeClient;
        Pair pair;
        InternalSchema oldSchema;
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)newTable, (String)"New catalog table cannot be null");
        if (!HoodieCatalogUtil.isUpdatePermissible(catalog, tablePath, newTable, ignoreIfNotExists)) {
            return;
        }
        if (!tableChanges.isEmpty() && !(oldSchema = (InternalSchema)(pair = (writeClient = HoodieCatalogUtil.createWriteClient(tablePath, oldTable = catalog.getTable(tablePath), hadoopConf, inferTablePathFunc)).getInternalSchemaAndMetaClient()).getLeft()).equals((Object)(newSchema = Utils.applyTableChange((InternalSchema)oldSchema, (List)tableChanges, convertFunc = logicalType -> AvroInternalSchemaConverter.convertToField((Schema)AvroSchemaConverter.convertToSchema(logicalType)))))) {
            writeClient.setOperationType(WriteOperationType.ALTER_SCHEMA);
            writeClient.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
        }
        postAlterTableFunc.accept(tablePath, newTable);
    }

    protected static HoodieFlinkWriteClient<?> createWriteClient(ObjectPath tablePath, CatalogBaseTable table, org.apache.hadoop.conf.Configuration hadoopConf, BiFunction<ObjectPath, CatalogBaseTable, String> inferTablePathFunc) {
        Map options = table.getOptions();
        String tablePathStr = inferTablePathFunc.apply(tablePath, table);
        return HoodieCatalogUtil.createWriteClient(options, tablePathStr, tablePath, hadoopConf);
    }

    protected static HoodieFlinkWriteClient<?> createWriteClient(Map<String, String> options, String tablePathStr, ObjectPath tablePath, org.apache.hadoop.conf.Configuration hadoopConf) {
        options.put(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), "true");
        return FlinkWriteClients.createWriteClientV2(Configuration.fromMap(options).set(FlinkOptions.TABLE_NAME, (Object)tablePath.getObjectName()).set(FlinkOptions.SOURCE_AVRO_SCHEMA, (Object)((Schema)StreamerUtil.createMetaClient(tablePathStr, hadoopConf).getTableConfig().getTableCreateSchema().get()).toString()));
    }

    private static boolean sameOptions(Map<String, String> parameters1, Map<String, String> parameters2, ConfigOption<String> option) {
        return parameters1.getOrDefault(option.key(), String.valueOf(option.defaultValue())).equalsIgnoreCase(parameters2.getOrDefault(option.key(), String.valueOf(option.defaultValue())));
    }

    private static boolean isUpdatePermissible(AbstractCatalog catalog, ObjectPath tablePath, CatalogBaseTable newCatalogTable, boolean ignoreIfNotExists) throws TableNotExistException {
        List<String> newPartitionKeys;
        if (!newCatalogTable.getOptions().getOrDefault(FactoryUtil.CONNECTOR.key(), "").equalsIgnoreCase("hudi")) {
            throw new HoodieCatalogException(String.format("The %s is not hoodie table", tablePath.getObjectName()));
        }
        if (newCatalogTable instanceof CatalogView) {
            throw new HoodieCatalogException("Hoodie catalog does not support to ALTER VIEW");
        }
        if (!catalog.tableExists(tablePath)) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(catalog.getName(), tablePath);
            }
            return false;
        }
        CatalogBaseTable oldCatalogTable = catalog.getTable(tablePath);
        List<String> oldPartitionKeys = HoodieCatalogUtil.getPartitionKeys((CatalogTable)oldCatalogTable);
        if (!oldPartitionKeys.equals(newPartitionKeys = HoodieCatalogUtil.getPartitionKeys((CatalogTable)newCatalogTable))) {
            throw new HoodieCatalogException("Hoodie catalog does not support to alter table partition keys");
        }
        Map oldOptions = oldCatalogTable.getOptions();
        if (!HoodieCatalogUtil.sameOptions(oldOptions, newCatalogTable.getOptions(), FlinkOptions.TABLE_TYPE) || !HoodieCatalogUtil.sameOptions(oldOptions, newCatalogTable.getOptions(), FlinkOptions.INDEX_TYPE)) {
            throw new HoodieCatalogException("Hoodie catalog does not support to alter table type and index type");
        }
        return true;
    }
}

