/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.prune;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.util.ExpressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyPruners {
    private static final Logger LOG = LoggerFactory.getLogger(PrimaryKeyPruners.class);
    public static final int BUCKET_ID_NO_PRUNING = -1;

    public static int getBucketId(List<ResolvedExpression> hashKeyFilters, Configuration conf) {
        List<String> pkFields = Arrays.asList(conf.getString(FlinkOptions.RECORD_KEY_FIELD).split(","));
        boolean logicalTimestamp = OptionsResolver.isConsistentLogicalTimestampEnabled(conf);
        List values = hashKeyFilters.stream().map(filter -> {
            Pair<FieldReferenceExpression, ValueLiteralExpression> children = PrimaryKeyPruners.castChildAs(filter.getChildren());
            return Pair.of((Object)pkFields.indexOf(((FieldReferenceExpression)children.getLeft()).getName()), (Object)StringUtils.objToString((Object)ExpressionUtils.getKeyFromLiteral((ValueLiteralExpression)children.getRight(), logicalTimestamp)));
        }).sorted(Map.Entry.comparingByKey()).map(Pair::getValue).collect(Collectors.toList());
        return BucketIdentifier.getBucketId(values, (int)conf.getInteger(FlinkOptions.BUCKET_INDEX_NUM_BUCKETS));
    }

    private static Pair<FieldReferenceExpression, ValueLiteralExpression> castChildAs(List<Expression> children) {
        Expression lExpr = children.get(0);
        Expression rExpr = children.get(1);
        if (lExpr instanceof FieldReferenceExpression) {
            return Pair.of((Object)((FieldReferenceExpression)lExpr), (Object)((ValueLiteralExpression)rExpr));
        }
        return Pair.of((Object)((FieldReferenceExpression)rExpr), (Object)((ValueLiteralExpression)lExpr));
    }
}

