/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.transform;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.apache.hudi.sink.utils.PayloadCreation;
import org.apache.hudi.util.RowDataToAvroConverters;
import org.apache.hudi.util.StreamerUtil;

public class RowDataToHoodieFunction<I extends RowData, O extends HoodieRecord>
extends RichMapFunction<I, O> {
    private final RowType rowType;
    private transient Schema avroSchema;
    private transient RowDataToAvroConverters.RowDataToAvroConverter converter;
    private transient KeyGenerator keyGenerator;
    private transient PayloadCreation payloadCreation;
    private final Configuration config;

    public RowDataToHoodieFunction(RowType rowType, Configuration config) {
        this.rowType = rowType;
        this.config = config;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.avroSchema = StreamerUtil.getSourceSchema(this.config);
        this.converter = RowDataToAvroConverters.createConverter((LogicalType)this.rowType, this.config.getBoolean(FlinkOptions.WRITE_UTC_TIMEZONE));
        this.keyGenerator = HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)StreamerUtil.flinkConf2TypedProperties(this.config));
        this.payloadCreation = PayloadCreation.instance(this.config);
    }

    public O map(I i) throws Exception {
        return (O)this.toHoodieRecord(i);
    }

    private HoodieRecord toHoodieRecord(I record) throws Exception {
        GenericRecord gr = (GenericRecord)this.converter.convert(this.avroSchema, record);
        HoodieKey hoodieKey = this.keyGenerator.getKey(gr);
        HoodieRecordPayload<?> payload = this.payloadCreation.createPayload(gr);
        HoodieOperation operation = HoodieOperation.fromValue((byte)record.getRowKind().toByteValue());
        return new HoodieAvroRecord(hoodieKey, payload, operation);
    }
}

