/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.text.ParseException;
import org.apache.flink.metrics.MetricGroup;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.metrics.HoodieFlinkMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkWriteMetrics
extends HoodieFlinkMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkWriteMetrics.class);
    protected final String actionType;
    private long totalPartitionsWritten;
    private long totalFilesInsert;
    private long totalFilesUpdate;
    private long totalRecordsWritten;
    private long totalUpdateRecordsWritten;
    private long totalInsertRecordsWritten;
    private long totalBytesWritten;
    private long totalScanTime;
    private long totalCompactedRecordsUpdated;
    private long totalLogFilesCompacted;
    private long totalLogFilesSize;
    private long commitEpochTimeInMs;
    private long durationInMs;

    public FlinkWriteMetrics(MetricGroup metricGroup, String actionType) {
        super(metricGroup);
        this.actionType = actionType;
    }

    @Override
    public void registerMetrics() {
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalPartitionsWritten"), () -> this.totalPartitionsWritten);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalFilesInsert"), () -> this.totalFilesInsert);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalFilesUpdate"), () -> this.totalFilesUpdate);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalRecordsWritten"), () -> this.totalRecordsWritten);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalUpdateRecordsWritten"), () -> this.totalUpdateRecordsWritten);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalInsertRecordsWritten"), () -> this.totalInsertRecordsWritten);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalBytesWritten"), () -> this.totalBytesWritten);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalScanTime"), () -> this.totalScanTime);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalCompactedRecordsUpdated"), () -> this.totalCompactedRecordsUpdated);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalLogFilesCompacted"), () -> this.totalLogFilesCompacted);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "totalLogFilesSize"), () -> this.totalLogFilesSize);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "commitTime"), () -> this.commitEpochTimeInMs);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "duration"), () -> this.durationInMs);
    }

    public void updateCommitMetrics(String instantTime, HoodieCommitMetadata metadata) {
        long commitEpochTimeInMs;
        try {
            commitEpochTimeInMs = HoodieInstantTimeGenerator.parseDateFromInstantTime((String)instantTime).getTime();
        }
        catch (ParseException e) {
            LOG.warn("Invalid input issued instant: " + instantTime);
            return;
        }
        this.updateCommitMetrics(commitEpochTimeInMs, System.currentTimeMillis() - commitEpochTimeInMs, metadata);
    }

    public void updateCommitMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata) {
        this.updateCommitTimingMetrics(commitEpochTimeInMs, durationInMs);
        this.totalPartitionsWritten = metadata.fetchTotalPartitionsWritten();
        this.totalFilesInsert = metadata.fetchTotalFilesInsert();
        this.totalFilesUpdate = metadata.fetchTotalFilesUpdated();
        this.totalRecordsWritten = metadata.fetchTotalRecordsWritten();
        this.totalUpdateRecordsWritten = metadata.fetchTotalUpdateRecordsWritten();
        this.totalInsertRecordsWritten = metadata.fetchTotalInsertRecordsWritten();
        this.totalBytesWritten = metadata.fetchTotalBytesWritten();
        this.totalScanTime = metadata.getTotalScanTime();
        this.totalCompactedRecordsUpdated = metadata.getTotalCompactedRecordsUpdated();
        this.totalLogFilesCompacted = metadata.getTotalLogFilesCompacted();
        this.totalLogFilesSize = metadata.getTotalLogFilesSize();
    }

    private void updateCommitTimingMetrics(long commitEpochTimeInMs, long durationInMs) {
        this.commitEpochTimeInMs = commitEpochTimeInMs;
        this.durationInMs = durationInMs;
    }

    protected String getMetricsName(String action, String metric) {
        return String.format("%s.%s", action, metric);
    }
}

