/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieFlinkEngineContext {
    private HoodieFlinkEngineContext context;

    @BeforeEach
    public void init() {
        this.context = new HoodieFlinkEngineContext((TaskContextSupplier)new FlinkTaskContextSupplier(null));
    }

    @Test
    public void testMap() {
        List<Integer> mapList = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List result = this.context.map(mapList, (SerializableFunction & Serializable)x -> x + 1, 2);
        result.removeAll(mapList);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((int)11, (Integer)((Integer)result.get(0)));
    }

    @Test
    public void testFlatMap() {
        List<String> list1 = Arrays.asList("a", "b", "c");
        List<String> list2 = Arrays.asList("d", "e", "f");
        List<String> list3 = Arrays.asList("g", "h", "i");
        ArrayList<List<String>> inputList = new ArrayList<List<String>>();
        inputList.add(list1);
        inputList.add(list2);
        inputList.add(list3);
        List result = this.context.flatMap(inputList, Collection::stream, 2);
        Assertions.assertEquals((int)9, (int)result.size());
    }

    @Test
    public void testForeach() {
        List<Integer> mapList = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        ArrayList result = new ArrayList(10);
        this.context.foreach(mapList, result::add, 2);
        Assertions.assertEquals((int)result.size(), (int)mapList.size());
        Assertions.assertTrue((boolean)result.containsAll(mapList));
    }

    @Test
    public void testMapToPair() {
        List<String> mapList = Arrays.asList("spark_hudi", "flink_hudi");
        Map resultMap = this.context.mapToPair(mapList, (SerializablePairFunction & Serializable)x -> {
            String[] splits = x.split("_");
            return new ImmutablePair((Object)splits[0], (Object)splits[1]);
        }, Integer.valueOf(2));
        Assertions.assertEquals(resultMap.get("spark"), resultMap.get("flink"));
    }
}

