/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.avro.Schema;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRecordSizeEstimator<T>
implements SizeEstimator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRecordSizeEstimator.class);
    private final long sizeOfSchema;

    public HoodieRecordSizeEstimator(Schema schema) {
        this.sizeOfSchema = ObjectSizeCalculator.getObjectSize(schema);
    }

    @Override
    public long sizeEstimate(T hoodieRecord) {
        long sizeOfRecord = ObjectSizeCalculator.getObjectSize(hoodieRecord);
        LOG.debug("SizeOfRecord => " + sizeOfRecord + " SizeOfSchema => " + this.sizeOfSchema);
        return sizeOfRecord;
    }
}

