/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieWriteStat;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommitUtils.class);
    private static final String NULL_SCHEMA_STR = Schema.create((Schema.Type)Schema.Type.NULL).toString();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String getCommitActionType(WriteOperationType operation, HoodieTableType tableType) {
        if (operation == WriteOperationType.INSERT_OVERWRITE || operation == WriteOperationType.INSERT_OVERWRITE_TABLE || operation == WriteOperationType.DELETE_PARTITION) {
            return "replacecommit";
        }
        return CommitUtils.getCommitActionType(tableType);
    }

    public static String getCommitActionType(HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return "commit";
            }
            case MERGE_ON_READ: {
                return "deltacommit";
            }
        }
        throw new HoodieException("Could not commit on unknown table type " + (Object)((Object)tableType));
    }

    public static HoodieCommitMetadata buildMetadata(List<org.apache.hudi.common.model.HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, Option<Map<String, String>> extraMetadata, WriteOperationType operationType, String schemaToStoreInCommit, String commitActionType) {
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadataFromStats(writeStats, partitionToReplaceFileIds, commitActionType, operationType);
        if (extraMetadata.isPresent()) {
            ((Map)extraMetadata.get()).forEach(commitMetadata::addMetadata);
        }
        commitMetadata.addMetadata("schema", schemaToStoreInCommit == null || schemaToStoreInCommit.equals(NULL_SCHEMA_STR) ? "" : schemaToStoreInCommit);
        commitMetadata.setOperationType(operationType);
        return commitMetadata;
    }

    private static HoodieCommitMetadata buildMetadataFromStats(List<org.apache.hudi.common.model.HoodieWriteStat> writeStats, Map<String, List<String>> partitionToReplaceFileIds, String commitActionType, WriteOperationType operationType) {
        HoodieCommitMetadata commitMetadata;
        if (ClusteringUtils.isClusteringOrReplaceCommitAction(commitActionType)) {
            HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
            replaceMetadata.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
            commitMetadata = replaceMetadata;
        } else {
            commitMetadata = new HoodieCommitMetadata();
        }
        for (org.apache.hudi.common.model.HoodieWriteStat writeStat : writeStats) {
            String partition = writeStat.getPartitionPath();
            commitMetadata.addWriteStat(partition, writeStat);
        }
        LOG.info("Creating  metadata for " + (Object)((Object)operationType) + " numWriteStats:" + writeStats.size() + " numReplaceFileIds:" + partitionToReplaceFileIds.values().stream().mapToInt(e -> e.size()).sum());
        return commitMetadata;
    }

    public static Option<HoodieCommitMetadata> buildMetadataFromInstant(HoodieTimeline timeline, HoodieInstant instant) {
        try {
            TimelineLayout layout = TimelineLayout.fromVersion(timeline.getTimelineLayoutVersion());
            HoodieCommitMetadata commitMetadata = layout.getCommitMetadataSerDe().deserialize(instant, (byte[])timeline.getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            return Option.of((Object)commitMetadata);
        }
        catch (IOException e) {
            LOG.info("Failed to parse HoodieCommitMetadata for " + instant.toString(), (Throwable)e);
            return Option.empty();
        }
    }

    public static Set<Pair<String, String>> getPartitionAndFileIdWithoutSuffixFromSpecificRecord(Map<String, List<HoodieWriteStat>> partitionToWriteStats) {
        HashSet<Pair<String, String>> partitionToFileId = new HashSet<Pair<String, String>>();
        for (Map.Entry<String, List<HoodieWriteStat>> entry : partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat stat : entry.getValue()) {
                partitionToFileId.add(Pair.of(entry.getKey(), stat.getFileId()));
            }
        }
        return partitionToFileId;
    }

    public static Set<Pair<String, String>> getPartitionAndFileIdWithoutSuffix(Map<String, List<org.apache.hudi.common.model.HoodieWriteStat>> partitionToWriteStats) {
        HashSet<Pair<String, String>> partitionTofileId = new HashSet<Pair<String, String>>();
        for (Map.Entry<String, List<org.apache.hudi.common.model.HoodieWriteStat>> entry : partitionToWriteStats.entrySet()) {
            for (org.apache.hudi.common.model.HoodieWriteStat stat : entry.getValue()) {
                partitionTofileId.add(Pair.of(entry.getKey(), stat.getFileId()));
            }
        }
        return partitionTofileId;
    }

    public static Set<Pair<String, String>> flattenPartitionToReplaceFileIds(Map<String, List<String>> partitionToReplaceFileIds) {
        return partitionToReplaceFileIds.entrySet().stream().flatMap(partitionFileIds -> ((List)partitionFileIds.getValue()).stream().map(replaceFileId -> Pair.of(partitionFileIds.getKey(), replaceFileId))).collect(Collectors.toSet());
    }

    public static Option<String> getValidCheckpointForCurrentWriter(HoodieTimeline timeline, String checkpointKey, String keyToLookup) {
        TimelineLayout layout = TimelineLayout.fromVersion(timeline.getTimelineLayoutVersion());
        return timeline.getWriteTimeline().filterCompletedInstants().getReverseOrderedInstants().map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = layout.getCommitMetadataSerDe().deserialize((HoodieInstant)instant, (byte[])timeline.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                String checkpointValue = commitMetadata.getMetadata(checkpointKey);
                if (StringUtils.nonEmpty((String)checkpointValue)) {
                    return CommitUtils.readCheckpointValue(checkpointValue, keyToLookup);
                }
                return Option.empty();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to parse HoodieCommitMetadata for " + instant.toString(), e);
            }
        }).filter(Option::isPresent).findFirst().orElse(Option.empty());
    }

    public static Option<String> readCheckpointValue(String value, String id) {
        try {
            Map checkpointMap = (Map)OBJECT_MAPPER.readValue(value, Map.class);
            if (!checkpointMap.containsKey(id)) {
                return Option.empty();
            }
            String checkpointVal = (String)checkpointMap.get(id);
            return Option.of((Object)checkpointVal);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to parse checkpoint as map", e);
        }
    }

    public static String getCheckpointValueAsString(String identifier, String batchId) {
        try {
            HashMap<String, String> checkpointMap = new HashMap<String, String>();
            checkpointMap.put(identifier, batchId);
            return OBJECT_MAPPER.writeValueAsString(checkpointMap);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to parse checkpoint as map", e);
        }
    }
}

