/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeGeneratorBase
implements TimeGenerator,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TimeGeneratorBase.class);
    private volatile LockProvider<?> lockProvider;
    private final int lockAcquireWaitTimeInMs;
    protected final HoodieTimeGeneratorConfig config;
    private final LockConfiguration lockConfiguration;
    private final StorageConfiguration<?> storageConf;
    private final RetryHelper<Boolean, HoodieLockException> lockRetryHelper;

    public TimeGeneratorBase(HoodieTimeGeneratorConfig config, StorageConfiguration<?> storageConf) {
        this.config = config;
        this.lockConfiguration = config.getLockConfiguration();
        this.storageConf = storageConf;
        int maxRetries = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.num_retries", Integer.parseInt(LockConfiguration.DEFAULT_LOCK_ACQUIRE_NUM_RETRIES));
        this.lockAcquireWaitTimeInMs = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.wait_time_ms", 60000);
        long maxWaitTimeInMs = this.lockConfiguration.getConfig().getLong("hoodie.write.lock.client.wait_time_ms_between_retry", Long.parseLong(LockConfiguration.DEFAULT_LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS));
        this.lockRetryHelper = new RetryHelper(maxWaitTimeInMs, maxRetries, maxWaitTimeInMs, Arrays.asList(HoodieLockException.class, InterruptedException.class), "acquire timeGenerator lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockProvider<?> getLockProvider() {
        if (this.lockProvider == null) {
            TimeGeneratorBase timeGeneratorBase = this;
            synchronized (timeGeneratorBase) {
                if (this.lockProvider == null) {
                    String lockProviderClass = this.lockConfiguration.getConfig().getString("hoodie.write.lock.provider");
                    LOG.info("LockProvider for TimeGenerator: {}", (Object)lockProviderClass);
                    this.lockProvider = (LockProvider)ReflectionUtils.loadClass((String)lockProviderClass, (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class}, (Object[])new Object[]{this.lockConfiguration, this.storageConf});
                }
            }
        }
        return this.lockProvider;
    }

    public void lock() {
        this.lockRetryHelper.start((RetryHelper.CheckedFunction & Serializable)() -> {
            try {
                if (!this.getLockProvider().tryLock(this.lockAcquireWaitTimeInMs, TimeUnit.MILLISECONDS)) {
                    throw new HoodieLockException("Unable to acquire the lock. Current lock owner information : " + this.getLockProvider().getCurrentOwnerLockInfo());
                }
                return true;
            }
            catch (InterruptedException e) {
                throw new HoodieLockException(e);
            }
        });
    }

    public void unlock() {
        this.getLockProvider().unlock();
        this.closeQuietly();
    }

    private synchronized void closeQuietly() {
        try {
            if (this.lockProvider != null) {
                this.lockProvider.close();
                this.lockProvider = null;
                LOG.info("Released the connection of the timeGenerator lock");
            }
        }
        catch (Exception e) {
            LOG.info("Unable to release the connection of the timeGenerator lock");
        }
    }
}

