/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.HoodieLogFormatReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHoodieLogRecordScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHoodieLogRecordScanner.class);
    protected final Schema readerSchema;
    private final String latestInstantTime;
    protected final HoodieTableMetaClient hoodieTableMetaClient;
    private final String payloadClassFQN;
    private final String recordKeyField;
    private final Option<String> partitionPathFieldOpt;
    private final Option<String> partitionNameOverrideOpt;
    protected final String preCombineField;
    protected final HoodieRecordMerger recordMerger;
    private final TypedProperties payloadProps;
    protected final List<String> logFilePaths;
    private final boolean reverseReader;
    private final int bufferSize;
    private final Option<InstantRange> instantRange;
    private final boolean withOperationField;
    private final HoodieStorage storage;
    private AtomicLong totalLogFiles = new AtomicLong(0L);
    private final InternalSchema internalSchema;
    private AtomicLong totalLogBlocks = new AtomicLong(0L);
    private AtomicLong totalLogRecords = new AtomicLong(0L);
    private AtomicLong totalRollbacks = new AtomicLong(0L);
    private AtomicLong totalCorruptBlocks = new AtomicLong(0L);
    private Deque<HoodieLogBlock> currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
    protected final boolean forceFullScan;
    private float progress = 0.0f;
    private final boolean populateMetaFields;
    protected final HoodieRecord.HoodieRecordType recordType;
    private final List<String> validBlockInstants = new ArrayList<String>();
    private final boolean enableOptimizedLogBlocksScan;
    private final HoodieTableVersion tableVersion;
    private HoodieTimeline commitsTimeline = null;
    private HoodieTimeline completedInstantsTimeline = null;
    private HoodieTimeline inflightInstantsTimeline = null;

    protected AbstractHoodieLogRecordScanner(HoodieStorage storage, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionNameOverride, InternalSchema internalSchema, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieRecordMerger recordMerger, Option<HoodieTableMetaClient> hoodieTableMetaClientOption) {
        this.readerSchema = readerSchema;
        this.latestInstantTime = latestInstantTime;
        this.hoodieTableMetaClient = (HoodieTableMetaClient)hoodieTableMetaClientOption.orElseGet(() -> HoodieTableMetaClient.builder().setStorage(storage).setBasePath(basePath).build());
        HoodieTableConfig tableConfig = this.hoodieTableMetaClient.getTableConfig();
        this.payloadClassFQN = tableConfig.getPayloadClass();
        this.preCombineField = tableConfig.getPreCombineField();
        TypedProperties props = new TypedProperties();
        if (this.preCombineField != null) {
            props.setProperty("hoodie.payload.ordering.field", this.preCombineField);
        }
        this.tableVersion = tableConfig.getTableVersion();
        this.payloadProps = props;
        this.recordMerger = recordMerger;
        this.totalLogFiles.addAndGet(logFilePaths.size());
        this.logFilePaths = logFilePaths;
        this.reverseReader = reverseReader;
        this.storage = storage;
        this.bufferSize = bufferSize;
        this.instantRange = instantRange;
        this.withOperationField = withOperationField;
        this.forceFullScan = forceFullScan;
        this.internalSchema = internalSchema == null ? InternalSchema.getEmptyInternalSchema() : internalSchema;
        this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
        if (keyFieldOverride.isPresent()) {
            ValidationUtils.checkState((boolean)partitionNameOverride.isPresent());
            this.populateMetaFields = false;
            this.recordKeyField = (String)keyFieldOverride.get();
            this.partitionPathFieldOpt = Option.empty();
        } else if (tableConfig.populateMetaFields()) {
            this.populateMetaFields = true;
            this.recordKeyField = HoodieRecord.RECORD_KEY_METADATA_FIELD;
            this.partitionPathFieldOpt = Option.of((Object)HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        } else {
            this.populateMetaFields = false;
            this.recordKeyField = tableConfig.getRecordKeyFieldProp();
            this.partitionPathFieldOpt = Option.of((Object)tableConfig.getPartitionFieldProp());
        }
        this.partitionNameOverrideOpt = partitionNameOverride;
        this.recordType = recordMerger.getRecordType();
    }

    private HoodieTimeline getOrCreateCompletedInstantsTimeline() {
        if (this.commitsTimeline == null) {
            this.commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        }
        if (this.completedInstantsTimeline == null) {
            this.completedInstantsTimeline = this.commitsTimeline.filterCompletedInstants();
        }
        return this.completedInstantsTimeline;
    }

    private HoodieTimeline getOrCreateInflightInstantsTimeline() {
        if (this.commitsTimeline == null) {
            this.commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        }
        if (this.inflightInstantsTimeline == null) {
            this.inflightInstantsTimeline = this.commitsTimeline.filterInflights();
        }
        return this.inflightInstantsTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanInternal(Option<KeySpec> keySpecOpt, boolean skipProcessingBlocks) {
        AbstractHoodieLogRecordScanner abstractHoodieLogRecordScanner = this;
        synchronized (abstractHoodieLogRecordScanner) {
            if (this.enableOptimizedLogBlocksScan) {
                this.scanInternalV2(keySpecOpt, skipProcessingBlocks);
            } else {
                this.scanInternalV1(keySpecOpt);
            }
        }
    }

    private void scanInternalV1(Option<KeySpec> keySpecOpt) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReader logFormatReaderWrapper = null;
        try {
            logFormatReaderWrapper = new HoodieLogFormatReader(this.storage, this.logFilePaths.stream().map(filePath -> new HoodieLogFile(new StoragePath(filePath))).collect(Collectors.toList()), this.readerSchema, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block19: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile = logFormatReaderWrapper.getLogFile();
                LOG.info("Scanning log file {}", (Object)logFile);
                scannedLogFiles.add(logFile);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.isDataOrDeleteBlock() && (this.tableVersion.lesserThan(HoodieTableVersion.EIGHT) && (!this.getOrCreateCompletedInstantsTimeline().containsOrBeforeTimelineStarts(instantTime) || this.getOrCreateInflightInstantsTimeline().containsInstant(instantTime)) || InstantComparison.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), InstantComparison.GREATER_THAN, this.latestInstantTime) || this.instantRange.isPresent() && !((InstantRange)this.instantRange.get()).isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case PARQUET_DATA_BLOCK: {
                        LOG.info("Reading a data block from file {} at instant {}", (Object)logFile.getPath(), (Object)instantTime);
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                    case DELETE_BLOCK: {
                        LOG.info("Reading a delete block from file {}", (Object)logFile.getPath());
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                    case COMMAND_BLOCK: {
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                        LOG.info("Reading a command block {} with targetInstantTime {} from file {}", new Object[]{commandBlock.getType(), targetInstantForCommandBlock, logFile.getPath()});
                        switch (commandBlock.getType()) {
                            case ROLLBACK_BLOCK: {
                                int instantLogBlockSizeBeforeRollback = this.currentInstantLogBlocks.size();
                                this.currentInstantLogBlocks.removeIf(block -> {
                                    if (block.getBlockType() == HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK) {
                                        LOG.info("Rolling back the last corrupted log block read in {}", (Object)logFile.getPath());
                                        return true;
                                    }
                                    if (targetInstantForCommandBlock.contentEquals(block.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) {
                                        LOG.info("Rolling back an older log block read from {} with instantTime {}", (Object)logFile.getPath(), (Object)targetInstantForCommandBlock);
                                        return true;
                                    }
                                    return false;
                                });
                                int numBlocksRolledBack = instantLogBlockSizeBeforeRollback - this.currentInstantLogBlocks.size();
                                this.totalRollbacks.addAndGet(numBlocksRolledBack);
                                LOG.info("Number of applied rollback blocks {}", (Object)numBlocksRolledBack);
                                if (numBlocksRolledBack != 0) continue block19;
                                LOG.warn("TargetInstantTime {} invalid or extra rollback command block in {}", (Object)targetInstantForCommandBlock, (Object)logFile.getPath());
                                continue block19;
                            }
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                    case CORRUPT_BLOCK: {
                        LOG.info("Found a corrupt block in {}", (Object)logFile.getPath());
                        this.totalCorruptBlocks.incrementAndGet();
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                }
                throw new UnsupportedOperationException("Block type not supported yet");
            }
            if (!this.currentInstantLogBlocks.isEmpty()) {
                LOG.info("Merging the final data blocks");
                this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error("Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error("Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", (Throwable)e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private void scanInternalV2(Option<KeySpec> keySpecOption, boolean skipProcessingBlocks) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReader logFormatReaderWrapper = null;
        try {
            logFormatReaderWrapper = new HoodieLogFormatReader(this.storage, this.logFilePaths.stream().map(logFile -> new HoodieLogFile(new StoragePath(logFile))).collect(Collectors.toList()), this.readerSchema, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<String> targetRollbackInstants = new HashSet<String>();
            HashMap<String, List> instantToBlocksMap = new HashMap<String, List>();
            ArrayList<String> orderedInstantsList = new ArrayList<String>();
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block14: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile2 = logFormatReaderWrapper.getLogFile();
                LOG.info("Scanning log file {}", (Object)logFile2);
                scannedLogFiles.add(logFile2);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.getBlockType().equals((Object)HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK)) {
                    LOG.info("Found a corrupt block in {}", (Object)logFile2.getPath());
                    this.totalCorruptBlocks.incrementAndGet();
                    continue;
                }
                if (logBlock.isDataOrDeleteBlock() && InstantComparison.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), InstantComparison.GREATER_THAN, this.latestInstantTime) || logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK && (this.tableVersion.lesserThan(HoodieTableVersion.EIGHT) && (!this.getOrCreateCompletedInstantsTimeline().containsOrBeforeTimelineStarts(instantTime) || this.getOrCreateInflightInstantsTimeline().containsInstant(instantTime)) || this.instantRange.isPresent() && !((InstantRange)this.instantRange.get()).isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case PARQUET_DATA_BLOCK: 
                    case DELETE_BLOCK: {
                        List logBlocksList = instantToBlocksMap.getOrDefault(instantTime, new ArrayList());
                        if (logBlocksList.isEmpty()) {
                            orderedInstantsList.add(instantTime);
                        }
                        logBlocksList.add(logBlock);
                        instantToBlocksMap.put(instantTime, logBlocksList);
                        continue block14;
                    }
                    case COMMAND_BLOCK: {
                        LOG.info("Reading a command block from file {}", (Object)logFile2.getPath());
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        if (commandBlock.getType().equals((Object)HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK)) {
                            this.totalRollbacks.incrementAndGet();
                            String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                            targetRollbackInstants.add(targetInstantForCommandBlock);
                            orderedInstantsList.remove(targetInstantForCommandBlock);
                            instantToBlocksMap.remove(targetInstantForCommandBlock);
                            continue block14;
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                }
                throw new UnsupportedOperationException("Block type not yet supported.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordered instant times seen {}", orderedInstantsList);
            }
            int numBlocksRolledBack = 0;
            HashSet<String> instantTimesIncluded = new HashSet<String>();
            HashMap blockTimeToCompactionBlockTimeMap = new HashMap();
            for (int i = orderedInstantsList.size() - 1; i >= 0; --i) {
                List logBlocks;
                String instantTime = (String)orderedInstantsList.get(i);
                List instantsBlocks = (List)instantToBlocksMap.get(instantTime);
                if (instantsBlocks.isEmpty()) {
                    throw new HoodieException("Data corrupted while writing. Found zero blocks for an instant " + instantTime);
                }
                HoodieLogBlock firstBlock = (HoodieLogBlock)instantsBlocks.get(0);
                if (firstBlock.getLogBlockHeader().containsKey((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES)) {
                    Arrays.stream(firstBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES).split(",")).forEach(originalInstant -> {
                        String finalInstant = blockTimeToCompactionBlockTimeMap.getOrDefault(instantTime, instantTime);
                        blockTimeToCompactionBlockTimeMap.put(originalInstant, finalInstant);
                    });
                    continue;
                }
                String compactedFinalInstantTime = (String)blockTimeToCompactionBlockTimeMap.get(instantTime);
                if (compactedFinalInstantTime == null) {
                    logBlocks = (List)instantToBlocksMap.get(instantTime);
                    Collections.reverse(logBlocks);
                    logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                    instantTimesIncluded.add(instantTime);
                    this.validBlockInstants.add(instantTime);
                    continue;
                }
                if (instantTimesIncluded.contains(compactedFinalInstantTime)) continue;
                logBlocks = (List)instantToBlocksMap.get(compactedFinalInstantTime);
                Collections.reverse(logBlocks);
                logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                instantTimesIncluded.add(compactedFinalInstantTime);
                this.validBlockInstants.add(compactedFinalInstantTime);
            }
            LOG.info("Number of applied rollback blocks {}", (Object)numBlocksRolledBack);
            if (LOG.isDebugEnabled()) {
                LOG.info("Final view of the Block time to compactionBlockMap {}", blockTimeToCompactionBlockTimeMap);
            }
            if (!this.currentInstantLogBlocks.isEmpty() && !skipProcessingBlocks) {
                LOG.info("Merging the final data blocks");
                this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOption);
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error("Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error("Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", (Throwable)e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws Exception {
        ValidationUtils.checkState((this.partitionNameOverrideOpt.isPresent() || this.partitionPathFieldOpt.isPresent() ? 1 : 0) != 0, (String)"Either partition-name override or partition-path field had to be present");
        Option recordKeyPartitionPathFieldPair = this.populateMetaFields ? Option.empty() : Option.of(Pair.of(this.recordKeyField, this.partitionPathFieldOpt.orElse(null)));
        Pair<ClosableIterator<HoodieRecord>, Schema> recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        try (ClosableIterator<HoodieRecord> recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                HoodieRecord completedRecord = ((HoodieRecord)recordIterator.next()).wrapIntoHoodieRecordPayloadWithParams(recordsIteratorSchemaPair.getRight(), this.hoodieTableMetaClient.getTableConfig().getProps(), (Option<Pair<String, String>>)recordKeyPartitionPathFieldPair, this.withOperationField, this.partitionNameOverrideOpt, this.populateMetaFields, (Option<Schema>)Option.empty());
                this.processNextRecord(completedRecord);
                this.totalLogRecords.incrementAndGet();
            }
        }
    }

    protected abstract <T> void processNextRecord(HoodieRecord<T> var1) throws Exception;

    protected abstract void processNextDeletedRecord(DeleteRecord var1);

    private void processQueuedBlocksForInstant(Deque<HoodieLogBlock> logBlocks, int numLogFilesSeen, Option<KeySpec> keySpecOpt) throws Exception {
        while (!logBlocks.isEmpty()) {
            LOG.info("Number of remaining logblocks to merge {}", (Object)logBlocks.size());
            HoodieLogBlock lastBlock = logBlocks.pollLast();
            switch (lastBlock.getBlockType()) {
                case HFILE_DATA_BLOCK: 
                case AVRO_DATA_BLOCK: 
                case PARQUET_DATA_BLOCK: {
                    this.processDataBlock((HoodieDataBlock)lastBlock, keySpecOpt);
                    break;
                }
                case DELETE_BLOCK: {
                    Arrays.stream(((HoodieDeleteBlock)lastBlock).getRecordsToDelete()).forEach(this::processNextDeletedRecord);
                    break;
                }
                case CORRUPT_BLOCK: {
                    LOG.warn("Found a corrupt block which was not rolled back");
                    break;
                }
            }
        }
        this.progress = (numLogFilesSeen - 1) / this.logFilePaths.size();
    }

    private boolean shouldLookupRecords() {
        return !this.forceFullScan;
    }

    public float getProgress() {
        return this.progress;
    }

    public long getTotalLogFiles() {
        return this.totalLogFiles.get();
    }

    public long getTotalLogRecords() {
        return this.totalLogRecords.get();
    }

    public long getTotalLogBlocks() {
        return this.totalLogBlocks.get();
    }

    protected String getPayloadClassFQN() {
        return this.payloadClassFQN;
    }

    public Option<String> getPartitionNameOverride() {
        return this.partitionNameOverrideOpt;
    }

    public long getTotalRollbacks() {
        return this.totalRollbacks.get();
    }

    public long getTotalCorruptBlocks() {
        return this.totalCorruptBlocks.get();
    }

    public boolean isWithOperationField() {
        return this.withOperationField;
    }

    protected TypedProperties getPayloadProps() {
        return this.payloadProps;
    }

    public Deque<HoodieLogBlock> getCurrentInstantLogBlocks() {
        return this.currentInstantLogBlocks;
    }

    public List<String> getValidBlockInstants() {
        return this.validBlockInstants;
    }

    private Pair<ClosableIterator<HoodieRecord>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        ClosableIterator blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = (KeySpec)keySpecOpt.get();
            blockRecordsIterator = dataBlock.getRecordIterator(keySpec.getKeys(), keySpec.isFullKey(), this.recordType);
        } else {
            blockRecordsIterator = dataBlock.getRecordIterator(this.recordType);
        }
        Option<Pair<Function<HoodieRecord, HoodieRecord>, Schema>> schemaEvolutionTransformerOpt = this.composeEvolvedSchemaTransformer(dataBlock);
        Function transformer = (Function)schemaEvolutionTransformerOpt.map(Pair::getLeft).orElse(Function.identity());
        Schema schema = (Schema)schemaEvolutionTransformerOpt.map(Pair::getRight).orElseGet(dataBlock::getSchema);
        return Pair.of(new CloseableMappingIterator(blockRecordsIterator, transformer), schema);
    }

    private Option<Pair<Function<HoodieRecord, HoodieRecord>, Schema>> composeEvolvedSchemaTransformer(HoodieDataBlock dataBlock) {
        if (this.internalSchema.isEmptySchema()) {
            return Option.empty();
        }
        long currentInstantTime = Long.parseLong(dataBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(currentInstantTime, this.hoodieTableMetaClient);
        InternalSchema mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false).mergeSchema();
        Schema mergedAvroSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, this.readerSchema.getFullName());
        return Option.of(Pair.of(record -> record.rewriteRecordWithNewSchema(dataBlock.getSchema(), this.hoodieTableMetaClient.getTableConfig().getProps(), mergedAvroSchema, Collections.emptyMap()), mergedAvroSchema));
    }

    public static abstract class Builder {
        public abstract Builder withStorage(HoodieStorage var1);

        public abstract Builder withBasePath(String var1);

        public abstract Builder withBasePath(StoragePath var1);

        public abstract Builder withLogFilePaths(List<String> var1);

        public abstract Builder withReaderSchema(Schema var1);

        public abstract Builder withInternalSchema(InternalSchema var1);

        public abstract Builder withLatestInstantTime(String var1);

        public abstract Builder withReverseReader(boolean var1);

        public abstract Builder withBufferSize(int var1);

        public Builder withPartition(String partitionName) {
            throw new UnsupportedOperationException();
        }

        public Builder withInstantRange(Option<InstantRange> instantRange) {
            throw new UnsupportedOperationException();
        }

        public Builder withOperationField(boolean withOperationField) {
            throw new UnsupportedOperationException();
        }

        public Builder withRecordMerger(HoodieRecordMerger recordMerger) {
            throw new UnsupportedOperationException();
        }

        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            throw new UnsupportedOperationException();
        }

        public Builder withKeyFieldOverride(String keyFieldOverride) {
            throw new UnsupportedOperationException();
        }

        public Builder withForceFullScan(boolean forceFullScan) {
            throw new UnsupportedOperationException();
        }

        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            throw new UnsupportedOperationException();
        }

        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            throw new UnsupportedOperationException();
        }

        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            throw new UnsupportedOperationException();
        }

        public Builder withBitCaskDiskMapCompressionEnabled(boolean bitCaskDiskMapCompressionEnabled) {
            throw new UnsupportedOperationException();
        }

        public Builder withTableMetaClient(HoodieTableMetaClient hoodieTableMetaClient) {
            throw new UnsupportedOperationException();
        }

        public abstract AbstractHoodieLogRecordScanner build();
    }

    private static class PrefixKeySpec
    implements KeySpec {
        private final List<String> keysPrefixes;

        private PrefixKeySpec(List<String> keysPrefixes) {
            this.keysPrefixes = keysPrefixes;
        }

        @Override
        public List<String> getKeys() {
            return this.keysPrefixes;
        }

        @Override
        public boolean isFullKey() {
            return false;
        }
    }

    private static class FullKeySpec
    implements KeySpec {
        private final List<String> keys;

        private FullKeySpec(List<String> keys) {
            this.keys = keys;
        }

        @Override
        public List<String> getKeys() {
            return this.keys;
        }

        @Override
        public boolean isFullKey() {
            return true;
        }
    }

    protected static interface KeySpec {
        public List<String> getKeys();

        public boolean isFullKey();

        public static KeySpec fullKeySpec(List<String> keys) {
            return new FullKeySpec(keys);
        }

        public static KeySpec prefixKeySpec(List<String> keyPrefixes) {
            return new PrefixKeySpec(keyPrefixes);
        }
    }
}

