/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.hudi.common.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieIndexDefinition
implements Serializable {
    private String indexName;
    private String indexType;
    private String indexFunction;
    private List<String> sourceFields;
    private Map<String, String> indexOptions;

    public HoodieIndexDefinition() {
    }

    HoodieIndexDefinition(String indexName, String indexType, String indexFunction, List<String> sourceFields, Map<String, String> indexOptions) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.indexFunction = StringUtils.nonEmpty((String)indexFunction) ? indexFunction : "";
        this.sourceFields = sourceFields;
        this.indexOptions = indexOptions;
    }

    public String getIndexFunction() {
        return this.indexFunction;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public String getExpressionIndexFormatOption(String defaultValue) {
        return this.indexOptions.getOrDefault("format", defaultValue);
    }

    public String getExpressionIndexFormatOption() {
        return this.indexOptions.get("format");
    }

    public String getExpressionIndexDaysOption() {
        return this.indexOptions.get("days");
    }

    public String getExpressionIndexPositionOption() {
        return this.indexOptions.get("pos");
    }

    public String getExpressionIndexLengthOption() {
        return this.indexOptions.get("len");
    }

    public String getExpressionIndexPatternOption() {
        return this.indexOptions.get("pattern");
    }

    public String getExpressionIndexReplacementOption() {
        return this.indexOptions.get("replacement");
    }

    public String getExpressionIndexIndexOption() {
        return this.indexOptions.get("idx");
    }

    public String getExpressionIndexTrimStringOption() {
        return this.indexOptions.get("trimString");
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return new StringJoiner(", ", HoodieIndexDefinition.class.getSimpleName() + "[", "]").add("indexName='" + this.indexName + "'").add("indexType='" + this.indexType + "'").add("indexFunction='" + this.indexFunction + "'").add("sourceFields=" + this.sourceFields).add("indexOptions=" + this.indexOptions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HoodieIndexDefinition)) {
            return false;
        }
        HoodieIndexDefinition that = (HoodieIndexDefinition)o;
        return this.getIndexName().equals(that.getIndexName()) && this.getIndexType().equals(that.getIndexType()) && this.getIndexFunction().equals(that.getIndexFunction()) && this.getSourceFields().equals(that.getSourceFields()) && this.getIndexOptions().equals(that.getIndexOptions());
    }

    public int hashCode() {
        return Objects.hash(this.getIndexName(), this.getIndexType(), this.getIndexFunction(), this.getSourceFields(), this.getIndexOptions());
    }

    public static class Builder {
        private String indexName;
        private String indexType;
        private String indexFunction;
        private List<String> sourceFields = new ArrayList<String>();
        private Map<String, String> indexOptions = new HashMap<String, String>();

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder withIndexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder withIndexFunction(String indexFunction) {
            this.indexFunction = indexFunction;
            return this;
        }

        public Builder withSourceFields(List<String> sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public Builder withIndexOptions(Map<String, String> indexOptions) {
            this.indexOptions = indexOptions;
            return this;
        }

        public HoodieIndexDefinition build() {
            return new HoodieIndexDefinition(this.indexName, this.indexType, this.indexFunction, this.sourceFields, this.indexOptions);
        }
    }
}

