/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.math.BigDecimal;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.common.util.collection.Pair;

public abstract class DecimalLogicalTypeProcessor
extends JsonFieldProcessor {
    protected static boolean isValidDecimalTypeConfig(Schema schema) {
        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
        if (decimalType == null) {
            return false;
        }
        decimalType.validate(schema);
        return true;
    }

    protected static Pair<Boolean, BigDecimal> parseObjectToBigDecimal(Object obj, Schema schema) {
        BigDecimal bigDecimal = null;
        if (obj instanceof Number) {
            bigDecimal = BigDecimal.valueOf(((Number)obj).doubleValue());
        }
        if (obj instanceof String) {
            try {
                bigDecimal = new BigDecimal((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bigDecimal == null) {
            return Pair.of(false, null);
        }
        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
        if (bigDecimal.scale() > decimalType.getScale() || bigDecimal.precision() - bigDecimal.scale() > decimalType.getPrecision() - decimalType.getScale()) {
            return Pair.of(false, null);
        }
        return Pair.of(true, bigDecimal);
    }
}

