/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.ConvertingGenericData;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LocalDateWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.util.Lazy;

public class HoodieAvroUtils {
    public static final String AVRO_VERSION = Schema.class.getPackage().getImplementationVersion();
    private static final ThreadLocal<BinaryEncoder> BINARY_ENCODER = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<BinaryDecoder> BINARY_DECODER = ThreadLocal.withInitial(() -> null);
    private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final Lazy<StringWrapper.Builder> STRING_WRAPPER_BUILDER_STUB = Lazy.lazily(StringWrapper::newBuilder);
    private static final Lazy<BytesWrapper.Builder> BYTES_WRAPPER_BUILDER_STUB = Lazy.lazily(BytesWrapper::newBuilder);
    private static final Lazy<DoubleWrapper.Builder> DOUBLE_WRAPPER_BUILDER_STUB = Lazy.lazily(DoubleWrapper::newBuilder);
    private static final Lazy<FloatWrapper.Builder> FLOAT_WRAPPER_BUILDER_STUB = Lazy.lazily(FloatWrapper::newBuilder);
    private static final Lazy<LongWrapper.Builder> LONG_WRAPPER_BUILDER_STUB = Lazy.lazily(LongWrapper::newBuilder);
    private static final Lazy<IntWrapper.Builder> INT_WRAPPER_BUILDER_STUB = Lazy.lazily(IntWrapper::newBuilder);
    private static final Lazy<BooleanWrapper.Builder> BOOLEAN_WRAPPER_BUILDER_STUB = Lazy.lazily(BooleanWrapper::newBuilder);
    private static final Lazy<TimestampMicrosWrapper.Builder> TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB = Lazy.lazily(TimestampMicrosWrapper::newBuilder);
    private static final Lazy<DecimalWrapper.Builder> DECIMAL_WRAPPER_BUILDER_STUB = Lazy.lazily(DecimalWrapper::newBuilder);
    private static final Lazy<DateWrapper.Builder> DATE_WRAPPER_BUILDER_STUB = Lazy.lazily(DateWrapper::newBuilder);
    private static final Lazy<LocalDateWrapper.Builder> LOCAL_DATE_WRAPPER_BUILDER_STUB = Lazy.lazily(LocalDateWrapper::newBuilder);
    private static final long MILLIS_PER_DAY = 86400000L;
    public static final Conversions.DecimalConversion DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final Pattern INVALID_AVRO_CHARS_IN_NAMES_PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final Pattern INVALID_AVRO_FIRST_CHAR_IN_NAMES_PATTERN = Pattern.compile("[^A-Za-z_]");
    private static final String MASK_FOR_INVALID_CHARS_IN_NAMES = "__";
    private static final Properties PROPERTIES = new Properties();
    public static final Schema METADATA_FIELD_SCHEMA = AvroSchemaUtils.createNullableSchema(Schema.Type.STRING);
    public static final Schema RECORD_KEY_SCHEMA = HoodieAvroUtils.initRecordKeySchema();

    public static Option<byte[]> recordToBytes(HoodieRecord record, Schema schema) throws IOException {
        return Option.of((Object)HoodieAvroUtils.indexedRecordToBytes((IndexedRecord)((HoodieAvroIndexedRecord)record.toIndexedRecord(schema, new Properties()).get()).getData()));
    }

    public static byte[] avroToBytes(GenericRecord record) {
        return HoodieAvroUtils.indexedRecordToBytes(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IndexedRecord> byte[] indexedRecordToBytes(T record) {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema(), ConvertingGenericData.INSTANCE);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, BINARY_ENCODER.get());
            BINARY_ENCODER.set(encoder);
            writer.write(record, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot convert GenericRecord to bytes", e);
        }
    }

    public static String avroToJsonString(GenericRecord record, boolean pretty) throws IOException {
        return HoodieAvroUtils.avroToJsonHelper(record, pretty).toString();
    }

    public static String safeAvroToJsonString(GenericRecord record) {
        try {
            return HoodieAvroUtils.avroToJsonString(record, false);
        }
        catch (Exception e) {
            return record.toString();
        }
    }

    public static byte[] avroToJson(GenericRecord record, boolean pretty) throws IOException {
        return HoodieAvroUtils.avroToJsonHelper(record, pretty).toByteArray();
    }

    private static ByteArrayOutputStream avroToJsonHelper(GenericRecord record, boolean pretty) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), (OutputStream)out, pretty);
        writer.write((Object)record, (Encoder)jsonEncoder);
        jsonEncoder.flush();
        return out;
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema schema) throws IOException {
        return HoodieAvroUtils.bytesToAvro(bytes, schema, schema);
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema writerSchema, Schema readerSchema) throws IOException {
        return HoodieAvroUtils.bytesToAvro(bytes, 0, bytes.length, writerSchema, readerSchema);
    }

    public static GenericRecord bytesToAvro(byte[] bytes, int offset, int length, Schema writerSchema, Schema readerSchema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, offset, length, BINARY_DECODER.get());
        BINARY_DECODER.set(decoder);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        return (GenericRecord)reader.read(null, (Decoder)decoder);
    }

    public static GenericRecord jsonBytesToAvro(byte[] bytes, Schema schema) throws IOException {
        ByteArrayInputStream bio = new ByteArrayInputStream(bytes);
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)bio);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
    }

    public static boolean isTypeNumeric(Schema.Type type) {
        return type == Schema.Type.INT || type == Schema.Type.LONG || type == Schema.Type.FLOAT || type == Schema.Type.DOUBLE;
    }

    public static boolean isMetadataField(String fieldName) {
        return HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(fieldName);
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public static Schema createHoodieWriteSchema(String originalSchema) {
        return HoodieAvroUtils.createHoodieWriteSchema(new Schema.Parser().parse(originalSchema));
    }

    public static Schema createHoodieWriteSchema(String originalSchema, boolean withOperationField) {
        return HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(originalSchema), withOperationField);
    }

    public static Schema addMetadataFields(Schema schema) {
        return HoodieAvroUtils.addMetadataFields(schema, false);
    }

    public static Schema addMetadataFields(Schema schema, boolean withOperationField) {
        int newFieldsSize = HoodieRecord.HOODIE_META_COLUMNS.size() + (withOperationField ? 1 : 0);
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>(schema.getFields().size() + newFieldsSize);
        Schema.Field commitTimeField = new Schema.Field(HoodieRecord.COMMIT_TIME_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field commitSeqnoField = new Schema.Field(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field recordKeyField = new Schema.Field(HoodieRecord.RECORD_KEY_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field(HoodieRecord.PARTITION_PATH_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field fileNameField = new Schema.Field(HoodieRecord.FILENAME_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        parentFields.add(commitTimeField);
        parentFields.add(commitSeqnoField);
        parentFields.add(recordKeyField);
        parentFields.add(partitionPathField);
        parentFields.add(fileNameField);
        if (withOperationField) {
            Schema.Field operationField = new Schema.Field(HoodieRecord.OPERATION_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
            parentFields.add(operationField);
        }
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField(field.name())) continue;
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
            for (Map.Entry prop : field.getObjectProps().entrySet()) {
                newField.addProp((String)prop.getKey(), prop.getValue());
            }
            parentFields.add(newField);
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(schema, parentFields);
    }

    public static boolean isSchemaNull(Schema schema) {
        return schema == null || schema.getType() == Schema.Type.NULL;
    }

    public static Schema removeMetadataFields(Schema schema) {
        if (HoodieAvroUtils.isSchemaNull(schema)) {
            return schema;
        }
        return HoodieAvroUtils.removeFields(schema, HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION);
    }

    public static Schema removeFields(Schema schema, Set<String> fieldsToRemove) {
        List<Schema.Field> filteredFields = schema.getFields().stream().filter(field -> !fieldsToRemove.contains(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(schema, filteredFields);
    }

    public static String addMetadataColumnTypes(String hiveColumnTypes) {
        return "string,string,string,string,string," + hiveColumnTypes;
    }

    public static Schema makeFieldNonNull(Schema schema, String fieldName, Object fieldDefaultValue) {
        ValidationUtils.checkArgument((fieldDefaultValue != null ? 1 : 0) != 0);
        List<Schema.Field> filteredFields = schema.getFields().stream().map(field -> {
            if (Objects.equals(field.name(), fieldName)) {
                return new Schema.Field(field.name(), AvroSchemaUtils.resolveNullableSchema(field.schema()), field.doc(), fieldDefaultValue);
            }
            return new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
        }).collect(Collectors.toList());
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(schema, filteredFields);
    }

    private static Schema initRecordKeySchema() {
        Schema.Field recordKeyField = new Schema.Field(HoodieRecord.RECORD_KEY_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema recordKeySchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        recordKeySchema.setFields(Collections.singletonList(recordKeyField));
        return recordKeySchema;
    }

    public static Schema getRecordKeySchema() {
        return RECORD_KEY_SCHEMA;
    }

    public static Schema getRecordKeyPartitionPathSchema() {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        Schema.Field recordKeyField = new Schema.Field(HoodieRecord.RECORD_KEY_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field(HoodieRecord.PARTITION_PATH_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        toBeAddedFields.add(recordKeyField);
        toBeAddedFields.add(partitionPathField);
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static Schema getSchemaForFields(Schema fileSchema, List<String> fields) {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        for (Schema.Field schemaField : fileSchema.getFields()) {
            if (!fields.contains(schemaField.name())) continue;
            toBeAddedFields.add(new Schema.Field(schemaField.name(), schemaField.schema(), schemaField.doc(), schemaField.defaultVal()));
        }
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static GenericRecord addHoodieKeyToRecord(GenericRecord record, String recordKey, String partitionPath, String fileName) {
        record.put(HoodieRecord.FILENAME_METADATA_FIELD, (Object)fileName);
        record.put(HoodieRecord.PARTITION_PATH_METADATA_FIELD, (Object)partitionPath);
        record.put(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)recordKey);
        return record;
    }

    public static GenericRecord addOperationToRecord(GenericRecord record, HoodieOperation operation) {
        record.put(HoodieRecord.OPERATION_METADATA_FIELD, (Object)operation.getName());
        return record;
    }

    public static GenericRecord addCommitMetadataToRecord(GenericRecord record, String instantTime, String commitSeqno) {
        record.put(HoodieRecord.COMMIT_TIME_METADATA_FIELD, (Object)instantTime);
        record.put(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, (Object)commitSeqno);
        return record;
    }

    public static GenericRecord stitchRecords(GenericRecord left, GenericRecord right, Schema stitchedSchema) {
        GenericData.Record result = new GenericData.Record(stitchedSchema);
        for (Schema.Field f : left.getSchema().getFields()) {
            result.put(f.name(), left.get(f.name()));
        }
        for (Schema.Field f : right.getSchema().getFields()) {
            result.put(f.name(), right.get(f.name()));
        }
        return result;
    }

    public static GenericRecord rewriteRecord(GenericRecord oldRecord, Schema newSchema) {
        boolean isSpecificRecord = oldRecord instanceof SpecificRecordBase;
        Object newRecord = HoodieAvroUtils.rewriteRecordWithNewSchemaInternal(oldRecord, oldRecord.getSchema(), newSchema, Collections.emptyMap(), new LinkedList<String>(), isSpecificRecord);
        return (GenericData.Record)newRecord;
    }

    public static List<GenericRecord> rewriteRecords(List<GenericRecord> records, Schema newSchema) {
        return records.stream().map(r -> HoodieAvroUtils.rewriteRecord(r, newSchema)).collect(Collectors.toList());
    }

    public static GenericRecord removeFields(GenericRecord record, Set<String> fieldsToRemove) {
        Schema newSchema = HoodieAvroUtils.removeFields(record.getSchema(), fieldsToRemove);
        return HoodieAvroUtils.rewriteRecord(record, newSchema);
    }

    public static Schema generateProjectionSchema(Schema originalSchema, List<String> fieldNames) {
        Map<String, Schema.Field> schemaFieldsMap = originalSchema.getFields().stream().map(r -> Pair.of(r.name().toLowerCase(), r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field = schemaFieldsMap.get(fn.toLowerCase());
            if (field == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
        }
        Schema projectedSchema = Schema.createRecord((String)originalSchema.getName(), (String)originalSchema.getDoc(), (String)originalSchema.getNamespace(), (boolean)originalSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static String getRootLevelFieldName(String fieldName) {
        return fieldName.split("\\.")[0];
    }

    public static Object getFieldVal(GenericRecord record, String key) {
        return HoodieAvroUtils.getFieldVal(record, key, true);
    }

    public static Object getFieldVal(GenericRecord record, String key, boolean returnNullIfNotFound) {
        Schema.Field field = record.getSchema().getField(key);
        if (field == null) {
            if (returnNullIfNotFound) {
                return null;
            }
            throw new AvroRuntimeException("Not a valid schema field: " + key);
        }
        return record.get(field.pos());
    }

    public static String getNestedFieldValAsString(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        Object obj = HoodieAvroUtils.getNestedFieldVal(record, fieldName, returnNullIfNotFound, consistentLogicalTimestampEnabled);
        return StringUtils.objToString((Object)obj);
    }

    public static Object getNestedFieldVal(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (int i = 0; i < parts.length; ++i) {
            Object val;
            String part = parts[i];
            try {
                val = HoodieAvroUtils.getFieldVal(valueNode, part, returnNullIfNotFound);
            }
            catch (AvroRuntimeException e) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new HoodieException(fieldName + "(Part -" + parts[i] + ") field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
            }
            if (i == parts.length - 1) {
                if (val == null) {
                    return null;
                }
                Schema fieldSchema = valueNode.getSchema().getField(part).schema();
                return HoodieAvroUtils.convertValueForSpecificDataTypes(fieldSchema, val, consistentLogicalTimestampEnabled);
            }
            if (!(val instanceof GenericRecord)) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        throw new HoodieException(fieldName + " field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
    }

    public static Schema getNestedFieldSchemaFromRecord(GenericRecord record, String fieldName) {
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Object val = valueNode.get(part);
            if (i == parts.length - 1) {
                return AvroSchemaUtils.resolveNullableSchema(valueNode.getSchema().getField(part).schema());
            }
            if (!(val instanceof GenericRecord)) {
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        throw new HoodieException("Failed to get schema. Not a valid field name: " + fieldName);
    }

    public static Schema getNestedFieldSchemaFromWriteSchema(Schema writeSchema, String fieldName) {
        String[] parts = fieldName.split("\\.");
        Schema currentSchema = writeSchema;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            try {
                currentSchema = AvroSchemaUtils.resolveNullableSchema(currentSchema.getField(part).schema());
                if (i != parts.length - 1) continue;
                return AvroSchemaUtils.resolveNullableSchema(currentSchema);
            }
            catch (Exception e) {
                throw new HoodieException("Failed to get schema. Not a valid field name: " + fieldName);
            }
        }
        throw new HoodieException("Failed to get schema. Not a valid field name: " + fieldName);
    }

    public static Option<String> getNullableValAsString(GenericRecord rec, String fieldName) {
        Schema.Field field = rec.getSchema().getField(fieldName);
        String fieldVal = field == null ? null : StringUtils.objToString((Object)rec.get(field.pos()));
        return Option.ofNullable(fieldVal);
    }

    public static Object convertValueForSpecificDataTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema == null) {
            return fieldValue;
        }
        if (fieldValue == null) {
            ValidationUtils.checkState((boolean)AvroSchemaUtils.isNullable(fieldSchema));
            return null;
        }
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(AvroSchemaUtils.resolveNullableSchema(fieldSchema), fieldValue, consistentLogicalTimestampEnabled);
    }

    private static Object convertValueForAvroLogicalTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema.getLogicalType() == LogicalTypes.date()) {
            return LocalDate.ofEpochDay(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMillis() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMicros() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()) / 1000L);
        }
        if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal dc = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            if (fieldSchema.getType() == Schema.Type.FIXED) {
                return decimalConversion.fromFixed((GenericFixed)fieldValue, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
            }
            if (fieldSchema.getType() == Schema.Type.BYTES) {
                ByteBuffer byteBuffer = (ByteBuffer)fieldValue;
                BigDecimal convertedValue = decimalConversion.fromBytes(byteBuffer, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
                byteBuffer.rewind();
                return convertedValue;
            }
        }
        return fieldValue;
    }

    public static Schema getNullSchema() {
        return Schema.create((Schema.Type)Schema.Type.NULL);
    }

    public static String sanitizeName(String name) {
        return HoodieAvroUtils.sanitizeName(name, MASK_FOR_INVALID_CHARS_IN_NAMES);
    }

    public static String sanitizeName(String name, String invalidCharMask) {
        if (INVALID_AVRO_FIRST_CHAR_IN_NAMES_PATTERN.matcher(name.substring(0, 1)).matches()) {
            name = INVALID_AVRO_FIRST_CHAR_IN_NAMES_PATTERN.matcher(name).replaceFirst(invalidCharMask);
        }
        return INVALID_AVRO_CHARS_IN_NAMES_PATTERN.matcher(name).replaceAll(invalidCharMask);
    }

    public static Object[] getRecordColumnValues(HoodieRecord record, String[] columns, Schema schema, boolean consistentLogicalTimestampEnabled) {
        try {
            GenericRecord genericRecord = (GenericRecord)((HoodieAvroIndexedRecord)record.toIndexedRecord(schema, new Properties()).get()).getData();
            ArrayList<Object> list = new ArrayList<Object>();
            for (String col : columns) {
                list.add(HoodieAvroUtils.getNestedFieldVal(genericRecord, col, true, consistentLogicalTimestampEnabled));
            }
            return list.toArray();
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read record with key:" + record.getKey(), e);
        }
    }

    public static Object[] getSortColumnValuesWithPartitionPathAndRecordKey(HoodieRecord record, String[] columns, Schema schema, boolean suffixRecordKey, boolean consistentLogicalTimestampEnabled) {
        try {
            GenericRecord genericRecord = (GenericRecord)((HoodieAvroIndexedRecord)record.toIndexedRecord(schema, PROPERTIES).get()).getData();
            int numColumns = columns.length;
            Object[] values = new Object[columns.length + 1 + (suffixRecordKey ? 1 : 0)];
            values[0] = record.getPartitionPath();
            for (int i = 0; i < columns.length; ++i) {
                values[i + 1] = HoodieAvroUtils.getNestedFieldVal(genericRecord, columns[i], true, consistentLogicalTimestampEnabled);
            }
            if (suffixRecordKey) {
                values[numColumns + 1] = record.getRecordKey();
            }
            return values;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read record with key:" + record.getKey(), e);
        }
    }

    public static Object getRecordColumnValues(HoodieRecord record, String[] columns, SerializableSchema schema, boolean consistentLogicalTimestampEnabled) {
        return HoodieAvroUtils.getRecordColumnValues(record, columns, schema.get(), consistentLogicalTimestampEnabled);
    }

    public static GenericRecord rewriteRecordWithNewSchema(IndexedRecord oldRecord, Schema newSchema) {
        return HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, newSchema, Collections.emptyMap());
    }

    public static GenericRecord rewriteRecordWithNewSchema(IndexedRecord oldRecord, Schema newSchema, Map<String, String> renameCols) {
        Object newRecord = HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, oldRecord.getSchema(), newSchema, renameCols, new LinkedList<String>(), false);
        return (GenericData.Record)newRecord;
    }

    public static GenericRecord rewriteRecordWithNewSchema(IndexedRecord oldRecord, Schema newSchema, Map<String, String> renameCols, boolean validate) {
        Object newRecord = HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, oldRecord.getSchema(), newSchema, renameCols, new LinkedList<String>(), validate);
        return (GenericData.Record)newRecord;
    }

    private static Object rewriteRecordWithNewSchema(Object oldRecord, Schema oldAvroSchema, Schema newSchema, Map<String, String> renameCols, Deque<String> fieldNames, boolean validate) {
        if (oldRecord == null) {
            return null;
        }
        if (oldAvroSchema.equals((Object)newSchema)) {
            return oldRecord;
        }
        Schema oldSchema = HoodieAvroUtils.getActualSchemaFromUnion(oldAvroSchema, oldRecord);
        Object newRecord = HoodieAvroUtils.rewriteRecordWithNewSchemaInternal(oldRecord, oldSchema, newSchema, renameCols, fieldNames, false);
        if (validate && !ConvertingGenericData.INSTANCE.validate(newSchema, newRecord)) {
            throw new SchemaCompatibilityException("Unable to validate the rewritten record " + oldRecord + " against schema " + newSchema);
        }
        return newRecord;
    }

    private static Object rewriteRecordWithNewSchemaInternal(Object oldRecord, Schema oldSchema, Schema newSchema, Map<String, String> renameCols, Deque<String> fieldNames, boolean skipMetadataFields) {
        switch (newSchema.getType()) {
            case RECORD: {
                if (!(oldRecord instanceof IndexedRecord)) {
                    throw new SchemaCompatibilityException("cannot rewrite record with different type");
                }
                IndexedRecord indexedRecord = (IndexedRecord)oldRecord;
                List fields = newSchema.getFields();
                GenericData.Record newRecord = new GenericData.Record(newSchema);
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field = (Schema.Field)fields.get(i);
                    String fieldName = field.name();
                    if (skipMetadataFields && HoodieAvroUtils.isMetadataField(fieldName)) continue;
                    fieldNames.push(fieldName);
                    Schema.Field oldField = oldSchema.getField(field.name());
                    if (oldField != null && !renameCols.containsKey(field.name())) {
                        newRecord.put(i, HoodieAvroUtils.rewriteRecordWithNewSchema(indexedRecord.get(oldField.pos()), oldField.schema(), field.schema(), renameCols, fieldNames, false));
                    } else {
                        Schema.Field oldFieldRenamed;
                        String fieldFullName = HoodieAvroUtils.createFullName(fieldNames);
                        String fieldNameFromOldSchema = renameCols.get(fieldFullName);
                        Schema.Field field2 = oldFieldRenamed = fieldNameFromOldSchema == null ? null : oldSchema.getField(fieldNameFromOldSchema);
                        if (oldFieldRenamed != null) {
                            newRecord.put(i, HoodieAvroUtils.rewriteRecordWithNewSchema(indexedRecord.get(oldFieldRenamed.pos()), oldFieldRenamed.schema(), field.schema(), renameCols, fieldNames, false));
                        } else if (field.defaultVal() instanceof JsonProperties.Null) {
                            newRecord.put(i, null);
                        } else {
                            if (!AvroSchemaUtils.isNullable(field.schema()) && field.defaultVal() == null) {
                                throw new SchemaCompatibilityException("Field " + fieldFullName + " has no default value and is non-nullable");
                            }
                            newRecord.put(i, field.defaultVal());
                        }
                    }
                    fieldNames.pop();
                }
                return newRecord;
            }
            case ENUM: {
                if (oldSchema.getType() != Schema.Type.STRING && oldSchema.getType() != Schema.Type.ENUM) {
                    throw new SchemaCompatibilityException(String.format("Only ENUM or STRING type can be converted ENUM type. Schema type was %s", oldSchema.getType().getName()));
                }
                if (oldSchema.getType() == Schema.Type.STRING) {
                    return new GenericData.EnumSymbol(newSchema, oldRecord);
                }
                return oldRecord;
            }
            case ARRAY: {
                if (!(oldRecord instanceof Collection)) {
                    throw new SchemaCompatibilityException(String.format("Cannot rewrite %s as an array", oldRecord.getClass().getName()));
                }
                Collection array = (Collection)oldRecord;
                ArrayList<Object> newArray = new ArrayList<Object>(array.size());
                fieldNames.push("element");
                for (Object element : array) {
                    newArray.add(HoodieAvroUtils.rewriteRecordWithNewSchema(element, oldSchema.getElementType(), newSchema.getElementType(), renameCols, fieldNames, false));
                }
                fieldNames.pop();
                return newArray;
            }
            case MAP: {
                if (!(oldRecord instanceof Map)) {
                    throw new SchemaCompatibilityException(String.format("Cannot rewrite %s as a map", oldRecord.getClass().getName()));
                }
                Map map = (Map)oldRecord;
                HashMap newMap = new HashMap(map.size(), 1.0f);
                fieldNames.push("value");
                for (Map.Entry entry : map.entrySet()) {
                    newMap.put(entry.getKey(), HoodieAvroUtils.rewriteRecordWithNewSchema(entry.getValue(), oldSchema.getValueType(), newSchema.getValueType(), renameCols, fieldNames, false));
                }
                fieldNames.pop();
                return newMap;
            }
            case UNION: {
                return HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, HoodieAvroUtils.getActualSchemaFromUnion(oldSchema, oldRecord), HoodieAvroUtils.getActualSchemaFromUnion(newSchema, oldRecord), renameCols, fieldNames, false);
            }
        }
        return HoodieAvroUtils.rewritePrimaryType(oldRecord, oldSchema, newSchema);
    }

    public static String createFullName(Deque<String> fieldNames) {
        String result = "";
        if (!fieldNames.isEmpty()) {
            Iterator<String> iter = fieldNames.descendingIterator();
            result = iter.next();
            if (!iter.hasNext()) {
                return result;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result);
            while (iter.hasNext()) {
                sb.append(".");
                sb.append(iter.next());
            }
            result = sb.toString();
        }
        return result;
    }

    public static Object rewritePrimaryType(Object oldValue, Schema oldSchema, Schema newSchema) {
        if (oldSchema.getType() == newSchema.getType()) {
            switch (oldSchema.getType()) {
                case NULL: 
                case BOOLEAN: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BYTES: 
                case STRING: {
                    return oldValue;
                }
                case FIXED: {
                    if (oldSchema.getFixedSize() != newSchema.getFixedSize()) {
                        if (oldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                            byte[] bytes = ((GenericFixed)oldValue).bytes();
                            LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                            BigDecimal bd = new BigDecimal(new BigInteger(bytes), decimal.getScale()).setScale(((LogicalTypes.Decimal)newSchema.getLogicalType()).getScale());
                            return DECIMAL_CONVERSION.toFixed(bd, newSchema, newSchema.getLogicalType());
                        }
                        throw new HoodieAvroSchemaException("Fixed type size change is not currently supported");
                    }
                    if (Objects.equals(oldSchema.getFullName(), newSchema.getFullName())) {
                        return oldValue;
                    }
                    return new GenericData.Fixed(newSchema, ((GenericFixed)oldValue).bytes());
                }
            }
            throw new HoodieAvroSchemaException("Unknown schema type: " + newSchema.getType());
        }
        return HoodieAvroUtils.rewritePrimaryTypeWithDiffSchemaType(oldValue, oldSchema, newSchema);
    }

    private static Object rewritePrimaryTypeWithDiffSchemaType(Object oldValue, Schema oldSchema, Schema newSchema) {
        switch (newSchema.getType()) {
            case NULL: 
            case BOOLEAN: {
                break;
            }
            case INT: {
                if (newSchema.getLogicalType() != LogicalTypes.date() || oldSchema.getType() != Schema.Type.STRING) break;
                return HoodieAvroUtils.fromJavaDate(Date.valueOf(oldValue.toString()));
            }
            case LONG: {
                if (oldSchema.getType() != Schema.Type.INT) break;
                return ((Integer)oldValue).longValue();
            }
            case FLOAT: {
                if (oldSchema.getType() != Schema.Type.INT && oldSchema.getType() != Schema.Type.LONG) break;
                return Float.valueOf(oldSchema.getType() == Schema.Type.INT ? ((Integer)oldValue).floatValue() : ((Long)oldValue).floatValue());
            }
            case DOUBLE: {
                if (oldSchema.getType() == Schema.Type.FLOAT) {
                    return Double.valueOf(oldValue + "");
                }
                if (oldSchema.getType() == Schema.Type.INT) {
                    return ((Integer)oldValue).doubleValue();
                }
                if (oldSchema.getType() != Schema.Type.LONG) break;
                return ((Long)oldValue).doubleValue();
            }
            case BYTES: {
                if (oldSchema.getType() != Schema.Type.STRING) break;
                return ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)oldValue.toString()));
            }
            case STRING: {
                if (oldSchema.getType() == Schema.Type.ENUM) {
                    return String.valueOf(oldValue);
                }
                if (oldSchema.getType() == Schema.Type.BYTES) {
                    return String.valueOf((ByteBuffer)oldValue);
                }
                if (oldSchema.getLogicalType() == LogicalTypes.date()) {
                    return HoodieAvroUtils.toJavaDate((Integer)oldValue).toString();
                }
                if (oldSchema.getType() == Schema.Type.INT || oldSchema.getType() == Schema.Type.LONG || oldSchema.getType() == Schema.Type.FLOAT || oldSchema.getType() == Schema.Type.DOUBLE) {
                    return oldValue.toString();
                }
                if (oldSchema.getType() != Schema.Type.FIXED || !(oldSchema.getLogicalType() instanceof LogicalTypes.Decimal)) break;
                byte[] bytes = ((GenericFixed)oldValue).bytes();
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                BigDecimal bd = new BigDecimal(new BigInteger(bytes), decimal.getScale());
                return bd.toString();
            }
            case FIXED: {
                if (!(newSchema.getLogicalType() instanceof LogicalTypes.Decimal) || oldSchema.getType() != Schema.Type.STRING && oldSchema.getType() != Schema.Type.DOUBLE && oldSchema.getType() != Schema.Type.INT && oldSchema.getType() != Schema.Type.LONG && oldSchema.getType() != Schema.Type.FLOAT) break;
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)newSchema.getLogicalType();
                BigDecimal bigDecimal = new BigDecimal(oldValue.toString()).setScale(decimal.getScale(), RoundingMode.HALF_UP);
                return DECIMAL_CONVERSION.toFixed(bigDecimal, newSchema, newSchema.getLogicalType());
            }
        }
        throw new HoodieAvroSchemaException(String.format("cannot support rewrite value for schema type: %s since the old schema type is: %s", newSchema, oldSchema));
    }

    public static boolean hasSmallPrecisionDecimalField(Schema schema) {
        return HoodieAvroUtils.hasDecimalWithCondition(schema, HoodieAvroUtils::isSmallPrecisionDecimalField);
    }

    private static boolean hasDecimalWithCondition(Schema schema, Function<LogicalTypes.Decimal, Boolean> condition) {
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    if (!HoodieAvroUtils.hasDecimalWithCondition(field.schema(), condition)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return HoodieAvroUtils.hasDecimalWithCondition(schema.getElementType(), condition);
            }
            case MAP: {
                return HoodieAvroUtils.hasDecimalWithCondition(schema.getValueType(), condition);
            }
            case UNION: {
                return HoodieAvroUtils.hasDecimalWithCondition(HoodieAvroUtils.getActualSchemaFromUnion(schema, null), condition);
            }
        }
        if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)schema.getLogicalType();
            return condition.apply(decimal);
        }
        return false;
    }

    private static boolean isSmallPrecisionDecimalField(LogicalTypes.Decimal decimal) {
        return decimal.getPrecision() <= 18;
    }

    public static boolean hasListOrMapField(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    if (!HoodieAvroUtils.hasListOrMapField(field.schema())) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: 
            case MAP: {
                return true;
            }
            case UNION: {
                return HoodieAvroUtils.hasListOrMapField(HoodieAvroUtils.getActualSchemaFromUnion(schema, null));
            }
        }
        return false;
    }

    public static boolean recordNeedsRewriteForExtendedAvroTypePromotion(Schema writerSchema, Schema readerSchema) {
        if (writerSchema.equals((Object)readerSchema)) {
            return false;
        }
        switch (readerSchema.getType()) {
            case RECORD: {
                HashMap<String, Schema.Field> writerFields = new HashMap<String, Schema.Field>();
                for (Schema.Field field : writerSchema.getFields()) {
                    writerFields.put(field.name(), field);
                }
                for (Schema.Field field : readerSchema.getFields()) {
                    if (!writerFields.containsKey(field.name()) || !HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(((Schema.Field)writerFields.get(field.name())).schema(), field.schema())) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                if (writerSchema.getType().equals((Object)Schema.Type.ARRAY)) {
                    return HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(writerSchema.getElementType(), readerSchema.getElementType());
                }
                return false;
            }
            case MAP: {
                if (writerSchema.getType().equals((Object)Schema.Type.MAP)) {
                    return HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(writerSchema.getValueType(), readerSchema.getValueType());
                }
                return false;
            }
            case UNION: {
                return HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(HoodieAvroUtils.getActualSchemaFromUnion(writerSchema, null), HoodieAvroUtils.getActualSchemaFromUnion(readerSchema, null));
            }
            case ENUM: {
                return HoodieAvroUtils.needsRewriteToString(writerSchema, true);
            }
            case BYTES: 
            case STRING: {
                return HoodieAvroUtils.needsRewriteToString(writerSchema, false);
            }
        }
        return false;
    }

    private static boolean needsRewriteToString(Schema schema, boolean isEnum) {
        switch (schema.getType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: {
                return true;
            }
            case ENUM: {
                return !isEnum;
            }
        }
        return false;
    }

    public static Date toJavaDate(int days) {
        LocalDate date = LocalDate.ofEpochDay(days);
        ZoneId defaultZoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = date.atStartOfDay(defaultZoneId);
        return new Date(zonedDateTime.toInstant().toEpochMilli());
    }

    public static int fromJavaDate(Date date) {
        long millisUtc = date.getTime();
        long millisLocal = millisUtc + (long)TimeZone.getDefault().getOffset(millisUtc);
        int julianDays = Math.toIntExact(Math.floorDiv(millisLocal, 86400000L));
        return julianDays;
    }

    private static Schema getActualSchemaFromUnion(Schema schema, Object data) {
        Schema actualSchema;
        if (schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            actualSchema = (Schema)schema.getTypes().get(1);
        } else if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
            actualSchema = (Schema)schema.getTypes().get(0);
        } else if (schema.getTypes().size() == 1) {
            actualSchema = (Schema)schema.getTypes().get(0);
        } else {
            if (data == null) {
                return schema;
            }
            int i = GenericData.get().resolveUnion(schema, data);
            actualSchema = (Schema)schema.getTypes().get(i);
        }
        return actualSchema;
    }

    public static HoodieRecord createHoodieRecordFromAvro(IndexedRecord data, String payloadClass, String preCombineField, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFields, Option<Schema> schemaWithoutMetaFields) {
        if (populateMetaFields.booleanValue()) {
            return SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)data, payloadClass, preCombineField, withOperation);
        }
        if (simpleKeyGenFieldsOpt.isPresent()) {
            return SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)data, payloadClass, preCombineField, (Pair)simpleKeyGenFieldsOpt.get(), withOperation, partitionNameOp, schemaWithoutMetaFields);
        }
        return SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)data, payloadClass, preCombineField, withOperation, partitionNameOp, schemaWithoutMetaFields);
    }

    public static Iterator<GenericRecord> rewriteRecordWithNewSchema(final Iterator<GenericRecord> oldRecords, final Schema newSchema, final Map<String, String> renameCols, final boolean validate) {
        if (oldRecords == null || newSchema == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<GenericRecord>(){

            @Override
            public boolean hasNext() {
                return oldRecords.hasNext();
            }

            @Override
            public GenericRecord next() {
                return HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecords.next(), newSchema, (Map<String, String>)renameCols, validate);
            }
        };
    }

    public static Iterator<GenericRecord> rewriteRecordWithNewSchema(Iterator<GenericRecord> oldRecords, Schema newSchema, Map<String, String> renameCols) {
        return HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecords, newSchema, (Map<String, String>)Collections.EMPTY_MAP, false);
    }

    public static GenericRecord rewriteRecordDeep(GenericRecord oldRecord, Schema newSchema) {
        return HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecord, newSchema, (Map<String, String>)Collections.EMPTY_MAP);
    }

    public static GenericRecord rewriteRecordDeep(GenericRecord oldRecord, Schema newSchema, boolean validate) {
        return HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecord, newSchema, (Map<String, String>)Collections.EMPTY_MAP, validate);
    }

    public static boolean gteqAvro1_9() {
        return StringUtils.compareVersions((String)AVRO_VERSION, (String)"1.9") >= 0;
    }

    public static boolean gteqAvro1_10() {
        return StringUtils.compareVersions((String)AVRO_VERSION, (String)"1.10") >= 0;
    }

    public static Object wrapValueIntoAvro(Comparable<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            LocalDate localDate = ((Date)value).toLocalDate();
            return DateWrapper.newBuilder(DATE_WRAPPER_BUILDER_STUB.get()).setValue((int)localDate.toEpochDay()).build();
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return LocalDateWrapper.newBuilder(LOCAL_DATE_WRAPPER_BUILDER_STUB.get()).setValue((int)localDate.toEpochDay()).build();
        }
        if (value instanceof BigDecimal) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            BigDecimal upcastDecimal = HoodieTableMetadataUtil.tryUpcastDecimal((BigDecimal)value, (LogicalTypes.Decimal)valueSchema.getLogicalType());
            return DecimalWrapper.newBuilder(DECIMAL_WRAPPER_BUILDER_STUB.get()).setValue(AVRO_DECIMAL_CONVERSION.toBytes(upcastDecimal, valueSchema, valueSchema.getLogicalType())).build();
        }
        if (value instanceof Timestamp) {
            Instant instant = ((Timestamp)value).toInstant();
            return TimestampMicrosWrapper.newBuilder(TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB.get()).setValue(DateTimeUtils.instantToMicros(instant)).build();
        }
        if (value instanceof Boolean) {
            return BooleanWrapper.newBuilder(BOOLEAN_WRAPPER_BUILDER_STUB.get()).setValue((Boolean)value).build();
        }
        if (value instanceof Integer) {
            return IntWrapper.newBuilder(INT_WRAPPER_BUILDER_STUB.get()).setValue((Integer)value).build();
        }
        if (value instanceof Long) {
            return LongWrapper.newBuilder(LONG_WRAPPER_BUILDER_STUB.get()).setValue((Long)value).build();
        }
        if (value instanceof Float) {
            return FloatWrapper.newBuilder(FLOAT_WRAPPER_BUILDER_STUB.get()).setValue(((Float)value).floatValue()).build();
        }
        if (value instanceof Double) {
            return DoubleWrapper.newBuilder(DOUBLE_WRAPPER_BUILDER_STUB.get()).setValue((Double)value).build();
        }
        if (value instanceof ByteBuffer) {
            return BytesWrapper.newBuilder(BYTES_WRAPPER_BUILDER_STUB.get()).setValue((ByteBuffer)value).build();
        }
        if (value instanceof String || value instanceof Utf8) {
            return StringWrapper.newBuilder(STRING_WRAPPER_BUILDER_STUB.get()).setValue(value.toString()).build();
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", value.getClass()));
    }

    public static Comparable<?> unwrapAvroValueWrapper(Object avroValueWrapper) {
        if (avroValueWrapper == null) {
            return null;
        }
        Pair<Boolean, String> isValueWrapperObfuscated = HoodieAvroUtils.getIsValueWrapperObfuscated(avroValueWrapper);
        if (isValueWrapperObfuscated.getKey().booleanValue()) {
            return HoodieAvroUtils.unwrapAvroValueWrapper(avroValueWrapper, isValueWrapperObfuscated.getValue());
        }
        if (avroValueWrapper instanceof DateWrapper) {
            return Date.valueOf(LocalDate.ofEpochDay(((DateWrapper)((Object)avroValueWrapper)).getValue()));
        }
        if (avroValueWrapper instanceof LocalDateWrapper) {
            return LocalDate.ofEpochDay(((LocalDateWrapper)((Object)avroValueWrapper)).getValue());
        }
        if (avroValueWrapper instanceof DecimalWrapper) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            return AVRO_DECIMAL_CONVERSION.fromBytes(((DecimalWrapper)((Object)avroValueWrapper)).getValue(), valueSchema, valueSchema.getLogicalType());
        }
        if (avroValueWrapper instanceof TimestampMicrosWrapper) {
            return DateTimeUtils.microsToInstant(((TimestampMicrosWrapper)((Object)avroValueWrapper)).getValue());
        }
        if (avroValueWrapper instanceof BooleanWrapper) {
            return ((BooleanWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof IntWrapper) {
            return ((IntWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof LongWrapper) {
            return ((LongWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof FloatWrapper) {
            return Float.valueOf(((FloatWrapper)((Object)avroValueWrapper)).getValue());
        }
        if (avroValueWrapper instanceof DoubleWrapper) {
            return ((DoubleWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof BytesWrapper) {
            return ((BytesWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof StringWrapper) {
            return ((StringWrapper)((Object)avroValueWrapper)).getValue();
        }
        if (avroValueWrapper instanceof GenericRecord) {
            GenericRecord genRec = (GenericRecord)avroValueWrapper;
            return (Comparable)genRec.get("value");
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", avroValueWrapper.getClass()));
    }

    public static Comparable<?> unwrapAvroValueWrapper(Object avroValueWrapper, String wrapperClassName) {
        if (avroValueWrapper == null) {
            return null;
        }
        if (DateWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return Date.valueOf(LocalDate.ofEpochDay(((Integer)((GenericRecord)avroValueWrapper).get(0)).intValue()));
        }
        if (LocalDateWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return LocalDate.ofEpochDay(((Integer)((GenericRecord)avroValueWrapper).get(0)).intValue());
        }
        if (TimestampMicrosWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            Instant instant = DateTimeUtils.microsToInstant((Long)((GenericRecord)avroValueWrapper).get(0));
            return Timestamp.from(instant);
        }
        if (DecimalWrapper.class.getSimpleName().equals(wrapperClassName)) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return AVRO_DECIMAL_CONVERSION.fromBytes((ByteBuffer)((GenericRecord)avroValueWrapper).get(0), valueSchema, valueSchema.getLogicalType());
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", avroValueWrapper.getClass()));
    }

    private static Pair<Boolean, String> getIsValueWrapperObfuscated(Object statsValue) {
        if (statsValue != null) {
            boolean toReturn;
            String statsValueSchemaClassName = ((GenericRecord)statsValue).getSchema().getName();
            boolean bl = toReturn = statsValueSchemaClassName.equals(DateWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(LocalDateWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(TimestampMicrosWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(DecimalWrapper.class.getSimpleName());
            if (toReturn) {
                return Pair.of(true, ((GenericRecord)statsValue).getSchema().getName());
            }
        }
        return Pair.of(false, null);
    }

    @VisibleForTesting
    public static Pair<String, Schema.Field> getSchemaForField(Schema schema, String fieldName) {
        return HoodieAvroUtils.getSchemaForField(schema, fieldName, "");
    }

    @VisibleForTesting
    public static Pair<String, Schema.Field> getSchemaForField(Schema schema, String fieldName, String prefix) {
        if (!fieldName.contains(".")) {
            return Pair.of(prefix + fieldName, schema.getField(fieldName));
        }
        int rootFieldIndex = fieldName.indexOf(".");
        Schema.Field rootField = schema.getField(fieldName.substring(0, rootFieldIndex));
        if (rootField == null) {
            throw new HoodieException("Failed to find " + fieldName + " in the table schema ");
        }
        return HoodieAvroUtils.getSchemaForField(rootField.schema(), fieldName.substring(rootFieldIndex + 1), prefix + fieldName.substring(0, rootFieldIndex + 1));
    }
}

