/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricUtils;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayReporter;

public class PushGatewayMetricsReporter
extends MetricsReporter {
    private final PushGatewayReporter pushGatewayReporter;
    private final int periodSeconds;
    private final boolean deleteShutdown;
    private final String configuredJobName;
    private final Map<String, String> configuredLabels;
    private final boolean randomSuffix;

    public PushGatewayMetricsReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        String serverHost = metricsConfig.getPushGatewayHost();
        int serverPort = metricsConfig.getPushGatewayPort();
        this.periodSeconds = metricsConfig.getPushGatewayReportPeriodSeconds();
        this.deleteShutdown = metricsConfig.getPushGatewayDeleteOnShutdown();
        this.configuredJobName = metricsConfig.getPushGatewayJobName();
        this.configuredLabels = Collections.unmodifiableMap(PushGatewayMetricsReporter.parseLabels(metricsConfig.getPushGatewayLabels()));
        this.randomSuffix = metricsConfig.getPushGatewayRandomJobNameSuffix();
        this.pushGatewayReporter = new PushGatewayReporter(registry, MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS, this.getJobName(), this.configuredLabels, serverHost, serverPort, this.deleteShutdown);
    }

    @Override
    public void start() {
        this.pushGatewayReporter.start(this.periodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.pushGatewayReporter.report(null, null, null, null, null);
    }

    @Override
    public void stop() {
        this.pushGatewayReporter.stop();
    }

    public Map<String, String> getLabels() {
        return this.configuredLabels;
    }

    private String getJobName() {
        if (this.randomSuffix) {
            Random random = new Random();
            return this.configuredJobName + random.nextLong();
        }
        return this.configuredJobName;
    }

    private static Map<String, String> parseLabels(String labels) {
        if (StringUtils.isNullOrEmpty((String)labels)) {
            return Collections.emptyMap();
        }
        return MetricUtils.getLabelsAsMap(labels);
    }
}

