/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.common.util.ValidationUtils;

public class SecondaryIndexKeyUtils {
    public static String getRecordKeyFromSecondaryIndexKey(String key) {
        ValidationUtils.checkState((boolean)key.contains("$"), (String)("Invalid key format for secondary index payload: " + key));
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(key);
        return SecondaryIndexKeyUtils.unescapeSpecialChars(key.substring(delimiterIndex + 1));
    }

    public static String getSecondaryKeyFromSecondaryIndexKey(String key) {
        ValidationUtils.checkState((boolean)key.contains("$"), (String)("Invalid key format for secondary index payload: " + key));
        int delimiterIndex = SecondaryIndexKeyUtils.getSecondaryIndexKeySeparatorPosition(key);
        return SecondaryIndexKeyUtils.unescapeSpecialChars(key.substring(0, delimiterIndex));
    }

    static String constructSecondaryIndexKey(String secondaryKey, String recordKey) {
        return SecondaryIndexKeyUtils.escapeSpecialChars(secondaryKey) + "$" + SecondaryIndexKeyUtils.escapeSpecialChars(recordKey);
    }

    private static String escapeSpecialChars(String str) {
        StringBuilder escaped = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == '\\' || c == '$') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private static int getSecondaryIndexKeySeparatorPosition(String key) {
        int delimiterIndex = -1;
        boolean isEscape = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\\' && !isEscape) {
                isEscape = true;
                continue;
            }
            if (c == '$' && !isEscape) {
                delimiterIndex = i;
                break;
            }
            isEscape = false;
        }
        ValidationUtils.checkState((delimiterIndex != -1 ? 1 : 0) != 0, (String)"Invalid encoded key format");
        return delimiterIndex;
    }

    private static String unescapeSpecialChars(String str) {
        StringBuilder unescaped = new StringBuilder();
        boolean isEscape = false;
        for (char c : str.toCharArray()) {
            if (isEscape) {
                unescaped.append(c);
                isEscape = false;
                continue;
            }
            if (c == '\\') {
                isEscape = true;
                continue;
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }
}

