/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metrics.HoodieGauge;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetadataMetrics
implements Serializable {
    public static final String LOOKUP_PARTITIONS_STR = "lookup_partitions";
    public static final String LOOKUP_FILES_STR = "lookup_files";
    public static final String LOOKUP_BLOOM_FILTERS_METADATA_STR = "lookup_meta_index_bloom_filters";
    public static final String LOOKUP_COLUMN_STATS_METADATA_STR = "lookup_meta_index_column_ranges";
    public static final String LOOKUP_BLOOM_FILTERS_FILE_COUNT_STR = "lookup_meta_index_bloom_filters_file_count";
    public static final String LOOKUP_COLUMN_STATS_FILE_COUNT_STR = "lookup_meta_index_column_ranges_file_count";
    public static final String LOOKUP_RECORD_INDEX_TIME_STR = "lookup_record_index_time";
    public static final String LOOKUP_RECORD_INDEX_KEYS_COUNT_STR = "lookup_record_index_key_count";
    public static final String LOOKUP_RECORD_INDEX_KEYS_HITS_COUNT_STR = "lookup_record_index_key_hit_count";
    public static final String SCAN_STR = "scan";
    public static final String BASEFILE_READ_STR = "basefile_read";
    public static final String INITIALIZE_STR = "initialize";
    public static final String REBOOTSTRAP_STR = "rebootstrap_count";
    public static final String BOOTSTRAP_ERR_STR = "bootstrap_error";
    public static final String STAT_TOTAL_BASE_FILE_SIZE = "totalBaseFileSizeInBytes";
    public static final String STAT_TOTAL_LOG_FILE_SIZE = "totalLogFileSizeInBytes";
    public static final String STAT_COUNT_BASE_FILES = "baseFileCount";
    public static final String STAT_COUNT_LOG_FILES = "logFileCount";
    public static final String STAT_COUNT_PARTITION = "partitionCount";
    public static final String STAT_LAST_COMPACTION_TIMESTAMP = "lastCompactionTimestamp";
    public static final String SKIP_TABLE_SERVICES = "skip_table_services";
    public static final String TABLE_SERVICE_EXECUTION_STATUS = "table_service_execution_status";
    public static final String TABLE_SERVICE_EXECUTION_DURATION = "table_service_execution_duration";
    public static final String ASYNC_INDEXER_CATCHUP_TIME = "async_indexer_catchup_time";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetadataMetrics.class);
    private final transient MetricRegistry metricsRegistry;
    private final transient Metrics metrics;

    public HoodieMetadataMetrics(HoodieMetricsConfig metricsConfig, HoodieStorage storage) {
        this.metrics = Metrics.getInstance(metricsConfig, storage);
        this.metricsRegistry = this.metrics.getRegistry();
    }

    public Map<String, String> getStats(boolean detailed, HoodieTableMetaClient metaClient, HoodieTableMetadata metadata, Set<String> metadataPartitions) {
        try {
            HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline());
            return this.getStats(fsView, detailed, metadata, metadataPartitions);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to get metadata stats.", ioe);
        }
    }

    private Map<String, String> getStats(HoodieTableFileSystemView fsView, boolean detailed, HoodieTableMetadata tableMetadata, Set<String> metadataPartitions) throws IOException {
        HashMap<String, String> stats = new HashMap<String, String>();
        for (String metadataPartition : metadataPartitions) {
            List latestSlices = fsView.getLatestFileSlices(metadataPartition).collect(Collectors.toList());
            long totalBaseFileSizeInBytes = 0L;
            long totalLogFileSizeInBytes = 0L;
            int baseFileCount = 0;
            int logFileCount = 0;
            for (FileSlice slice : latestSlices) {
                if (slice.getBaseFile().isPresent()) {
                    totalBaseFileSizeInBytes += ((HoodieBaseFile)slice.getBaseFile().get()).getPathInfo().getLength();
                    ++baseFileCount;
                }
                Iterator it = slice.getLogFiles().iterator();
                while (it.hasNext()) {
                    totalLogFileSizeInBytes += ((HoodieLogFile)it.next()).getFileSize();
                    ++logFileCount;
                }
            }
            stats.put(metadataPartition + "." + STAT_TOTAL_BASE_FILE_SIZE, String.valueOf(totalBaseFileSizeInBytes));
            stats.put(metadataPartition + "." + STAT_TOTAL_LOG_FILE_SIZE, String.valueOf(totalLogFileSizeInBytes));
            stats.put(metadataPartition + "." + STAT_COUNT_BASE_FILES, String.valueOf(baseFileCount));
            stats.put(metadataPartition + "." + STAT_COUNT_LOG_FILES, String.valueOf(logFileCount));
        }
        if (detailed) {
            stats.put(STAT_COUNT_PARTITION, String.valueOf(tableMetadata.getAllPartitionPaths().size()));
        }
        return stats;
    }

    public void updateMetrics(String action, long durationInMs) {
        if (this.metricsRegistry == null) {
            return;
        }
        String countKey = action + ".count";
        String durationKey = action + ".totalDuration";
        this.incrementMetric(countKey, 1L);
        this.setMetric(durationKey, durationInMs);
    }

    public void updateSizeMetrics(HoodieTableMetaClient metaClient, HoodieBackedTableMetadata metadata, Set<String> metadataPartitions) {
        Map<String, String> stats = this.getStats(false, metaClient, (HoodieTableMetadata)metadata, metadataPartitions);
        for (Map.Entry<String, String> e : stats.entrySet()) {
            this.setMetric(e.getKey(), Long.parseLong(e.getValue()));
        }
    }

    protected void incrementMetric(String action, long value) {
        LOG.debug(String.format("Updating metadata metrics (%s=%d) in %s", action, value, this.metricsRegistry));
        Option<HoodieGauge<Long>> gaugeOpt = this.metrics.registerGauge(action);
        gaugeOpt.ifPresent(gauge -> gauge.setValue((Long)gauge.getValue() + value));
    }

    protected void setMetric(String action, long value) {
        this.metrics.registerGauge(action, value);
    }

    public MetricRegistry registry() {
        return this.metricsRegistry;
    }
}

