/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.secondary;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hudi.exception.HoodieSecondaryIndexException;
import org.apache.hudi.index.secondary.SecondaryIndexType;

public class HoodieSecondaryIndex {
    private String indexName;
    private SecondaryIndexType indexType;
    private LinkedHashMap<String, Map<String, String>> columns;
    private Map<String, String> options;

    public HoodieSecondaryIndex() {
    }

    public HoodieSecondaryIndex(String indexName, SecondaryIndexType indexType, LinkedHashMap<String, Map<String, String>> columns, Map<String, String> options) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.columns = columns;
        this.options = options;
        this.validate();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public SecondaryIndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, Map<String, String>> getColumns() {
        return this.columns;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    private void validate() {
        switch (this.indexType) {
            case LUCENE: {
                if (this.columns.size() == 1) break;
                throw new HoodieSecondaryIndexException("Lucene index only support single column");
            }
            default: {
                return;
            }
        }
    }

    public String toString() {
        return "HoodieIndex{indexName='" + this.indexName + '\'' + ", indexType=" + (Object)((Object)this.indexType) + ", columns=" + this.columns + ", options=" + this.options + '}';
    }

    public static class HoodieIndexCompactor
    implements Comparator<HoodieSecondaryIndex> {
        @Override
        public int compare(HoodieSecondaryIndex o1, HoodieSecondaryIndex o2) {
            return o1.indexName.compareTo(o2.indexName);
        }
    }

    public static class Builder {
        private String indexName;
        private SecondaryIndexType indexType;
        private LinkedHashMap<String, Map<String, String>> columns;
        private Map<String, String> options;

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setIndexType(String indexType) {
            this.indexType = SecondaryIndexType.of(indexType);
            return this;
        }

        public Builder setColumns(LinkedHashMap<String, Map<String, String>> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setOptions(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public HoodieSecondaryIndex build() {
            return new HoodieSecondaryIndex(this.indexName, this.indexType, this.columns, this.options);
        }
    }
}

