/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.storage.StoragePathInfo;

public class InstantGeneratorV2
implements InstantGenerator {
    private static final Pattern NAME_FORMAT = Pattern.compile("^(\\d+(_\\d+)?)(\\.\\w+)(\\.\\D+)?$");
    private static final String DELIMITER = ".";

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp) {
        return new HoodieInstant(state, action, timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime) {
        return new HoodieInstant(state, action, timestamp, completionTime, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime, boolean isLegacy) {
        return new HoodieInstant(state, action, timestamp, completionTime, isLegacy, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant createNewInstant(StoragePathInfo pathInfo) {
        String fileName = pathInfo.getPath().getName();
        String timestamp = null;
        String completionTime = null;
        String action = null;
        HoodieInstant.State state = HoodieInstant.State.NIL;
        boolean isLegacy = false;
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            String[] timestamps = matcher.group(1).split("_");
            timestamp = timestamps[0];
            if (matcher.group(3).equals(".inflight")) {
                action = "commit";
                state = HoodieInstant.State.INFLIGHT;
            } else {
                action = matcher.group(3).replaceFirst(DELIMITER, "");
                state = matcher.groupCount() == 4 && matcher.group(4) != null ? HoodieInstant.State.valueOf(matcher.group(4).replaceFirst(DELIMITER, "").toUpperCase()) : HoodieInstant.State.COMPLETED;
            }
            if (state == HoodieInstant.State.COMPLETED) {
                if (timestamps.length > 1) {
                    completionTime = timestamps[1];
                } else {
                    completionTime = HoodieInstantTimeGenerator.formatDate(new Date(pathInfo.getModificationTime()));
                    isLegacy = true;
                }
            } else {
                completionTime = null;
            }
        } else {
            throw new IllegalArgumentException("Failed to construct HoodieInstant: " + String.format("The provided file name %s does not conform to the required format", fileName));
        }
        return new HoodieInstant(state, action, timestamp, completionTime, isLegacy, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    public String extractTimestamp(String fileName) throws IllegalArgumentException {
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            String timestamp = matcher.group(1);
            return timestamp.contains("_") ? timestamp.split("_")[0] : timestamp;
        }
        throw new IllegalArgumentException("Failed to retrieve timestamp from name: " + String.format("The provided file name %s does not conform to the required format", fileName));
    }

    public String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return fileName.substring(matcher.group(1).length());
        }
        return "";
    }

    @Override
    public HoodieInstant getRequestedInstant(HoodieInstant instant) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.requestedTime(), InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCleanRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCleanInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getLogCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "logcompaction", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getLogCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "logcompaction", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getReplaceCommitRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getReplaceCommitInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getClusteringCommitRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "clustering", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getClusteringCommitInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "clustering", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getRollbackRequestedInstant(HoodieInstant instant) {
        return instant.isRequested() ? instant : this.getRequestedInstant(instant);
    }

    @Override
    public HoodieInstant getRestoreRequestedInstant(HoodieInstant instant) {
        return instant.isRequested() ? instant : this.getRequestedInstant(instant);
    }

    @Override
    public HoodieInstant getIndexRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, "indexing", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }

    @Override
    public HoodieInstant getIndexInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "indexing", timestamp, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }
}

