/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineLoaderV1;
import org.apache.hudi.common.table.timeline.versioning.v1.BaseTimelineV1;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivedTimelineV1
extends BaseTimelineV1
implements HoodieArchivedTimeline {
    private static final String HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX = "commits";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final String ACTION_STATE = "actionState";
    private static final String STATE_TRANSITION_TIME = "stateTransitionTime";
    private HoodieTableMetaClient metaClient;
    private final Map<String, byte[]> readCommits = new HashMap<String, byte[]>();
    private final ArchivedTimelineLoader timelineLoader = new ArchivedTimelineLoaderV1();
    private static final Logger LOG = LoggerFactory.getLogger(HoodieArchivedTimeline.class);

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(false));
        this.details = this::getInstantDetails;
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, String startTs) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(new HoodieArchivedTimeline.StartTsFilter(startTs), true, record -> HoodieInstant.State.COMPLETED.toString().equals(record.get(ACTION_STATE).toString())));
        this.details = this::getInstantDetails;
    }

    public ArchivedTimelineV1() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable((Object)this.readCommits.get(instant.requestedTime()));
    }

    public static StoragePath getArchiveLogPath(StoragePath archiveFolder) {
        return new StoragePath(archiveFolder, HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX);
    }

    @Override
    public void loadInstantDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(startTs, endTs);
    }

    @Override
    public void loadCompletedInstantDetailsInMemory() {
        this.loadInstants(null, true, record -> {
            Object action = record.get(ACTION_STATE);
            return action == null || HoodieInstant.State.COMPLETED.toString().equals(action.toString());
        });
    }

    @Override
    public void loadCompactionDetailsInMemory(String compactionInstantTime) {
        this.loadCompactionDetailsInMemory(compactionInstantTime, compactionInstantTime);
    }

    @Override
    public void loadCompactionDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(new HoodieArchivedTimeline.TimeRangeFilter(startTs, endTs), true, record -> {
            Object action = record.get(ACTION_STATE);
            return record.get(ACTION_TYPE_KEY).toString().equals("compaction") && (action == null || HoodieInstant.State.INFLIGHT.toString().equals(action.toString()));
        });
    }

    @Override
    public void clearInstantDetailsFromMemory(String instantTime) {
        this.readCommits.remove(instantTime);
    }

    @Override
    public void clearInstantDetailsFromMemory(String startTs, String endTs) {
        this.findInstantsInRange(startTs, endTs).getInstants().forEach(instant -> this.readCommits.remove(instant.requestedTime()));
    }

    private List<HoodieInstant> loadInstants(boolean loadInstantDetails) {
        return this.loadInstants(null, loadInstantDetails);
    }

    private List<HoodieInstant> loadInstants(String startTs, String endTs) {
        return this.loadInstants(new HoodieArchivedTimeline.TimeRangeFilter(startTs, endTs), true);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, boolean loadInstantDetails) {
        return this.loadInstants(filter, loadInstantDetails, genericRecord -> true);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, boolean loadInstantDetails, Function<GenericRecord, Boolean> commitsFilter) {
        InstantsLoader loader = new InstantsLoader(loadInstantDetails);
        this.timelineLoader.loadInstants(this.metaClient, filter, HoodieArchivedTimeline.LoadMode.PLAN, commitsFilter, loader);
        ArrayList<HoodieInstant> result = new ArrayList<HoodieInstant>(loader.getInstantsInRangeCollected().values());
        Collections.sort(result);
        return result;
    }

    private HoodieInstant readCommit(String instantTime, GenericRecord record, boolean loadDetails) {
        String action = record.get(ACTION_TYPE_KEY).toString();
        String stateTransitionTime = (String)record.get(STATE_TRANSITION_TIME);
        if (loadDetails) {
            ArchivedTimelineV1.getMetadataKey(action).map(key -> {
                Object actionData = record.get(key);
                if (actionData != null) {
                    if (action.equals("compaction")) {
                        this.readCommits.put(instantTime, HoodieAvroUtils.indexedRecordToBytes((IndexedRecord)actionData));
                    } else {
                        this.readCommits.put(instantTime, actionData.toString().getBytes(StandardCharsets.UTF_8));
                    }
                }
                return null;
            });
        }
        return this.instantGenerator.createNewInstant(HoodieInstant.State.valueOf(record.get(ACTION_STATE).toString()), action, instantTime, stateTransitionTime);
    }

    @Nonnull
    private static Option<String> getMetadataKey(String action) {
        switch (action) {
            case "clean": {
                return Option.of((Object)"hoodieCleanMetadata");
            }
            case "commit": 
            case "deltacommit": {
                return Option.of((Object)"hoodieCommitMetadata");
            }
            case "rollback": {
                return Option.of((Object)"hoodieRollbackMetadata");
            }
            case "savepoint": {
                return Option.of((Object)"hoodieSavePointMetadata");
            }
            case "compaction": 
            case "logcompaction": {
                return Option.of((Object)"hoodieCompactionPlan");
            }
            case "replacecommit": {
                return Option.of((Object)"hoodieReplaceCommitMetadata");
            }
            case "indexing": {
                return Option.of((Object)"hoodieIndexCommitMetadata");
            }
        }
        LOG.error(String.format("Unknown action in metadata (%s)", action));
        return Option.empty();
    }

    @Override
    public HoodieArchivedTimeline reload() {
        return new ArchivedTimelineV1(this.metaClient);
    }

    @Override
    public HoodieArchivedTimeline reload(String startTs) {
        return new ArchivedTimelineV1(this.metaClient, startTs);
    }

    public class InstantsLoader
    implements BiConsumer<String, GenericRecord> {
        private final Map<String, HoodieInstant> instantsInRange = new ConcurrentHashMap<String, HoodieInstant>();
        private final boolean loadInstantDetails;

        private InstantsLoader(boolean loadInstantDetails) {
            this.loadInstantDetails = loadInstantDetails;
        }

        @Override
        public void accept(String instantTime, GenericRecord record) {
            HoodieInstant instant = ArchivedTimelineV1.this.readCommit(instantTime, record, this.loadInstantDetails);
            this.instantsInRange.putIfAbsent(instant.requestedTime(), instant);
        }

        public Map<String, HoodieInstant> getInstantsInRangeCollected() {
            return this.instantsInRange;
        }
    }
}

