/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.common.util.ValidationUtils;

public class TimelineLayoutVersion
implements Serializable,
Comparable<TimelineLayoutVersion> {
    public static final Integer VERSION_0 = 0;
    public static final Integer VERSION_1 = 1;
    public static final Integer VERSION_2;
    public static final Integer CURR_VERSION;
    public static final TimelineLayoutVersion LAYOUT_VERSION_0;
    public static final TimelineLayoutVersion LAYOUT_VERSION_1;
    public static final TimelineLayoutVersion LAYOUT_VERSION_2;
    public static final TimelineLayoutVersion CURR_LAYOUT_VERSION;
    private final Integer version;

    public TimelineLayoutVersion(Integer version) {
        ValidationUtils.checkArgument((version <= CURR_VERSION ? 1 : 0) != 0);
        ValidationUtils.checkArgument((version >= VERSION_0 ? 1 : 0) != 0);
        this.version = version;
    }

    public boolean isNullVersion() {
        return Objects.equals(this.version, VERSION_0);
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineLayoutVersion that = (TimelineLayoutVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    @Override
    public int compareTo(TimelineLayoutVersion o) {
        return Integer.compare(this.version, o.version);
    }

    public String toString() {
        return String.valueOf(this.version);
    }

    static {
        CURR_VERSION = VERSION_2 = Integer.valueOf(2);
        LAYOUT_VERSION_0 = new TimelineLayoutVersion(VERSION_0);
        LAYOUT_VERSION_1 = new TimelineLayoutVersion(VERSION_1);
        CURR_LAYOUT_VERSION = LAYOUT_VERSION_2 = new TimelineLayoutVersion(VERSION_2);
    }
}

