/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import java.util.Objects;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;

public class CheckpointUtils {
    public static Checkpoint getCheckpoint(HoodieCommitMetadata commitMetadata) {
        if (!StringUtils.isNullOrEmpty((String)commitMetadata.getMetadata("streamer.checkpoint.key.v2")) || !StringUtils.isNullOrEmpty((String)commitMetadata.getMetadata("streamer.checkpoint.reset.key.v2"))) {
            return new StreamerCheckpointV2(commitMetadata);
        }
        if (!StringUtils.isNullOrEmpty((String)commitMetadata.getMetadata("deltastreamer.checkpoint.key")) || !StringUtils.isNullOrEmpty((String)commitMetadata.getMetadata("deltastreamer.checkpoint.reset_key"))) {
            return new StreamerCheckpointV1(commitMetadata);
        }
        throw new HoodieException("Checkpoint is not found in the commit metadata: " + commitMetadata.getExtraMetadata());
    }

    public static boolean targetCheckpointV2(int writeTableVersion) {
        return writeTableVersion >= HoodieTableVersion.EIGHT.versionCode();
    }

    public static StreamerCheckpointV2 convertToCheckpointV2ForCommitTime(Checkpoint checkpoint, HoodieTableMetaClient metaClient) {
        if (checkpoint.checkpointKey.equals("00000000000000")) {
            return new StreamerCheckpointV2("00000000000000");
        }
        if (checkpoint instanceof StreamerCheckpointV2) {
            return (StreamerCheckpointV2)checkpoint;
        }
        if (checkpoint instanceof StreamerCheckpointV1) {
            String instantTime = checkpoint.getCheckpointKey();
            Option completionTime = metaClient.getActiveTimeline().getInstantsAsStream().filter(s -> instantTime.equals(s.requestedTime())).map(HoodieInstant::getCompletionTime).filter(Objects::nonNull).findFirst().map(Option::of).orElse(Option.empty());
            if (completionTime.isEmpty()) {
                throw new UnsupportedOperationException("Unable to find completion time for " + instantTime);
            }
            return new StreamerCheckpointV2((String)completionTime.get());
        }
        throw new UnsupportedOperationException("Unsupported checkpoint type: " + checkpoint.getClass());
    }

    public static StreamerCheckpointV1 convertToCheckpointV1ForCommitTime(Checkpoint checkpoint, HoodieTableMetaClient metaClient) {
        if (checkpoint.checkpointKey.equals("00000000000000")) {
            return new StreamerCheckpointV1("00000000000000");
        }
        if (checkpoint instanceof StreamerCheckpointV1) {
            return (StreamerCheckpointV1)checkpoint;
        }
        if (checkpoint instanceof StreamerCheckpointV2) {
            String completionTime = checkpoint.getCheckpointKey();
            Option instantTime = metaClient.getActiveTimeline().getInstantsAsStream().filter(s -> completionTime.equals(s.getCompletionTime())).map(HoodieInstant::requestedTime).filter(Objects::nonNull).findFirst().map(Option::of).orElse(Option.empty());
            if (instantTime.isEmpty()) {
                throw new UnsupportedOperationException("Unable to find requested time for " + completionTime);
            }
            return new StreamerCheckpointV1((String)instantTime.get());
        }
        throw new UnsupportedOperationException("Unsupported checkpoint type: " + checkpoint.getClass());
    }
}

