/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class OrderedProperties
extends Properties {
    private final HashSet<Object> keys = new LinkedHashSet<Object>();

    public OrderedProperties() {
        super((Properties)null);
    }

    public OrderedProperties(Properties defaults) {
        if (Objects.nonNull(defaults)) {
            for (String key : defaults.stringPropertyNames()) {
                this.put(key, defaults.getProperty(key));
            }
        }
    }

    public Enumeration propertyNames() {
        return Collections.enumeration(this.keys);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.keys);
    }

    @Override
    public Set<String> stringPropertyNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object key : this.keys) {
            if (!(key instanceof String)) continue;
            set.add((String)key);
        }
        return set;
    }

    public synchronized void putAll(Properties t) {
        for (Map.Entry<Object, Object> e : t.entrySet()) {
            if (!this.containsKey(String.valueOf(e.getKey()))) {
                this.keys.add(e.getKey());
            }
            super.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.keys.remove(key);
        this.keys.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        if (!this.containsKey(String.valueOf(key))) {
            this.keys.add(key);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.keys.remove(key);
        return super.remove(key);
    }
}

