/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.avro.model.HoodieRecordIndexInfo;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetadataPayload
implements HoodieRecordPayload<HoodieMetadataPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetadataPayload.class);
    protected static final int METADATA_TYPE_PARTITION_LIST = 1;
    protected static final int METADATA_TYPE_FILE_LIST = 2;
    protected static final int METADATA_TYPE_COLUMN_STATS = 3;
    protected static final int METADATA_TYPE_BLOOM_FILTER = 4;
    private static final int METADATA_TYPE_RECORD_INDEX = 5;
    public static final String KEY_FIELD_NAME = "key";
    public static final String SCHEMA_FIELD_NAME_TYPE = "type";
    public static final String SCHEMA_FIELD_NAME_METADATA = "filesystemMetadata";
    public static final String SCHEMA_FIELD_ID_COLUMN_STATS = "ColumnStatsMetadata";
    public static final String SCHEMA_FIELD_ID_BLOOM_FILTER = "BloomFilterMetadata";
    public static final String SCHEMA_FIELD_ID_RECORD_INDEX = "recordIndexMetadata";
    private static final String FIELD_IS_DELETED = "isDeleted";
    private static final String BLOOM_FILTER_FIELD_TYPE = "type";
    private static final String BLOOM_FILTER_FIELD_TIMESTAMP = "timestamp";
    private static final String BLOOM_FILTER_FIELD_BLOOM_FILTER = "bloomFilter";
    private static final String BLOOM_FILTER_FIELD_IS_DELETED = "isDeleted";
    public static final String COLUMN_STATS_FIELD_MIN_VALUE = "minValue";
    public static final String COLUMN_STATS_FIELD_MAX_VALUE = "maxValue";
    public static final String COLUMN_STATS_FIELD_NULL_COUNT = "nullCount";
    public static final String COLUMN_STATS_FIELD_VALUE_COUNT = "valueCount";
    public static final String COLUMN_STATS_FIELD_TOTAL_SIZE = "totalSize";
    public static final String COLUMN_STATS_FIELD_FILE_NAME = "fileName";
    public static final String COLUMN_STATS_FIELD_COLUMN_NAME = "columnName";
    public static final String COLUMN_STATS_FIELD_TOTAL_UNCOMPRESSED_SIZE = "totalUncompressedSize";
    public static final String COLUMN_STATS_FIELD_IS_DELETED = "isDeleted";
    public static final String RECORD_INDEX_FIELD_PARTITION = "partitionName";
    public static final String RECORD_INDEX_FIELD_FILEID_HIGH_BITS = "fileIdHighBits";
    public static final String RECORD_INDEX_FIELD_FILEID_LOW_BITS = "fileIdLowBits";
    public static final String RECORD_INDEX_FIELD_FILE_INDEX = "fileIndex";
    public static final String RECORD_INDEX_FIELD_INSTANT_TIME = "instantTime";
    public static final String RECORD_INDEX_FIELD_FILEID = "fileId";
    public static final String RECORD_INDEX_FIELD_FILEID_ENCODING = "fileIdEncoding";
    public static final int RECORD_INDEX_FIELD_FILEID_ENCODING_UUID = 0;
    public static final int RECORD_INDEX_FIELD_FILEID_ENCODING_RAW_STRING = 1;
    public static final int RECORD_INDEX_MISSING_FILEINDEX_FALLBACK = -1;
    private static final Lazy<HoodieMetadataColumnStats.Builder> METADATA_COLUMN_STATS_BUILDER_STUB = Lazy.lazily(HoodieMetadataColumnStats::newBuilder);
    private static final HoodieMetadataFileInfo DELETE_FILE_METADATA = new HoodieMetadataFileInfo(0L, true);
    private String key = null;
    private int type = 0;
    private Map<String, HoodieMetadataFileInfo> filesystemMetadata = null;
    private HoodieMetadataBloomFilter bloomFilterMetadata = null;
    private HoodieMetadataColumnStats columnStatMetadata = null;
    private HoodieRecordIndexInfo recordIndexMetadata;
    private boolean isDeletedRecord = false;

    public HoodieMetadataPayload(@Nullable GenericRecord record, Comparable<?> orderingVal) {
        this((Option<GenericRecord>)Option.ofNullable((Object)record));
    }

    public HoodieMetadataPayload(Option<GenericRecord> recordOpt) {
        if (recordOpt.isPresent()) {
            GenericRecord record = (GenericRecord)recordOpt.get();
            this.key = record.get(KEY_FIELD_NAME).toString();
            this.type = (Integer)record.get("type");
            if (this.type == 2 || this.type == 1) {
                Map metadata = (Map)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_NAME_METADATA);
                if (metadata != null) {
                    this.filesystemMetadata = metadata;
                    this.filesystemMetadata.keySet().forEach(k -> {
                        GenericRecord v = (GenericRecord)this.filesystemMetadata.get(k);
                        this.filesystemMetadata.put((String)k, new HoodieMetadataFileInfo((Long)v.get("size"), (Boolean)v.get("isDeleted")));
                    });
                }
            } else if (this.type == 4) {
                GenericRecord bloomFilterRecord = (GenericRecord)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_ID_BLOOM_FILTER);
                if (bloomFilterRecord == null) {
                    ValidationUtils.checkArgument((record.getSchema().getField(SCHEMA_FIELD_ID_BLOOM_FILTER) == null ? 1 : 0) != 0, (String)String.format("Valid %s record expected for type: %s", SCHEMA_FIELD_ID_BLOOM_FILTER, 4));
                } else {
                    this.bloomFilterMetadata = new HoodieMetadataBloomFilter((String)bloomFilterRecord.get("type"), (String)bloomFilterRecord.get(BLOOM_FILTER_FIELD_TIMESTAMP), (ByteBuffer)bloomFilterRecord.get(BLOOM_FILTER_FIELD_BLOOM_FILTER), (Boolean)bloomFilterRecord.get("isDeleted"));
                }
            } else if (this.type == 3) {
                GenericRecord columnStatsRecord = (GenericRecord)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_ID_COLUMN_STATS);
                if (columnStatsRecord == null) {
                    ValidationUtils.checkArgument((record.getSchema().getField(SCHEMA_FIELD_ID_COLUMN_STATS) == null ? 1 : 0) != 0, (String)String.format("Valid %s record expected for type: %s", SCHEMA_FIELD_ID_COLUMN_STATS, 3));
                } else {
                    this.columnStatMetadata = HoodieMetadataColumnStats.newBuilder(METADATA_COLUMN_STATS_BUILDER_STUB.get()).setFileName((String)columnStatsRecord.get(COLUMN_STATS_FIELD_FILE_NAME)).setColumnName((String)columnStatsRecord.get(COLUMN_STATS_FIELD_COLUMN_NAME)).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(HoodieAvroUtils.unwrapAvroValueWrapper(columnStatsRecord.get(COLUMN_STATS_FIELD_MIN_VALUE)))).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(HoodieAvroUtils.unwrapAvroValueWrapper(columnStatsRecord.get(COLUMN_STATS_FIELD_MAX_VALUE)))).setValueCount((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_VALUE_COUNT)).setNullCount((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_NULL_COUNT)).setTotalSize((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_TOTAL_SIZE)).setTotalUncompressedSize((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_TOTAL_UNCOMPRESSED_SIZE)).setIsDeleted((Boolean)columnStatsRecord.get("isDeleted")).build();
                }
            } else if (this.type == 5) {
                GenericRecord recordIndexRecord = (GenericRecord)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_ID_RECORD_INDEX);
                this.recordIndexMetadata = new HoodieRecordIndexInfo(recordIndexRecord.get(RECORD_INDEX_FIELD_PARTITION).toString(), Long.parseLong(recordIndexRecord.get(RECORD_INDEX_FIELD_FILEID_HIGH_BITS).toString()), Long.parseLong(recordIndexRecord.get(RECORD_INDEX_FIELD_FILEID_LOW_BITS).toString()), Integer.parseInt(recordIndexRecord.get(RECORD_INDEX_FIELD_FILE_INDEX).toString()), recordIndexRecord.get(RECORD_INDEX_FIELD_FILEID).toString(), Long.parseLong(recordIndexRecord.get(RECORD_INDEX_FIELD_INSTANT_TIME).toString()), Integer.parseInt(recordIndexRecord.get(RECORD_INDEX_FIELD_FILEID_ENCODING).toString()));
            }
        } else {
            this.isDeletedRecord = true;
        }
    }

    private HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        this(key, type, filesystemMetadata, null, null, null);
    }

    private HoodieMetadataPayload(String key, HoodieMetadataBloomFilter metadataBloomFilter) {
        this(key, 4, null, metadataBloomFilter, null, null);
    }

    private HoodieMetadataPayload(String key, HoodieMetadataColumnStats columnStats) {
        this(key, 3, null, null, columnStats, null);
    }

    private HoodieMetadataPayload(String key, HoodieRecordIndexInfo recordIndexMetadata) {
        this(key, 5, null, null, null, recordIndexMetadata);
    }

    protected HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata, HoodieMetadataBloomFilter metadataBloomFilter, HoodieMetadataColumnStats columnStats, HoodieRecordIndexInfo recordIndexMetadata) {
        this.key = key;
        this.type = type;
        this.filesystemMetadata = filesystemMetadata;
        this.bloomFilterMetadata = metadataBloomFilter;
        this.columnStatMetadata = columnStats;
        this.recordIndexMetadata = recordIndexMetadata;
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions) {
        return HoodieMetadataPayload.createPartitionListRecord(partitions, false);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions, boolean isDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        partitions.forEach(partition -> fileInfo.put(HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition(partition), new HoodieMetadataFileInfo(0L, isDeleted)));
        HoodieKey key = new HoodieKey("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 1, fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionFilesRecord(String partition, Map<String, Long> filesAdded, List<String> filesDeleted) {
        String partitionIdentifier = HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition(partition);
        int size = filesAdded.size() + filesDeleted.size();
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>(size, 1.0f);
        filesAdded.forEach((fileName, fileSize) -> {
            ValidationUtils.checkState((fileSize > 0L ? 1 : 0) != 0);
            fileInfo.put((String)fileName, new HoodieMetadataFileInfo((Long)fileSize, false));
        });
        filesDeleted.forEach(fileName -> fileInfo.put((String)fileName, DELETE_FILE_METADATA));
        HoodieKey key = new HoodieKey(partitionIdentifier, MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 2, fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createBloomFilterMetadataRecord(String partitionName, String baseFileName, String timestamp, String bloomFilterType, ByteBuffer bloomFilter, boolean isDeleted) {
        ValidationUtils.checkArgument((!baseFileName.contains("/") && FSUtils.isBaseFile(new StoragePath(baseFileName)) ? 1 : 0) != 0, (String)("Invalid base file '" + baseFileName + "' for MetaIndexBloomFilter!"));
        String bloomFilterIndexKey = HoodieMetadataPayload.getBloomFilterRecordKey(partitionName, baseFileName);
        HoodieKey key = new HoodieKey(bloomFilterIndexKey, MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
        HoodieMetadataBloomFilter metadataBloomFilter = new HoodieMetadataBloomFilter(bloomFilterType, timestamp, bloomFilter, isDeleted);
        HoodieMetadataPayload metadataPayload = new HoodieMetadataPayload(key.getRecordKey(), metadataBloomFilter);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, metadataPayload);
    }

    @Override
    public HoodieMetadataPayload preCombine(HoodieMetadataPayload previousRecord) {
        if (this.isDeletedRecord) {
            return this;
        }
        if (previousRecord.isDeletedRecord) {
            return this;
        }
        ValidationUtils.checkArgument((previousRecord.type == this.type ? 1 : 0) != 0, (String)("Cannot combine " + previousRecord.type + " with " + this.type));
        ValidationUtils.checkArgument((boolean)previousRecord.key.equals(this.key), (String)("Cannot combine " + previousRecord.key + " with " + this.key + " as the keys differ"));
        switch (this.type) {
            case 1: 
            case 2: {
                Map<String, HoodieMetadataFileInfo> combinedFileInfo = this.combineFileSystemMetadata(previousRecord);
                return new HoodieMetadataPayload(this.key, this.type, combinedFileInfo);
            }
            case 4: {
                HoodieMetadataBloomFilter combineBloomFilterMetadata = this.combineBloomFilterMetadata(previousRecord);
                return new HoodieMetadataPayload(this.key, combineBloomFilterMetadata);
            }
            case 3: {
                return new HoodieMetadataPayload(this.key, this.combineColumnStatsMetadata(previousRecord));
            }
            case 5: {
                return this;
            }
        }
        throw new HoodieMetadataException("Unknown type of HoodieMetadataPayload: " + this.type);
    }

    private static String getBloomFilterRecordKey(String partitionName, String fileName) {
        return new PartitionIndexID(HoodieTableMetadataUtil.getBloomFilterIndexPartitionIdentifier(partitionName)).asBase64EncodedString().concat(new FileIndexID(fileName).asBase64EncodedString());
    }

    private HoodieMetadataBloomFilter combineBloomFilterMetadata(HoodieMetadataPayload previousRecord) {
        return this.bloomFilterMetadata;
    }

    private HoodieMetadataColumnStats combineColumnStatsMetadata(HoodieMetadataPayload previousRecord) {
        ValidationUtils.checkArgument((boolean)previousRecord.getColumnStatMetadata().isPresent());
        ValidationUtils.checkArgument((boolean)this.getColumnStatMetadata().isPresent());
        HoodieMetadataColumnStats previousColStatsRecord = (HoodieMetadataColumnStats)((Object)previousRecord.getColumnStatMetadata().get());
        HoodieMetadataColumnStats newColumnStatsRecord = (HoodieMetadataColumnStats)((Object)this.getColumnStatMetadata().get());
        return HoodieMetadataPayload.mergeColumnStatsRecords(previousColStatsRecord, newColumnStatsRecord);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema, Properties properties) throws IOException {
        HoodieMetadataPayload anotherPayload = new HoodieMetadataPayload((Option<GenericRecord>)Option.of((Object)((GenericRecord)oldRecord)));
        HoodieMetadataPayload combinedPayload = this.preCombine(anotherPayload);
        return combinedPayload.getInsertValue(schema, properties);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema) throws IOException {
        return this.combineAndGetUpdateValue(oldRecord, schema, new Properties());
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schemaIgnored, Properties propertiesIgnored) throws IOException {
        if (this.key == null || this.isDeletedRecord) {
            return Option.empty();
        }
        HoodieMetadataRecord record = new HoodieMetadataRecord(this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata, this.recordIndexMetadata);
        return Option.of((Object)((Object)record));
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        return this.getInsertValue(schema, new Properties());
    }

    public List<String> getFilenames() {
        return this.filterFileInfoEntries(false).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public List<String> getDeletions() {
        return this.filterFileInfoEntries(true).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public Option<HoodieMetadataBloomFilter> getBloomFilterMetadata() {
        if (this.bloomFilterMetadata == null) {
            return Option.empty();
        }
        return Option.of((Object)((Object)this.bloomFilterMetadata));
    }

    public Option<HoodieMetadataColumnStats> getColumnStatMetadata() {
        if (this.columnStatMetadata == null) {
            return Option.empty();
        }
        return Option.of((Object)((Object)this.columnStatMetadata));
    }

    public List<StoragePathInfo> getFileList(HoodieStorage storage, StoragePath partitionPath) {
        long blockSize = storage.getDefaultBlockSize(partitionPath);
        return this.filterFileInfoEntries(false).map(e -> new StoragePathInfo(new StoragePath(partitionPath, (String)e.getKey()), ((HoodieMetadataFileInfo)((Object)((Object)e.getValue()))).getSize().longValue(), false, 0, blockSize, 0L)).collect(Collectors.toList());
    }

    private Stream<Map.Entry<String, HoodieMetadataFileInfo>> filterFileInfoEntries(boolean isDeleted) {
        if (this.filesystemMetadata == null) {
            return Stream.empty();
        }
        return this.filesystemMetadata.entrySet().stream().filter(e -> ((HoodieMetadataFileInfo)((Object)((Object)e.getValue()))).getIsDeleted() == isDeleted);
    }

    private Map<String, HoodieMetadataFileInfo> combineFileSystemMetadata(HoodieMetadataPayload previousRecord) {
        HashMap<String, HoodieMetadataFileInfo> combinedFileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        if (previousRecord.filesystemMetadata != null) {
            combinedFileInfo.putAll(previousRecord.filesystemMetadata);
        }
        if (this.filesystemMetadata != null) {
            HoodieMetadataPayload.validatePayload(this.type, this.filesystemMetadata);
            this.filesystemMetadata.forEach((key, fileInfo) -> combinedFileInfo.merge((String)key, (HoodieMetadataFileInfo)((Object)fileInfo), (oldFileInfo, newFileInfo) -> {
                if (newFileInfo.getIsDeleted().booleanValue()) {
                    if (oldFileInfo.getIsDeleted().booleanValue()) {
                        LOG.warn("A file is repeatedly deleted in the files partition of the metadata table: " + key);
                        return newFileInfo;
                    }
                    return null;
                }
                return new HoodieMetadataFileInfo(Math.max(newFileInfo.getSize(), oldFileInfo.getSize()), false);
            }));
        }
        return combinedFileInfo;
    }

    public static String getBloomFilterIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID) {
        return partitionIndexID.asBase64EncodedString().concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID, ColumnIndexID columnIndexID) {
        return columnIndexID.asBase64EncodedString().concat(partitionIndexID.asBase64EncodedString()).concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(String partitionName, HoodieColumnRangeMetadata<Comparable> columnRangeMetadata) {
        PartitionIndexID partitionIndexID = new PartitionIndexID(HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier(partitionName));
        FileIndexID fileIndexID = new FileIndexID(new StoragePath(columnRangeMetadata.getFilePath()).getName());
        ColumnIndexID columnIndexID = new ColumnIndexID(columnRangeMetadata.getColumnName());
        return HoodieMetadataPayload.getColumnStatsIndexKey(partitionIndexID, fileIndexID, columnIndexID);
    }

    public static Stream<HoodieRecord> createColumnStatsRecords(String partitionName, Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList, boolean isDeleted) {
        return columnRangeMetadataList.stream().map(columnRangeMetadata -> {
            HoodieKey key = new HoodieKey(HoodieMetadataPayload.getColumnStatsIndexKey(partitionName, columnRangeMetadata), MetadataPartitionType.COLUMN_STATS.getPartitionPath());
            HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), HoodieMetadataColumnStats.newBuilder().setFileName(new StoragePath(columnRangeMetadata.getFilePath()).getName()).setColumnName(columnRangeMetadata.getColumnName()).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMinValue())).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(columnRangeMetadata.getMaxValue())).setNullCount(columnRangeMetadata.getNullCount()).setValueCount(columnRangeMetadata.getValueCount()).setTotalSize(columnRangeMetadata.getTotalSize()).setTotalUncompressedSize(columnRangeMetadata.getTotalUncompressedSize()).setIsDeleted(isDeleted).build());
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        });
    }

    private static HoodieMetadataColumnStats mergeColumnStatsRecords(HoodieMetadataColumnStats prevColumnStats, HoodieMetadataColumnStats newColumnStats) {
        ValidationUtils.checkArgument((boolean)Objects.equals(prevColumnStats.getFileName(), newColumnStats.getFileName()));
        ValidationUtils.checkArgument((boolean)Objects.equals(prevColumnStats.getColumnName(), newColumnStats.getColumnName()));
        if (newColumnStats.getIsDeleted().booleanValue() || prevColumnStats.getIsDeleted().booleanValue()) {
            return newColumnStats;
        }
        Comparable minValue = Stream.of(HoodieAvroUtils.unwrapAvroValueWrapper(prevColumnStats.getMinValue()), HoodieAvroUtils.unwrapAvroValueWrapper(newColumnStats.getMinValue())).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
        Comparable maxValue = Stream.of(HoodieAvroUtils.unwrapAvroValueWrapper(prevColumnStats.getMaxValue()), HoodieAvroUtils.unwrapAvroValueWrapper(newColumnStats.getMaxValue())).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
        return HoodieMetadataColumnStats.newBuilder(METADATA_COLUMN_STATS_BUILDER_STUB.get()).setFileName(newColumnStats.getFileName()).setColumnName(newColumnStats.getColumnName()).setMinValue(HoodieAvroUtils.wrapValueIntoAvro(minValue)).setMaxValue(HoodieAvroUtils.wrapValueIntoAvro(maxValue)).setValueCount(prevColumnStats.getValueCount() + newColumnStats.getValueCount()).setNullCount(prevColumnStats.getNullCount() + newColumnStats.getNullCount()).setTotalSize(prevColumnStats.getTotalSize() + newColumnStats.getTotalSize()).setTotalUncompressedSize(prevColumnStats.getTotalUncompressedSize() + newColumnStats.getTotalUncompressedSize()).setIsDeleted(newColumnStats.getIsDeleted()).build();
    }

    public static HoodieRecord<HoodieMetadataPayload> createRecordIndexUpdate(String recordKey, String partition, String fileId, String instantTime, int fileIdEncoding) {
        HoodieKey key = new HoodieKey(recordKey, MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        long instantTimeMillis = -1L;
        try {
            instantTimeMillis = HoodieActiveTimeline.parseDateFromInstantTime(instantTime).getTime();
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to create metadata payload for record index. Instant time parsing for " + instantTime + " failed ", e);
        }
        if (fileIdEncoding == 0) {
            int fileIndex;
            UUID uuid;
            try {
                if (fileId.length() == 36) {
                    uuid = UUID.fromString(fileId);
                    fileIndex = -1;
                } else {
                    int index = fileId.lastIndexOf("-");
                    uuid = UUID.fromString(fileId.substring(0, index));
                    fileIndex = Integer.parseInt(fileId.substring(index + 1));
                }
            }
            catch (Exception e) {
                throw new HoodieMetadataException(String.format("Invalid UUID or index: fileID=%s, partition=%s, instantTIme=%s", fileId, partition, instantTime), e);
            }
            HoodieMetadataPayload payload = new HoodieMetadataPayload(recordKey, new HoodieRecordIndexInfo(partition, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), fileIndex, "", instantTimeMillis, 0));
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        }
        HoodieMetadataPayload payload = new HoodieMetadataPayload(recordKey, new HoodieRecordIndexInfo(partition, -1L, -1L, -1, fileId, instantTimeMillis, 1));
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord createRecordIndexDelete(String recordKey) {
        HoodieKey key = new HoodieKey(recordKey, MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        return new HoodieAvroRecord<EmptyHoodieRecordPayload>(key, new EmptyHoodieRecordPayload());
    }

    public HoodieRecordGlobalLocation getRecordGlobalLocation() {
        return HoodieTableMetadataUtil.getLocationFromRecordIndexInfo(this.recordIndexMetadata);
    }

    public boolean isDeleted() {
        return this.isDeletedRecord;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HoodieMetadataPayload)) {
            return false;
        }
        HoodieMetadataPayload otherMetadataPayload = (HoodieMetadataPayload)other;
        return this.type == otherMetadataPayload.type && Objects.equals(this.key, otherMetadataPayload.key) && Objects.equals(this.filesystemMetadata, otherMetadataPayload.filesystemMetadata) && Objects.equals((Object)this.bloomFilterMetadata, (Object)otherMetadataPayload.bloomFilterMetadata) && Objects.equals((Object)this.columnStatMetadata, (Object)otherMetadataPayload.columnStatMetadata) && Objects.equals((Object)this.recordIndexMetadata, (Object)otherMetadataPayload.recordIndexMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieMetadataPayload {");
        sb.append("key=").append(this.key).append(", ");
        sb.append("type=").append(this.type).append(", ");
        switch (this.type) {
            case 1: 
            case 2: {
                sb.append("Files: {");
                sb.append("creations=").append(Arrays.toString(this.getFilenames().toArray())).append(", ");
                sb.append("deletions=").append(Arrays.toString(this.getDeletions().toArray())).append(", ");
                sb.append("}");
                break;
            }
            case 4: {
                ValidationUtils.checkState((boolean)this.getBloomFilterMetadata().isPresent());
                sb.append("BloomFilter: {");
                sb.append("bloom size: ").append(((HoodieMetadataBloomFilter)((Object)this.getBloomFilterMetadata().get())).getBloomFilter().array().length).append(", ");
                sb.append("timestamp: ").append(((HoodieMetadataBloomFilter)((Object)this.getBloomFilterMetadata().get())).getTimestamp()).append(", ");
                sb.append("deleted: ").append(((HoodieMetadataBloomFilter)((Object)this.getBloomFilterMetadata().get())).getIsDeleted());
                sb.append("}");
                break;
            }
            case 3: {
                ValidationUtils.checkState((boolean)this.getColumnStatMetadata().isPresent());
                sb.append("ColStats: {");
                sb.append(this.getColumnStatMetadata().get());
                sb.append("}");
                break;
            }
            case 5: {
                sb.append("RecordIndex: {");
                sb.append("location=").append(this.getRecordGlobalLocation());
                sb.append("}");
                break;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private static void validatePayload(int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        if (type == 2) {
            filesystemMetadata.forEach((fileName, fileInfo) -> ValidationUtils.checkState((fileInfo.getIsDeleted() != false || fileInfo.getSize() > 0L ? 1 : 0) != 0, (String)"Existing files should have size > 0"));
        }
    }

    private static <T> T getNestedFieldValue(GenericRecord record, String fieldName) {
        if (record.getSchema().getField(fieldName) == null) {
            return null;
        }
        return TypeUtils.unsafeCast(record.get(fieldName));
    }
}

