/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.orc.CompressionKind;

public class HoodieOrcConfig {
    public static final String AVRO_SCHEMA_METADATA_KEY = "orc.avro.schema";
    private final CompressionKind compressionKind;
    private final int stripeSize;
    private final int blockSize;
    private final long maxFileSize;
    private final StorageConfiguration<?> storageConf;
    private final BloomFilter bloomFilter;

    public HoodieOrcConfig(StorageConfiguration<?> storageConf, CompressionKind compressionKind, int stripeSize, int blockSize, long maxFileSize, BloomFilter bloomFilter) {
        this.storageConf = storageConf;
        this.compressionKind = compressionKind;
        this.stripeSize = stripeSize;
        this.blockSize = blockSize;
        this.maxFileSize = maxFileSize;
        this.bloomFilter = bloomFilter;
    }

    public StorageConfiguration<?> getStorageConf() {
        return this.storageConf;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean useBloomFilter() {
        return this.bloomFilter != null;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }
}

