/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.internal.schema.Type;

public class Types {
    private Types() {
    }

    public static class MapType
    extends Type.NestedType {
        private final Field keyField;
        private final Field valueField;
        private transient List<Field> fields = null;

        public static MapType get(int keyId, int valueId, Type keyType, Type valueType) {
            return new MapType(Field.get(keyId, "key", keyType), Field.get(valueId, "value", valueType));
        }

        public static MapType get(int keyId, int valueId, Type keyType, Type valueType, boolean isOptional) {
            return new MapType(Field.get(keyId, isOptional, "key", keyType), Field.get(valueId, isOptional, "value", valueType));
        }

        private MapType(Field keyField, Field valueField) {
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Type keyType() {
            return this.keyField.type();
        }

        public Type valueType() {
            return this.valueField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("key".equals(name)) {
                return this.keyField.type();
            }
            if ("value".equals(name)) {
                return this.valueField.type();
            }
            return null;
        }

        @Override
        public Field field(int id) {
            if (this.keyField.fieldId() == id) {
                return this.keyField;
            }
            if (this.valueField.fieldId() == id) {
                return this.valueField;
            }
            return null;
        }

        @Override
        public List<Field> fields() {
            if (this.fields == null) {
                this.fields = Arrays.asList(this.keyField, this.valueField);
            }
            return this.fields;
        }

        public int keyId() {
            return this.keyField.fieldId();
        }

        public int valueId() {
            return this.valueField.fieldId();
        }

        public boolean isValueOptional() {
            return this.valueField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.MAP;
        }

        public String toString() {
            return String.format("map<%s, %s>", this.keyField.type(), this.valueField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapType)) {
                return false;
            }
            MapType mapType = (MapType)o;
            if (!this.keyField.equals(mapType.keyField)) {
                return false;
            }
            return this.valueField.equals(mapType.valueField);
        }

        public int hashCode() {
            return Objects.hash(MapType.class, this.keyField, this.valueField);
        }
    }

    public static class ArrayType
    extends Type.NestedType {
        private final Field elementField;

        public static ArrayType get(int elementId, boolean isOptional, Type elementType) {
            return new ArrayType(Field.get(elementId, isOptional, "element", elementType));
        }

        private ArrayType(Field elementField) {
            this.elementField = elementField;
        }

        public Type elementType() {
            return this.elementField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("element".equals(name)) {
                return this.elementType();
            }
            return null;
        }

        @Override
        public Field field(int id) {
            if (this.elementField.fieldId() == id) {
                return this.elementField;
            }
            return null;
        }

        @Override
        public List<Field> fields() {
            return Arrays.asList(this.elementField);
        }

        public int elementId() {
            return this.elementField.fieldId();
        }

        public boolean isElementOptional() {
            return this.elementField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.ARRAY;
        }

        public String toString() {
            return String.format("list<%s>", this.elementField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType listType = (ArrayType)o;
            return this.elementField.equals(listType.elementField);
        }

        public int hashCode() {
            return Objects.hash(ArrayType.class, this.elementField);
        }
    }

    public static class RecordType
    extends Type.NestedType {
        private final String name;
        private final Field[] fields;
        private transient Map<String, Field> nameToFields = null;
        private transient Map<String, Field> lowercaseNameToFields = null;
        private transient Map<Integer, Field> idToFields = null;

        private RecordType(List<Field> fields, String name) {
            this.name = name;
            this.fields = fields.toArray(new Field[0]);
        }

        @Override
        public List<Field> fields() {
            return Arrays.asList(this.fields);
        }

        public Field fieldByName(String name) {
            if (this.nameToFields == null) {
                this.nameToFields = Arrays.stream(this.fields).collect(Collectors.toMap(Field::name, field -> field));
            }
            return this.nameToFields.get(name);
        }

        public Field fieldByNameCaseInsensitive(String name) {
            if (this.lowercaseNameToFields == null) {
                this.lowercaseNameToFields = Arrays.stream(this.fields).collect(Collectors.toMap(field -> ((Field)field).name.toLowerCase(Locale.ROOT), field -> field));
            }
            return this.lowercaseNameToFields.get(name.toLowerCase(Locale.ROOT));
        }

        @Override
        public Field field(int id) {
            if (this.idToFields == null) {
                this.idToFields = Arrays.stream(this.fields).collect(Collectors.toMap(Field::fieldId, field -> field));
            }
            return this.idToFields.get(id);
        }

        @Override
        public Type fieldType(String name) {
            Field field = this.fieldByNameCaseInsensitive(name);
            if (field != null) {
                return field.type();
            }
            return null;
        }

        public String name() {
            return this.name;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.RECORD;
        }

        public String toString() {
            return String.format("Record<%s>", Arrays.stream(this.fields).map(f -> f.toString()).collect(Collectors.joining("-")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RecordType)) {
                return false;
            }
            RecordType that = (RecordType)o;
            return Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Objects.hash(Field.class, Arrays.hashCode(this.fields));
        }

        public static RecordType get(List<Field> fields) {
            return new RecordType(fields, null);
        }

        public static RecordType get(List<Field> fields, String recordName) {
            return new RecordType(fields, recordName);
        }

        public static RecordType get(Field ... fields) {
            return new RecordType(Arrays.asList(fields), null);
        }
    }

    public static class Field
    implements Serializable {
        private final boolean isOptional;
        private final int id;
        private final String name;
        private final Type type;
        private final String doc;
        private final Object defaultValue;

        public static Field get(int id, boolean isOptional, String name, Type type, String doc, Object defaultValue) {
            return new Field(isOptional, id, name, type, doc, defaultValue);
        }

        public static Field get(int id, boolean isOptional, String name, Type type, String doc) {
            return new Field(isOptional, id, name, type, doc, null);
        }

        public static Field get(int id, boolean isOptional, String name, Type type) {
            return new Field(isOptional, id, name, type, null, null);
        }

        public static Field get(int id, String name, Type type) {
            return new Field(true, id, name, type, null, null);
        }

        private Field(boolean isOptional, int id, String name, Type type, String doc, Object defaultValue) {
            this.isOptional = isOptional;
            this.id = id;
            this.name = name;
            this.type = type;
            this.doc = doc;
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public int fieldId() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public String doc() {
            return this.doc;
        }

        public String toString() {
            return String.format("%d: %s: %s %s", this.id, this.name, this.isOptional ? "optional" : "required", this.type) + (this.doc != null ? " (" + this.doc + ")" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field that = (Field)o;
            if (this.isOptional != that.isOptional) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!Objects.equals(this.doc, that.doc)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(Field.class, this.id, this.isOptional, this.name, this.type);
        }
    }

    public static class UUIDType
    extends Type.PrimitiveType {
        private static final UUIDType INSTANCE = new UUIDType();

        public static UUIDType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.UUID;
        }

        public String toString() {
            return "uuid";
        }
    }

    public static class DecimalType
    extends Type.PrimitiveType {
        private final int scale;
        private final int precision;

        public static DecimalType get(int precision, int scale) {
            return new DecimalType(precision, scale);
        }

        private DecimalType(int precision, int scale) {
            this.scale = scale;
            this.precision = precision;
        }

        public boolean isWiderThan(Type.PrimitiveType other) {
            if (other instanceof DecimalType) {
                DecimalType dt = (DecimalType)other;
                return this.precision - this.scale >= dt.precision - dt.scale && this.scale > dt.scale;
            }
            if (other instanceof IntType) {
                return this.isWiderThan(DecimalType.get(10, 0));
            }
            return false;
        }

        public boolean isTighterThan(Type.PrimitiveType other) {
            if (other instanceof DecimalType) {
                DecimalType dt = (DecimalType)other;
                return this.precision - this.scale <= dt.precision - dt.scale && this.scale <= dt.scale;
            }
            if (other instanceof IntType) {
                return this.isTighterThan(DecimalType.get(10, 0));
            }
            return false;
        }

        public int scale() {
            return this.scale;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DECIMAL;
        }

        public String toString() {
            return String.format("decimal(%d, %d)", this.precision, this.scale);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DecimalType)) {
                return false;
            }
            DecimalType that = (DecimalType)o;
            if (this.scale != that.scale) {
                return false;
            }
            return this.precision == that.precision;
        }

        @Override
        public int hashCode() {
            return Objects.hash(DecimalType.class, this.scale, this.precision);
        }
    }

    public static class FixedType
    extends Type.PrimitiveType {
        private final int size;

        public static FixedType getFixed(int size) {
            return new FixedType(size);
        }

        private FixedType(int length) {
            this.size = length;
        }

        public int getFixedSize() {
            return this.size;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FIXED;
        }

        public String toString() {
            return String.format("fixed[%d]", this.size);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedType)) {
                return false;
            }
            FixedType fixedType = (FixedType)o;
            return this.size == fixedType.size;
        }

        @Override
        public int hashCode() {
            return Objects.hash(FixedType.class, this.size);
        }
    }

    public static class BinaryType
    extends Type.PrimitiveType {
        private static final BinaryType INSTANCE = new BinaryType();

        public static BinaryType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BINARY;
        }

        public String toString() {
            return "binary";
        }
    }

    public static class StringType
    extends Type.PrimitiveType {
        private static final StringType INSTANCE = new StringType();

        public static StringType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.STRING;
        }

        public String toString() {
            return "string";
        }
    }

    public static class TimestampType
    extends Type.PrimitiveType {
        private static final TimestampType INSTANCE = new TimestampType();

        public static TimestampType get() {
            return INSTANCE;
        }

        private TimestampType() {
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP;
        }

        public String toString() {
            return "timestamp";
        }
    }

    public static class TimeType
    extends Type.PrimitiveType {
        private static final TimeType INSTANCE = new TimeType();

        public static TimeType get() {
            return INSTANCE;
        }

        private TimeType() {
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIME;
        }

        public String toString() {
            return "time";
        }
    }

    public static class DateType
    extends Type.PrimitiveType {
        private static final DateType INSTANCE = new DateType();

        public static DateType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DATE;
        }

        public String toString() {
            return "date";
        }
    }

    public static class DoubleType
    extends Type.PrimitiveType {
        private static final DoubleType INSTANCE = new DoubleType();

        public static DoubleType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DOUBLE;
        }

        public String toString() {
            return "double";
        }
    }

    public static class FloatType
    extends Type.PrimitiveType {
        private static final FloatType INSTANCE = new FloatType();

        public static FloatType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FLOAT;
        }

        public String toString() {
            return "float";
        }
    }

    public static class LongType
    extends Type.PrimitiveType {
        private static final LongType INSTANCE = new LongType();

        public static LongType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.LONG;
        }

        public String toString() {
            return "long";
        }
    }

    public static class IntType
    extends Type.PrimitiveType {
        private static final IntType INSTANCE = new IntType();

        public static IntType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.INT;
        }

        public String toString() {
            return "int";
        }
    }

    public static class BooleanType
    extends Type.PrimitiveType {
        private static final BooleanType INSTANCE = new BooleanType();

        public static BooleanType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BOOLEAN;
        }

        public String toString() {
            return "boolean";
        }
    }
}

