/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class Comparators {
    private static final Map<Type, Comparator<?>> COMPARATORS = Collections.unmodifiableMap(new HashMap<Type, Comparator<?>>(){
        {
            this.put(Types.BooleanType.get(), Comparator.naturalOrder());
            this.put(Types.IntType.get(), Comparator.naturalOrder());
            this.put(Types.LongType.get(), Comparator.naturalOrder());
            this.put(Types.FloatType.get(), Comparator.naturalOrder());
            this.put(Types.DoubleType.get(), Comparator.naturalOrder());
            this.put(Types.DateType.get(), Comparator.naturalOrder());
            this.put(Types.TimeType.get(), Comparator.naturalOrder());
            this.put(Types.TimestampType.get(), Comparator.naturalOrder());
            this.put(Types.StringType.get(), Comparator.naturalOrder());
            this.put(Types.UUIDType.get(), Comparator.naturalOrder());
        }
    });

    public static <T> Comparator<T> forType(Type.PrimitiveType type) {
        return (Comparator)Option.ofNullable(COMPARATORS.get(type)).orElseThrow(() -> new UnsupportedOperationException("The desired type " + type + " doesn't support comparator yet"));
    }
}

